/* Copyright (c) V-Nova International Limited 2023-2025. All rights reserved.
 * This software is licensed under the BSD-3-Clause-Clear License by V-Nova Limited.
 * No patent licenses are granted under this license. For enquiries about patent licenses,
 * please contact legal@v-nova.com.
 * The LCEVCdec software is a stand-alone project and is NOT A CONTRIBUTION to any other project.
 * If the software is incorporated into another project, THE TERMS OF THE BSD-3-CLAUSE-CLEAR LICENSE
 * AND THE ADDITIONAL LICENSING INFORMATION CONTAINED IN THIS FILE MUST BE MAINTAINED, AND THE
 * SOFTWARE DOES NOT AND MUST NOT ADOPT THE LICENSE OF THE INCORPORATING PROJECT. However, the
 * software may be incorporated into a project under a compatible license provided the requirements
 * of the BSD-3-Clause-Clear license are respected, and V-Nova Limited remains
 * licensor of the software ONLY UNDER the BSD-3-Clause-Clear license (not the compatible license).
 * ANY ONWARD DISTRIBUTION, WHETHER STAND-ALONE OR AS PART OF ANY OTHER PROJECT, REMAINS SUBJECT TO
 * THE EXCLUSION OF PATENT LICENSES PROVISION OF THE BSD-3-CLAUSE-CLEAR LICENSE. */

#ifndef VN_LCEVC_PIPELINE_LEGACY_DATA_H
#define VN_LCEVC_PIPELINE_LEGACY_DATA_H

#include <cstddef>
#include <cstdint>
#include <vector>

// These were generated by encoding the "footballer" yuv with the ERP, then printing to command
// line (in the format of a c++ initializer list).
static const size_t kEnhancementSizes[3] = {253, 308, 80};
static const std::vector<uint8_t> kValidEnhancements[3] = {
    {
        0,   0,   1,   123, 255, 229, 7,   0,   4,   180, 0,   80,  0,   1,   64,  4,   64,
        225, 13,  53,  67,  224, 128, 31,  6,   216, 57,  80,  15,  209, 2,   73,  226, 20,
        50,  12,  37,  10,  13,  10,  12,  26,  1,   26,  2,   14,  36,  0,   1,   30,  12,
        12,  4,   66,  227, 129, 62,  85,  85,  85,  85,  85,  119, 217, 85,  24,  192, 129,
        234, 52,  194, 7,   194, 129, 210, 82,  194, 157, 110, 190, 52,  188, 157, 18,  188,
        60,  188, 131, 251, 59,  8,   192, 131, 249, 3,   194, 131, 251, 59,  11,  192, 131,
        179, 16,  194, 151, 30,  194, 132, 170, 15,  129, 6,   17,  138, 60,  39,  201, 8,
        162, 43,  169, 120, 175, 134, 4,   194, 24,  143, 255, 33,  169, 166, 187, 48,  166,
        6,   54,  97,  176, 193, 128, 1,   53,  107, 181, 0,   0,   192, 0,   48,  0,   219,
        48,  48,  20,  178, 80,  192, 12,  0,   0,   3,   0,   3,   0,   0,   3,   0,   0,
        3,   0,   0,   3,   0,   0,   3,   0,   0,   62,  216, 176, 87,  191, 74,  67,  210,
        34,  100, 69,  235, 217, 156, 136, 136, 141, 86,  59,  124, 27,  123, 229, 187, 121,
        254, 115, 124, 190, 119, 235, 217, 68,  85,  26,  210, 80,  207, 45,  24,  54,  152,
        7,   104, 78,  21,  4,   164, 7,   41,  211, 61,  232, 30,  102, 115, 14,  16,  71,
        202, 9,   57,  19,  135, 212, 134, 138, 53,  110, 53,  245, 105, 48,  128,
    },
    {
        0,   0,   1,   121, 255, 130, 0,   11,  57,  66,  227, 130, 34,  85,  85,  85,  85,  85,
        85,  89,  85,  192, 129, 78,  17,  207, 58,  103, 140, 248, 161, 4,   70,  140, 146, 37,
        211, 188, 151, 203, 2,   225, 12,  75,  140, 178, 39,  254, 51,  209, 53,  148, 171, 204,
        12,  83,  1,   152, 192, 1,   134, 2,   203, 187, 201, 177, 89,  118, 187, 22,  181, 128,
        0,   0,   5,   150, 5,   128, 1,   11,  44,  181, 128, 44,  0,   0,   176, 0,   0,   3,
        0,   0,   3,   0,   0,   3,   0,   0,   3,   0,   11,  11,  0,   90,  11,  192, 26,  244,
        23,  192, 215, 158, 169, 168, 53,  116, 94,  119, 219, 129, 175, 98,  90,  224, 182, 72,
        51,  4,   195, 181, 62,  215, 82,  231, 90,  53,  100, 165, 117, 89,  101, 217, 69,  161,
        8,   184, 88,  161, 8,   184, 44,  89,  4,   36,  99,  24,  86,  33,  8,   99,  99,  10,
        219, 67,  90,  113, 13,  0,   230, 87,  128, 198, 201, 136, 64,  35,  99,  213, 94,  245,
        221, 117, 85,  93,  89,  94,  173, 228, 234, 223, 199, 147, 64,  181, 135, 88,  148, 117,
        120, 32,  134, 19,  26,  195, 2,   117, 16,  214, 207, 105, 46,  117, 101, 146, 170, 187,
        190, 117, 95,  85,  60,  82,  109, 165, 54,  150, 219, 109, 180, 182, 153, 22,  112, 128,
        72,  0,   132, 11,  1,   130, 79,  1,   130, 60,  1,   131, 168, 103, 2,   64,  1,   151,
        0,   2,   136, 105, 1,   62,  1,   59,  1,   64,  1,   1,   1,   131, 48,  3,   64,  1,
        2,   1,   8,   1,   51,  4,   1,   1,   1,   2,   57,  1,   4,   3,   1,   2,   129, 124,
        1,   150, 105, 1,   58,  7,   129, 124, 1,   1,   1,   131, 58,  2,   61,  1,   131, 249,
        119, 128,
    },
    {
        0,   0,   1,   121, 255, 130, 0,   19,  13,  66,  227, 67,  85,  85,  85,  85,
        85,  85,  89,  85,  192, 28,  8,   197, 62,  144, 139, 235, 2,   194, 191, 241,
        140, 129, 113, 184, 224, 222, 131, 66,  44,  152, 5,   48,  254, 215, 236, 130,
        141, 236, 28,  0,   131, 183, 112, 1,   133, 31,  1,   132, 111, 1,   48,  4,
        133, 71,  1,   137, 113, 1,   133, 18,  1,   136, 93,  1,   132, 147, 98,  128,
    },
};

// kValidEnhancements, but they ALL have invalid start codes (in various ways)
static const std::vector<uint8_t> kEnhancementsBadStartCodes[3] = {
    {
        '0', '0', '1', 123, 255, 229, 7,   0,   4,   180, 0,   80,  0,   1,   64,  4,   64,
        225, 13,  53,  67,  224, 128, 31,  6,   216, 57,  80,  15,  209, 2,   73,  226, 20,
        50,  12,  37,  10,  13,  10,  12,  26,  1,   26,  2,   14,  36,  0,   1,   30,  12,
        12,  4,   66,  227, 129, 62,  85,  85,  85,  85,  85,  119, 217, 85,  24,  192, 129,
        234, 52,  194, 7,   194, 129, 210, 82,  194, 157, 110, 190, 52,  188, 157, 18,  188,
        60,  188, 131, 251, 59,  8,   192, 131, 249, 3,   194, 131, 251, 59,  11,  192, 131,
        179, 16,  194, 151, 30,  194, 132, 170, 15,  129, 6,   17,  138, 60,  39,  201, 8,
        162, 43,  169, 120, 175, 134, 4,   194, 24,  143, 255, 33,  169, 166, 187, 48,  166,
        6,   54,  97,  176, 193, 128, 1,   53,  107, 181, 0,   0,   192, 0,   48,  0,   219,
        48,  48,  20,  178, 80,  192, 12,  0,   0,   3,   0,   3,   0,   0,   3,   0,   0,
        3,   0,   0,   3,   0,   0,   3,   0,   0,   62,  216, 176, 87,  191, 74,  67,  210,
        34,  100, 69,  235, 217, 156, 136, 136, 141, 86,  59,  124, 27,  123, 229, 187, 121,
        254, 115, 124, 190, 119, 235, 217, 68,  85,  26,  210, 80,  207, 45,  24,  54,  152,
        7,   104, 78,  21,  4,   164, 7,   41,  211, 61,  232, 30,  102, 115, 14,  16,  71,
        202, 9,   57,  19,  135, 212, 134, 138, 53,  110, 53,  245, 105, 48,  128,
    },
    {
        0,   0,   3,   121, 255, 130, 0,   11,  57,  66,  227, 130, 34,  85,  85,  85,  85,  85,
        85,  89,  85,  192, 129, 78,  17,  207, 58,  103, 140, 248, 161, 4,   70,  140, 146, 37,
        211, 188, 151, 203, 2,   225, 12,  75,  140, 178, 39,  254, 51,  209, 53,  148, 171, 204,
        12,  83,  1,   152, 192, 1,   134, 2,   203, 187, 201, 177, 89,  118, 187, 22,  181, 128,
        0,   0,   5,   150, 5,   128, 1,   11,  44,  181, 128, 44,  0,   0,   176, 0,   0,   3,
        0,   0,   3,   0,   0,   3,   0,   0,   3,   0,   11,  11,  0,   90,  11,  192, 26,  244,
        23,  192, 215, 158, 169, 168, 53,  116, 94,  119, 219, 129, 175, 98,  90,  224, 182, 72,
        51,  4,   195, 181, 62,  215, 82,  231, 90,  53,  100, 165, 117, 89,  101, 217, 69,  161,
        8,   184, 88,  161, 8,   184, 44,  89,  4,   36,  99,  24,  86,  33,  8,   99,  99,  10,
        219, 67,  90,  113, 13,  0,   230, 87,  128, 198, 201, 136, 64,  35,  99,  213, 94,  245,
        221, 117, 85,  93,  89,  94,  173, 228, 234, 223, 199, 147, 64,  181, 135, 88,  148, 117,
        120, 32,  134, 19,  26,  195, 2,   117, 16,  214, 207, 105, 46,  117, 101, 146, 170, 187,
        190, 117, 95,  85,  60,  82,  109, 165, 54,  150, 219, 109, 180, 182, 153, 22,  112, 128,
        72,  0,   132, 11,  1,   130, 79,  1,   130, 60,  1,   131, 168, 103, 2,   64,  1,   151,
        0,   2,   136, 105, 1,   62,  1,   59,  1,   64,  1,   1,   1,   131, 48,  3,   64,  1,
        2,   1,   8,   1,   51,  4,   1,   1,   1,   2,   57,  1,   4,   3,   1,   2,   129, 124,
        1,   150, 105, 1,   58,  7,   129, 124, 1,   1,   1,   131, 58,  2,   61,  1,   131, 249,
        119, 128,
    },
    {
        255, 255, 255, 121, 255, 130, 0,   19,  13,  66,  227, 67,  85,  85,  85,  85,
        85,  85,  89,  85,  192, 28,  8,   197, 62,  144, 139, 235, 2,   194, 191, 241,
        140, 129, 113, 184, 224, 222, 131, 66,  44,  152, 5,   48,  254, 215, 236, 130,
        141, 236, 28,  0,   131, 183, 112, 1,   133, 31,  1,   132, 111, 1,   48,  4,
        133, 71,  1,   137, 113, 1,   133, 18,  1,   136, 93,  1,   132, 147, 98,  128,
    },
};

// kValidEnhancements, but TOTALLY arbitrary errors INSIDE the enhancements. The start and end are
// preserved (0,0,1 and 128). These were generated by randomly choosing whether to mess up a byte
// (with odds 5/6). If so, the byte was replaced with a random number, within uint8_t range
static const std::vector<uint8_t> kEnhancementsMessedUp[3] = {
    {
        0,   0,   1,   74,  158, 180, 105, 11,  25,  57,  0,   74,  80,  128, 124, 64,  119, 4,
        214, 177, 57,  108, 234, 122, 117, 128, 236, 190, 75,  202, 89,  80,  172, 121, 243, 75,
        144, 32,  0,   1,   227, 240, 16,  13,  61,  174, 59,  149, 163, 36,  114, 147, 41,  31,
        21,  214, 12,  213, 110, 251, 66,  185, 227, 0,   20,  50,  99,  85,  134, 20,  45,  225,
        117, 217, 158, 246, 222, 93,  116, 31,  83,  88,  145, 128, 129, 137, 54,  135, 194, 93,
        232, 110, 142, 178, 71,  230, 28,  18,  65,  188, 250, 99,  117, 131, 116, 134, 59,  14,
        195, 85,  125, 254, 219, 186, 53,  251, 184, 160, 169, 181, 243, 179, 190, 42,  233, 235,
        70,  194, 76,  2,   170, 121, 208, 64,  193, 17,  93,  82,  60,  95,  165, 15,  26,  188,
        43,  45,  196, 77,  253, 134, 162, 68,  72,  96,  21,  194, 85,  26,  177, 100, 56,  217,
        27,  54,  240, 147, 194, 36,  37,  251, 194, 107, 213, 100, 137, 67,  63,  21,  253, 91,
        95,  48,  54,  48,  152, 70,  178, 79,  198, 44,  204, 49,  173, 111, 65,  25,  179, 23,
        95,  113, 0,   90,  215, 201, 237, 60,  243, 95,  125, 142, 0,   158, 62,  5,   152, 176,
        193, 116, 144, 195, 38,  47,  34,  193, 100, 168, 22,  235, 189, 127, 251, 136, 188, 65,
        157, 148, 166, 168, 159, 120, 209, 138, 2,   11,  192, 231, 205, 181, 4,   140, 127, 19,
        5,   210, 44,  136, 126, 139, 136, 54,  234, 152, 127, 92,  62,  5,   25,  4,   160, 164,
        107, 244, 172, 167, 200, 18,  31,  39,  198, 40,  193, 71,  181, 231, 46,  212, 172, 135,
        130, 114, 134, 212, 6,   189, 158, 43,  30,  46,  48,  251, 128,
    },
    {
        0,   0,   1,   62,  26,  9,   36,  62,  57,  223, 240, 154, 127, 211, 106, 46,  35,  223,
        157, 218, 61,  85,  133, 192, 204, 197, 96,  164, 9,   147, 242, 0,   248, 39,  233, 120,
        70,  139, 199, 76,  51,  211, 91,  188, 10,  64,  250, 96,  114, 222, 137, 183, 92,  178,
        254, 230, 132, 221, 245, 10,  10,  25,  203, 51,  116, 101, 45,  96,  134, 38,  38,  203,
        126, 194, 98,  32,  55,  118, 167, 91,  22,  98,  200, 162, 57,  210, 68,  150, 11,  194,
        128, 47,  1,   6,   46,  175, 243, 30,  231, 134, 26,  176, 41,  142, 203, 136, 0,   24,
        0,   203, 3,   84,  195, 182, 178, 220, 0,   216, 3,   201, 115, 11,  37,  11,  175, 82,
        232, 245, 227, 26,  158, 244, 135, 5,   99,  112, 167, 158, 107, 15,  179, 119, 87,  91,
        151, 175, 43,  161, 230, 218, 16,  144, 98,  4,   154, 24,  190, 62,  128, 134, 21,  231,
        142, 136, 53,  169, 255, 47,  19,  205, 166, 152, 69,  63,  161, 239, 8,   152, 184, 83,
        248, 160, 8,   136, 74,  238, 89,  159, 105, 36,  99,  142, 204, 251, 70,  184, 195, 178,
        164, 97,  90,  153, 129, 130, 219, 26,  200, 98,  108, 2,   165, 36,  155, 99,  151, 213,
        123, 116, 30,  96,  12,  55,  144, 89,  232, 6,   58,  135, 234, 49,  244, 89,  252, 29,
        245, 3,   39,  148, 130, 203, 62,  72,  93,  76,  243, 57,  95,  117, 41,  71,  214, 135,
        164, 95,  200, 161, 101, 103, 29,  170, 187, 98,  8,   211, 95,  4,   138, 122, 82,  60,
        27,  182, 54,  186, 42,  244, 125, 27,  41,  42,  165, 177, 128, 68,  153, 224, 198, 223,
        208, 167, 232, 39,  29,  207, 195, 185, 176, 17,  37,  12,  241, 57,  240, 191, 0,   186,
        133, 155, 213, 59,  242, 127, 132, 121, 110, 202, 165, 223, 107, 122, 1,   153, 204, 1,
        7,   8,   128, 56,  132, 12,  137, 217, 91,  244, 148, 1,   68,  4,   58,  168, 198, 2,
        130, 23,  150, 142, 117, 8,   94,  230, 7,   184, 112, 239, 100, 216, 48,  87,  103, 210,
        208, 36,  131, 13,  83,  236, 128,
    },
    {
        0,   0,   1,   121, 72,  179, 254, 42,  88,  176, 175, 105, 67,  28, 27,  125, 68,  16,
        234, 112, 238, 3,   158, 199, 43,  197, 164, 134, 206, 19,  247, 2,  6,   143, 148, 1,
        92,  186, 113, 252, 91,  181, 31,  95,  112, 198, 89,  229, 99,  28, 21,  234, 171, 237,
        61,  16,  242, 163, 148, 171, 242, 95,  31,  150, 228, 132, 91,  99, 103, 56,  182, 254,
        190, 207, 139, 113, 43,  142, 117, 202, 1,   206, 187, 223, 27,  79, 131, 24,  128,
    },
};

#endif // VN_LCEVC_PIPELINE_LEGACY_DATA_H
