// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst.Rtp {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	[StructLayout(LayoutKind.Sequential)]
	public partial struct RTPBuffer : IEquatable<RTPBuffer> {

		private IntPtr _buffer;
		public Gst.Buffer Buffer {
			get {
				return _buffer == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (_buffer, typeof (Gst.Buffer), false);
			}
			set {
				_buffer = value == null ? IntPtr.Zero : value.Handle;
			}
		}
		public uint State;
		[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
		public IntPtr[] Data;
		[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
		public ulong[] Size;
		[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
		public Gst.MapInfo[] MapInfo;

		public static Gst.Rtp.RTPBuffer Zero = new Gst.Rtp.RTPBuffer ();

		public static Gst.Rtp.RTPBuffer New(IntPtr raw) {
			if (raw == IntPtr.Zero)
				return Gst.Rtp.RTPBuffer.Zero;
			return (Gst.Rtp.RTPBuffer) Marshal.PtrToStructure (raw, typeof (Gst.Rtp.RTPBuffer));
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_add_extension_onebyte_header(IntPtr raw, byte id, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex=3)]byte[] data, uint n_length);

		public bool AddExtensionOnebyteHeader(byte id, byte[] data) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			uint n_length = (uint)(data == null ? 0 : data.Length);
			bool raw_ret = gst_rtp_buffer_add_extension_onebyte_header(this_as_native, id, data, n_length);
			bool ret = raw_ret;
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_add_extension_twobytes_header(IntPtr raw, byte appbits, byte id, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex=4)]byte[] data, uint n_length);

		public bool AddExtensionTwobytesHeader(byte appbits, byte id, byte[] data) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			uint n_length = (uint)(data == null ? 0 : data.Length);
			bool raw_ret = gst_rtp_buffer_add_extension_twobytes_header(this_as_native, appbits, id, data, n_length);
			bool ret = raw_ret;
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_csrc(IntPtr raw, byte idx);

		public uint GetCsrc(byte idx) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			uint raw_ret = gst_rtp_buffer_get_csrc(this_as_native, idx);
			uint ret = raw_ret;
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern byte gst_rtp_buffer_get_csrc_count(IntPtr raw);

		public byte CsrcCount { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				byte raw_ret = gst_rtp_buffer_get_csrc_count(this_as_native);
				byte ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_get_extension(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_extension(IntPtr raw, bool extension);

		public bool Extension { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				bool raw_ret = gst_rtp_buffer_get_extension(this_as_native);
				bool ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_extension(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_get_extension_bytes(IntPtr raw, out ushort bits);

		public GLib.Bytes GetExtensionBytes(out ushort bits) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			IntPtr raw_ret = gst_rtp_buffer_get_extension_bytes(this_as_native, out bits);
			GLib.Bytes ret = new GLib.Bytes(raw_ret);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_header_len(IntPtr raw);

		public uint HeaderLen { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				uint raw_ret = gst_rtp_buffer_get_header_len(this_as_native);
				uint ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_get_marker(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_marker(IntPtr raw, bool marker);

		public bool Marker { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				bool raw_ret = gst_rtp_buffer_get_marker(this_as_native);
				bool ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_marker(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_packet_len(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_packet_len(IntPtr raw, uint len);

		public uint PacketLen { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				uint raw_ret = gst_rtp_buffer_get_packet_len(this_as_native);
				uint ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_packet_len(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_get_padding(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_padding(IntPtr raw, bool padding);

		public bool Padding { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				bool raw_ret = gst_rtp_buffer_get_padding(this_as_native);
				bool ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_padding(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_get_payload_buffer(IntPtr raw);

		public Gst.Buffer PayloadBuffer { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				IntPtr raw_ret = gst_rtp_buffer_get_payload_buffer(this_as_native);
				Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_get_payload_bytes(IntPtr raw);

		public GLib.Bytes PayloadBytes { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				IntPtr raw_ret = gst_rtp_buffer_get_payload_bytes(this_as_native);
				GLib.Bytes ret = new GLib.Bytes(raw_ret);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_payload_len(IntPtr raw);

		public uint PayloadLen { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				uint raw_ret = gst_rtp_buffer_get_payload_len(this_as_native);
				uint ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_get_payload_subbuffer(IntPtr raw, uint offset, uint len);

		public Gst.Buffer GetPayloadSubbuffer(uint offset, uint len) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			IntPtr raw_ret = gst_rtp_buffer_get_payload_subbuffer(this_as_native, offset, len);
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern byte gst_rtp_buffer_get_payload_type(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_payload_type(IntPtr raw, byte payload_type);

		public byte PayloadType { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				byte raw_ret = gst_rtp_buffer_get_payload_type(this_as_native);
				byte ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_payload_type(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ushort gst_rtp_buffer_get_seq(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_seq(IntPtr raw, ushort seq);

		public ushort Seq { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				ushort raw_ret = gst_rtp_buffer_get_seq(this_as_native);
				ushort ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_seq(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_ssrc(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_ssrc(IntPtr raw, uint ssrc);

		public uint Ssrc { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				uint raw_ret = gst_rtp_buffer_get_ssrc(this_as_native);
				uint ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_ssrc(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_get_timestamp(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_timestamp(IntPtr raw, uint timestamp);

		public uint Timestamp { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				uint raw_ret = gst_rtp_buffer_get_timestamp(this_as_native);
				uint ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_timestamp(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern byte gst_rtp_buffer_get_version(IntPtr raw);

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_version(IntPtr raw, byte version);

		public byte Version { 
			get {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				byte raw_ret = gst_rtp_buffer_get_version(this_as_native);
				byte ret = raw_ret;
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
				return ret;
			}
			set {
				IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
				System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
				gst_rtp_buffer_set_version(this_as_native, value);
				ReadNative (this_as_native, ref this);
				System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			}
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_pad_to(IntPtr raw, uint len);

		public void PadTo(uint len) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			gst_rtp_buffer_pad_to(this_as_native, len);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_remove_extension_data(IntPtr raw);

		public void RemoveExtensionData() {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			gst_rtp_buffer_remove_extension_data(this_as_native);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_set_csrc(IntPtr raw, byte idx, uint csrc);

		public void SetCsrc(byte idx, uint csrc) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			gst_rtp_buffer_set_csrc(this_as_native, idx, csrc);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_set_extension_data(IntPtr raw, ushort bits, ushort length);

		public bool SetExtensionData(ushort bits, ushort length) {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			bool raw_ret = gst_rtp_buffer_set_extension_data(this_as_native, bits, length);
			bool ret = raw_ret;
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_unmap(IntPtr raw);

		public void Unmap() {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			gst_rtp_buffer_unmap(this_as_native);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_rtp_buffer_allocate_data(IntPtr buffer, uint payload_len, byte pad_len, byte csrc_count);

		public static void AllocateData(Gst.Buffer buffer, uint payload_len, byte pad_len, byte csrc_count) {
			gst_rtp_buffer_allocate_data(buffer == null ? IntPtr.Zero : buffer.Handle, payload_len, pad_len, csrc_count);
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_calc_header_len(byte csrc_count);

		public static uint CalcHeaderLen(byte csrc_count) {
			uint raw_ret = gst_rtp_buffer_calc_header_len(csrc_count);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_calc_packet_len(uint payload_len, byte pad_len, byte csrc_count);

		public static uint CalcPacketLen(uint payload_len, byte pad_len, byte csrc_count) {
			uint raw_ret = gst_rtp_buffer_calc_packet_len(payload_len, pad_len, csrc_count);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_calc_payload_len(uint packet_len, byte pad_len, byte csrc_count);

		public static uint CalcPayloadLen(uint packet_len, byte pad_len, byte csrc_count) {
			uint raw_ret = gst_rtp_buffer_calc_payload_len(packet_len, pad_len, csrc_count);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_rtp_buffer_compare_seqnum(ushort seqnum1, ushort seqnum2);

		public static int CompareSeqnum(ushort seqnum1, ushort seqnum2) {
			int raw_ret = gst_rtp_buffer_compare_seqnum(seqnum1, seqnum2);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_rtp_buffer_default_clock_rate(byte payload_type);

		public static uint DefaultClockRate(byte payload_type) {
			uint raw_ret = gst_rtp_buffer_default_clock_rate(payload_type);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_rtp_buffer_ext_timestamp(ref ulong exttimestamp, uint timestamp);

		public static ulong ExtTimestamp(ref ulong exttimestamp, uint timestamp) {
			ulong raw_ret = gst_rtp_buffer_ext_timestamp(ref exttimestamp, timestamp);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_get_extension_onebyte_header_from_bytes(IntPtr bytes, ushort bit_pattern, byte id, uint nth, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex=5)]out IntPtr[] data, out uint size);

		public static bool GetExtensionOnebyteHeaderFromBytes(GLib.Bytes bytes, ushort bit_pattern, byte id, uint nth, out IntPtr[] data) {
			bool raw_ret = gst_rtp_buffer_get_extension_onebyte_header_from_bytes(bytes == null ? IntPtr.Zero : bytes.Handle, bit_pattern, id, nth, out data, out uint size);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_rtp_buffer_map(IntPtr buffer, int flags, IntPtr rtp);

		public static bool Map(Gst.Buffer buffer, Gst.MapFlags flags, out Gst.Rtp.RTPBuffer rtp) {
			IntPtr native_rtp = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gst.Rtp.RTPBuffer)));
			bool raw_ret = gst_rtp_buffer_map(buffer == null ? IntPtr.Zero : buffer.Handle, (int) flags, native_rtp);
			bool ret = raw_ret;
			rtp = Gst.Rtp.RTPBuffer.New (native_rtp);
			Marshal.FreeHGlobal (native_rtp);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_new_allocate(uint payload_len, byte pad_len, byte csrc_count);

		public static Gst.Buffer NewAllocate(uint payload_len, byte pad_len, byte csrc_count) {
			IntPtr raw_ret = gst_rtp_buffer_new_allocate(payload_len, pad_len, csrc_count);
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_new_allocate_len(uint packet_len, byte pad_len, byte csrc_count);

		public static Gst.Buffer NewAllocateLen(uint packet_len, byte pad_len, byte csrc_count) {
			IntPtr raw_ret = gst_rtp_buffer_new_allocate_len(packet_len, pad_len, csrc_count);
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_new_copy_data([MarshalAs(UnmanagedType.LPArray, SizeParamIndex=1)]byte[] data, UIntPtr n_length);

		public static Gst.Buffer NewCopyData(byte[] data) {
			ulong n_length = (ulong)(data == null ? 0 : data.Length);
			IntPtr raw_ret = gst_rtp_buffer_new_copy_data(data, new UIntPtr ((uint)n_length));
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		[DllImport("gstrtp-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_rtp_buffer_new_take_data([MarshalAs(UnmanagedType.LPArray, SizeParamIndex=1)]byte[] data, UIntPtr n_length);

		public static Gst.Buffer NewTakeData(byte[] data) {
			ulong n_length = (ulong)(data == null ? 0 : data.Length);
			IntPtr raw_ret = gst_rtp_buffer_new_take_data(data, new UIntPtr ((uint)n_length));
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		static void ReadNative (IntPtr native, ref Gst.Rtp.RTPBuffer target)
		{
			target = New (native);
		}

		public bool Equals (RTPBuffer other)
		{
			return true && Buffer.Equals (other.Buffer) && State.Equals (other.State) && Data.Equals (other.Data) && Size.Equals (other.Size) && MapInfo.Equals (other.MapInfo);
		}

		public override bool Equals (object other)
		{
			return other is RTPBuffer && Equals ((RTPBuffer) other);
		}

		public override int GetHashCode ()
		{
			return this.GetType ().FullName.GetHashCode () ^ Buffer.GetHashCode () ^ State.GetHashCode () ^ Data.GetHashCode () ^ Size.GetHashCode () ^ MapInfo.GetHashCode ();
		}

		private static GLib.GType GType {
			get { return GLib.GType.Pointer; }
		}
#endregion
	}
}
