// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst.Audio {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	[StructLayout(LayoutKind.Sequential)]
	public partial struct AudioBuffer : IEquatable<AudioBuffer> {

		private IntPtr _info;
		public Gst.Audio.AudioInfo Info {
			get {
				return _info == IntPtr.Zero ? null : (Gst.Audio.AudioInfo) GLib.Opaque.GetOpaque (_info, typeof (Gst.Audio.AudioInfo), false);
			}
			set {
				_info = value == null ? IntPtr.Zero : value.Handle;
			}
		}
		private UIntPtr n_samples;
		public ulong NSamples {
			get {
				return (ulong) n_samples;
			}
			set {
				n_samples = new UIntPtr (value);
			}
		}
		public int NPlanes;
		private IntPtr _planes;
		private IntPtr _buffer;
		public Gst.Buffer Buffer {
			get {
				return _buffer == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (_buffer, typeof (Gst.Buffer), false);
			}
			set {
				_buffer = value == null ? IntPtr.Zero : value.Handle;
			}
		}
		private IntPtr _map_infos;

		[MarshalAs (UnmanagedType.ByValArray, SizeConst=4)]
		private IntPtr[] _gstGstReserved;

		public static Gst.Audio.AudioBuffer Zero = new Gst.Audio.AudioBuffer ();

		public static Gst.Audio.AudioBuffer New(IntPtr raw) {
			if (raw == IntPtr.Zero)
				return Gst.Audio.AudioBuffer.Zero;
			return (Gst.Audio.AudioBuffer) Marshal.PtrToStructure (raw, typeof (Gst.Audio.AudioBuffer));
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_audio_buffer_unmap(IntPtr raw);

		public void Unmap() {
			IntPtr this_as_native = System.Runtime.InteropServices.Marshal.AllocHGlobal (System.Runtime.InteropServices.Marshal.SizeOf (this));
			System.Runtime.InteropServices.Marshal.StructureToPtr (this, this_as_native, false);
			gst_audio_buffer_unmap(this_as_native);
			ReadNative (this_as_native, ref this);
			System.Runtime.InteropServices.Marshal.FreeHGlobal (this_as_native);
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_buffer_clip(IntPtr buffer, IntPtr segment, int rate, int bpf);

		public static Gst.Buffer Clip(Gst.Buffer buffer, Gst.Segment segment, int rate, int bpf) {
			buffer.Owned = false;
			IntPtr native_segment = GLib.Marshaller.StructureToPtrAlloc (segment);
			IntPtr raw_ret = gst_audio_buffer_clip(buffer == null ? IntPtr.Zero : buffer.Handle, native_segment, rate, bpf);
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			Marshal.FreeHGlobal (native_segment);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_buffer_map(IntPtr buffer, IntPtr info, IntPtr gstbuffer, int flags);

		public static bool Map(out Gst.Audio.AudioBuffer buffer, Gst.Audio.AudioInfo info, Gst.Buffer gstbuffer, Gst.MapFlags flags) {
			IntPtr native_buffer = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gst.Audio.AudioBuffer)));
			bool raw_ret = gst_audio_buffer_map(native_buffer, info == null ? IntPtr.Zero : info.Handle, gstbuffer == null ? IntPtr.Zero : gstbuffer.Handle, (int) flags);
			bool ret = raw_ret;
			buffer = Gst.Audio.AudioBuffer.New (native_buffer);
			Marshal.FreeHGlobal (native_buffer);
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_audio_buffer_reorder_channels(IntPtr buffer, int format, int channels, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex=2)]int[] from, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex=2)]int[] to);

		public static bool ReorderChannels(Gst.Buffer buffer, Gst.Audio.AudioFormat format, Gst.Audio.AudioChannelPosition[] from, Gst.Audio.AudioChannelPosition[] to) {
			int channels = (from == null ? 0 : from.Length);
			int[] native_from = new int [channels];
			for (int i = 0; i < channels; i++)
				native_from [i] = (int) from[i];
			int[] native_to = new int [channels];
			for (int i = 0; i < channels; i++)
				native_to [i] = (int) to[i];
			bool raw_ret = gst_audio_buffer_reorder_channels(buffer == null ? IntPtr.Zero : buffer.Handle, (int) format, channels, native_from, native_to);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstaudio-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_audio_buffer_truncate(IntPtr buffer, int bpf, UIntPtr trim, UIntPtr samples);

		public static Gst.Buffer Truncate(Gst.Buffer buffer, int bpf, ulong trim, ulong samples) {
			buffer.Owned = false;
			IntPtr raw_ret = gst_audio_buffer_truncate(buffer == null ? IntPtr.Zero : buffer.Handle, bpf, new UIntPtr (trim), new UIntPtr (samples));
			Gst.Buffer ret = raw_ret == IntPtr.Zero ? null : (Gst.Buffer) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Buffer), true);
			return ret;
		}

		static void ReadNative (IntPtr native, ref Gst.Audio.AudioBuffer target)
		{
			target = New (native);
		}

		public bool Equals (AudioBuffer other)
		{
			return true && Info.Equals (other.Info) && NSamples.Equals (other.NSamples) && NPlanes.Equals (other.NPlanes) && _planes.Equals (other._planes) && Buffer.Equals (other.Buffer) && _map_infos.Equals (other._map_infos);
		}

		public override bool Equals (object other)
		{
			return other is AudioBuffer && Equals ((AudioBuffer) other);
		}

		public override int GetHashCode ()
		{
			return this.GetType ().FullName.GetHashCode () ^ Info.GetHashCode () ^ NSamples.GetHashCode () ^ NPlanes.GetHashCode () ^ _planes.GetHashCode () ^ Buffer.GetHashCode () ^ _map_infos.GetHashCode ();
		}

		private static GLib.GType GType {
			get { return GLib.GType.Pointer; }
		}
#endregion
	}
}
