use crate::*;

#[test]
fn hevc() {
    const ENCODED: &[u8] = &[
        0x00, 0x00, 0x00, 0x1C, 0x66, 0x74, 0x79, 0x70, 0x69, 0x73, 0x6F, 0x36, 0x00, 0x00, 0x02,
        0x00, 0x69, 0x73, 0x6F, 0x36, 0x63, 0x6D, 0x66, 0x63, 0x6D, 0x70, 0x34, 0x31, 0x00, 0x00,
        0x0A, 0xCB, 0x6D, 0x6F, 0x6F, 0x76, 0x00, 0x00, 0x00, 0x6C, 0x6D, 0x76, 0x68, 0x64, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE8,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x09, 0xCE, 0x74, 0x72,
        0x61, 0x6B, 0x00, 0x00, 0x00, 0x5C, 0x74, 0x6B, 0x68, 0x64, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00,
        0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x09, 0x6A, 0x6D, 0x64, 0x69, 0x61, 0x00, 0x00, 0x00,
        0x20, 0x6D, 0x64, 0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0xC4, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x2D, 0x68, 0x64, 0x6C, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x76, 0x69, 0x64, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x56, 0x69, 0x64, 0x65, 0x6F, 0x48, 0x61, 0x6E, 0x64, 0x6C, 0x65, 0x72, 0x00, 0x00,
        0x00, 0x09, 0x15, 0x6D, 0x69, 0x6E, 0x66, 0x00, 0x00, 0x00, 0x14, 0x76, 0x6D, 0x68, 0x64,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x24, 0x64, 0x69, 0x6E, 0x66, 0x00, 0x00, 0x00, 0x1C, 0x64, 0x72, 0x65, 0x66, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C, 0x75, 0x72, 0x6C, 0x20, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x08, 0xD5, 0x73, 0x74, 0x62, 0x6C, 0x00, 0x00, 0x08, 0x89,
        0x73, 0x74, 0x73, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x08,
        0x79, 0x68, 0x65, 0x76, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
        0x80, 0x04, 0x38, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xF5, 0x68, 0x76, 0x63,
        0x43, 0x01, 0x21, 0x60, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xF0,
        0x00, 0xFC, 0xFD, 0xF8, 0xF8, 0x00, 0x00, 0x0F, 0x04, 0x20, 0x00, 0x01, 0x00, 0x18, 0x40,
        0x01, 0x0C, 0x01, 0xFF, 0xFF, 0x21, 0x60, 0x00, 0x00, 0x03, 0x00, 0x90, 0x00, 0x00, 0x03,
        0x00, 0x00, 0x03, 0x00, 0x78, 0x95, 0x98, 0x09, 0x21, 0x00, 0x01, 0x00, 0x2B, 0x42, 0x01,
        0x01, 0x21, 0x60, 0x00, 0x00, 0x03, 0x00, 0x90, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
        0x78, 0xA0, 0x03, 0xC0, 0x80, 0x10, 0xE5, 0x96, 0x56, 0x69, 0x24, 0xCA, 0xF0, 0x10, 0x10,
        0x00, 0x00, 0x03, 0x00, 0x10, 0x00, 0x00, 0x03, 0x01, 0xE0, 0x80, 0x22, 0x00, 0x01, 0x00,
        0x07, 0x44, 0x01, 0xC1, 0x72, 0xB4, 0x62, 0x40, 0x27, 0x00, 0x01, 0x07, 0x78, 0x4E, 0x01,
        0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x73, 0x2C, 0xA2, 0xDE, 0x09, 0xB5, 0x17,
        0x47, 0xDB, 0xBB, 0x55, 0xA4, 0xFE, 0x7F, 0xC2, 0xFC, 0x4E, 0x78, 0x32, 0x36, 0x35, 0x20,
        0x28, 0x62, 0x75, 0x69, 0x6C, 0x64, 0x20, 0x31, 0x35, 0x31, 0x29, 0x20, 0x2D, 0x20, 0x32,
        0x2E, 0x36, 0x2B, 0x34, 0x39, 0x2D, 0x37, 0x32, 0x31, 0x39, 0x33, 0x37, 0x36, 0x64, 0x65,
        0x34, 0x32, 0x61, 0x3A, 0x5B, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x5D, 0x5B, 0x47,
        0x43, 0x43, 0x20, 0x37, 0x2E, 0x33, 0x2E, 0x30, 0x5D, 0x5B, 0x36, 0x34, 0x20, 0x62, 0x69,
        0x74, 0x5D, 0x20, 0x38, 0x62, 0x69, 0x74, 0x2B, 0x31, 0x30, 0x62, 0x69, 0x74, 0x20, 0x2D,
        0x20, 0x48, 0x2E, 0x32, 0x36, 0x35, 0x2F, 0x48, 0x45, 0x56, 0x43, 0x20, 0x63, 0x6F, 0x64,
        0x65, 0x63, 0x20, 0x2D, 0x20, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20,
        0x32, 0x30, 0x31, 0x33, 0x2D, 0x32, 0x30, 0x31, 0x38, 0x20, 0x28, 0x63, 0x29, 0x20, 0x4D,
        0x75, 0x6C, 0x74, 0x69, 0x63, 0x6F, 0x72, 0x65, 0x77, 0x61, 0x72, 0x65, 0x2C, 0x20, 0x49,
        0x6E, 0x63, 0x20, 0x2D, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x78, 0x32, 0x36,
        0x35, 0x2E, 0x6F, 0x72, 0x67, 0x20, 0x2D, 0x20, 0x6F, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x73,
        0x3A, 0x20, 0x63, 0x70, 0x75, 0x69, 0x64, 0x3D, 0x31, 0x30, 0x35, 0x30, 0x31, 0x31, 0x31,
        0x20, 0x66, 0x72, 0x61, 0x6D, 0x65, 0x2D, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x3D,
        0x33, 0x20, 0x6E, 0x75, 0x6D, 0x61, 0x2D, 0x70, 0x6F, 0x6F, 0x6C, 0x73, 0x3D, 0x38, 0x20,
        0x77, 0x70, 0x70, 0x20, 0x6E, 0x6F, 0x2D, 0x70, 0x6D, 0x6F, 0x64, 0x65, 0x20, 0x6E, 0x6F,
        0x2D, 0x70, 0x6D, 0x65, 0x20, 0x6E, 0x6F, 0x2D, 0x70, 0x73, 0x6E, 0x72, 0x20, 0x6E, 0x6F,
        0x2D, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x6C, 0x6F, 0x67, 0x2D, 0x6C, 0x65, 0x76, 0x65, 0x6C,
        0x3D, 0x32, 0x20, 0x62, 0x69, 0x74, 0x64, 0x65, 0x70, 0x74, 0x68, 0x3D, 0x38, 0x20, 0x69,
        0x6E, 0x70, 0x75, 0x74, 0x2D, 0x63, 0x73, 0x70, 0x3D, 0x31, 0x20, 0x66, 0x70, 0x73, 0x3D,
        0x33, 0x30, 0x2F, 0x31, 0x20, 0x69, 0x6E, 0x70, 0x75, 0x74, 0x2D, 0x72, 0x65, 0x73, 0x3D,
        0x31, 0x39, 0x32, 0x30, 0x78, 0x31, 0x30, 0x38, 0x30, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72,
        0x6C, 0x61, 0x63, 0x65, 0x3D, 0x30, 0x20, 0x74, 0x6F, 0x74, 0x61, 0x6C, 0x2D, 0x66, 0x72,
        0x61, 0x6D, 0x65, 0x73, 0x3D, 0x30, 0x20, 0x6C, 0x65, 0x76, 0x65, 0x6C, 0x2D, 0x69, 0x64,
        0x63, 0x3D, 0x30, 0x20, 0x68, 0x69, 0x67, 0x68, 0x2D, 0x74, 0x69, 0x65, 0x72, 0x3D, 0x31,
        0x20, 0x75, 0x68, 0x64, 0x2D, 0x62, 0x64, 0x3D, 0x30, 0x20, 0x72, 0x65, 0x66, 0x3D, 0x34,
        0x20, 0x6E, 0x6F, 0x2D, 0x61, 0x6C, 0x6C, 0x6F, 0x77, 0x2D, 0x6E, 0x6F, 0x6E, 0x2D, 0x63,
        0x6F, 0x6E, 0x66, 0x6F, 0x72, 0x6D, 0x61, 0x6E, 0x63, 0x65, 0x20, 0x6E, 0x6F, 0x2D, 0x72,
        0x65, 0x70, 0x65, 0x61, 0x74, 0x2D, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x20, 0x61,
        0x6E, 0x6E, 0x65, 0x78, 0x62, 0x20, 0x6E, 0x6F, 0x2D, 0x61, 0x75, 0x64, 0x20, 0x6E, 0x6F,
        0x2D, 0x68, 0x72, 0x64, 0x20, 0x69, 0x6E, 0x66, 0x6F, 0x20, 0x68, 0x61, 0x73, 0x68, 0x3D,
        0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x61, 0x6C, 0x2D, 0x6C,
        0x61, 0x79, 0x65, 0x72, 0x73, 0x20, 0x6F, 0x70, 0x65, 0x6E, 0x2D, 0x67, 0x6F, 0x70, 0x20,
        0x6D, 0x69, 0x6E, 0x2D, 0x6B, 0x65, 0x79, 0x69, 0x6E, 0x74, 0x3D, 0x32, 0x35, 0x20, 0x6B,
        0x65, 0x79, 0x69, 0x6E, 0x74, 0x3D, 0x32, 0x35, 0x30, 0x20, 0x67, 0x6F, 0x70, 0x2D, 0x6C,
        0x6F, 0x6F, 0x6B, 0x61, 0x68, 0x65, 0x61, 0x64, 0x3D, 0x30, 0x20, 0x62, 0x66, 0x72, 0x61,
        0x6D, 0x65, 0x73, 0x3D, 0x34, 0x20, 0x62, 0x2D, 0x61, 0x64, 0x61, 0x70, 0x74, 0x3D, 0x32,
        0x20, 0x62, 0x2D, 0x70, 0x79, 0x72, 0x61, 0x6D, 0x69, 0x64, 0x20, 0x62, 0x66, 0x72, 0x61,
        0x6D, 0x65, 0x2D, 0x62, 0x69, 0x61, 0x73, 0x3D, 0x30, 0x20, 0x72, 0x63, 0x2D, 0x6C, 0x6F,
        0x6F, 0x6B, 0x61, 0x68, 0x65, 0x61, 0x64, 0x3D, 0x32, 0x35, 0x20, 0x6C, 0x6F, 0x6F, 0x6B,
        0x61, 0x68, 0x65, 0x61, 0x64, 0x2D, 0x73, 0x6C, 0x69, 0x63, 0x65, 0x73, 0x3D, 0x34, 0x20,
        0x73, 0x63, 0x65, 0x6E, 0x65, 0x63, 0x75, 0x74, 0x3D, 0x34, 0x30, 0x20, 0x72, 0x61, 0x64,
        0x6C, 0x3D, 0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x69, 0x6E, 0x74, 0x72, 0x61, 0x2D, 0x72, 0x65,
        0x66, 0x72, 0x65, 0x73, 0x68, 0x20, 0x63, 0x74, 0x75, 0x3D, 0x36, 0x34, 0x20, 0x6D, 0x69,
        0x6E, 0x2D, 0x63, 0x75, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3D, 0x38, 0x20, 0x72, 0x65, 0x63,
        0x74, 0x20, 0x6E, 0x6F, 0x2D, 0x61, 0x6D, 0x70, 0x20, 0x6D, 0x61, 0x78, 0x2D, 0x74, 0x75,
        0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3D, 0x33, 0x32, 0x20, 0x74, 0x75, 0x2D, 0x69, 0x6E, 0x74,
        0x65, 0x72, 0x2D, 0x64, 0x65, 0x70, 0x74, 0x68, 0x3D, 0x31, 0x20, 0x74, 0x75, 0x2D, 0x69,
        0x6E, 0x74, 0x72, 0x61, 0x2D, 0x64, 0x65, 0x70, 0x74, 0x68, 0x3D, 0x31, 0x20, 0x6C, 0x69,
        0x6D, 0x69, 0x74, 0x2D, 0x74, 0x75, 0x3D, 0x30, 0x20, 0x72, 0x64, 0x6F, 0x71, 0x2D, 0x6C,
        0x65, 0x76, 0x65, 0x6C, 0x3D, 0x32, 0x20, 0x64, 0x79, 0x6E, 0x61, 0x6D, 0x69, 0x63, 0x2D,
        0x72, 0x64, 0x3D, 0x30, 0x2E, 0x30, 0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x73, 0x73, 0x69, 0x6D,
        0x2D, 0x72, 0x64, 0x20, 0x73, 0x69, 0x67, 0x6E, 0x68, 0x69, 0x64, 0x65, 0x20, 0x6E, 0x6F,
        0x2D, 0x74, 0x73, 0x6B, 0x69, 0x70, 0x20, 0x6E, 0x72, 0x2D, 0x69, 0x6E, 0x74, 0x72, 0x61,
        0x3D, 0x30, 0x20, 0x6E, 0x72, 0x2D, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x3D, 0x30, 0x20, 0x6E,
        0x6F, 0x2D, 0x63, 0x6F, 0x6E, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6E, 0x65, 0x64, 0x2D, 0x69,
        0x6E, 0x74, 0x72, 0x61, 0x20, 0x73, 0x74, 0x72, 0x6F, 0x6E, 0x67, 0x2D, 0x69, 0x6E, 0x74,
        0x72, 0x61, 0x2D, 0x73, 0x6D, 0x6F, 0x6F, 0x74, 0x68, 0x69, 0x6E, 0x67, 0x20, 0x6D, 0x61,
        0x78, 0x2D, 0x6D, 0x65, 0x72, 0x67, 0x65, 0x3D, 0x33, 0x20, 0x6C, 0x69, 0x6D, 0x69, 0x74,
        0x2D, 0x72, 0x65, 0x66, 0x73, 0x3D, 0x33, 0x20, 0x6C, 0x69, 0x6D, 0x69, 0x74, 0x2D, 0x6D,
        0x6F, 0x64, 0x65, 0x73, 0x20, 0x6D, 0x65, 0x3D, 0x33, 0x20, 0x73, 0x75, 0x62, 0x6D, 0x65,
        0x3D, 0x33, 0x20, 0x6D, 0x65, 0x72, 0x61, 0x6E, 0x67, 0x65, 0x3D, 0x35, 0x37, 0x20, 0x74,
        0x65, 0x6D, 0x70, 0x6F, 0x72, 0x61, 0x6C, 0x2D, 0x6D, 0x76, 0x70, 0x20, 0x77, 0x65, 0x69,
        0x67, 0x68, 0x74, 0x70, 0x20, 0x6E, 0x6F, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x62,
        0x20, 0x6E, 0x6F, 0x2D, 0x61, 0x6E, 0x61, 0x6C, 0x79, 0x7A, 0x65, 0x2D, 0x73, 0x72, 0x63,
        0x2D, 0x70, 0x69, 0x63, 0x73, 0x20, 0x64, 0x65, 0x62, 0x6C, 0x6F, 0x63, 0x6B, 0x3D, 0x30,
        0x3A, 0x30, 0x20, 0x73, 0x61, 0x6F, 0x20, 0x6E, 0x6F, 0x2D, 0x73, 0x61, 0x6F, 0x2D, 0x6E,
        0x6F, 0x6E, 0x2D, 0x64, 0x65, 0x62, 0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x72, 0x64, 0x3D, 0x34,
        0x20, 0x6E, 0x6F, 0x2D, 0x65, 0x61, 0x72, 0x6C, 0x79, 0x2D, 0x73, 0x6B, 0x69, 0x70, 0x20,
        0x72, 0x73, 0x6B, 0x69, 0x70, 0x20, 0x6E, 0x6F, 0x2D, 0x66, 0x61, 0x73, 0x74, 0x2D, 0x69,
        0x6E, 0x74, 0x72, 0x61, 0x20, 0x6E, 0x6F, 0x2D, 0x74, 0x73, 0x6B, 0x69, 0x70, 0x2D, 0x66,
        0x61, 0x73, 0x74, 0x20, 0x6E, 0x6F, 0x2D, 0x63, 0x75, 0x2D, 0x6C, 0x6F, 0x73, 0x73, 0x6C,
        0x65, 0x73, 0x73, 0x20, 0x6E, 0x6F, 0x2D, 0x62, 0x2D, 0x69, 0x6E, 0x74, 0x72, 0x61, 0x20,
        0x6E, 0x6F, 0x2D, 0x73, 0x70, 0x6C, 0x69, 0x74, 0x72, 0x64, 0x2D, 0x73, 0x6B, 0x69, 0x70,
        0x20, 0x72, 0x64, 0x70, 0x65, 0x6E, 0x61, 0x6C, 0x74, 0x79, 0x3D, 0x30, 0x20, 0x70, 0x73,
        0x79, 0x2D, 0x72, 0x64, 0x3D, 0x32, 0x2E, 0x30, 0x30, 0x20, 0x70, 0x73, 0x79, 0x2D, 0x72,
        0x64, 0x6F, 0x71, 0x3D, 0x31, 0x2E, 0x30, 0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x72, 0x64, 0x2D,
        0x72, 0x65, 0x66, 0x69, 0x6E, 0x65, 0x20, 0x6E, 0x6F, 0x2D, 0x6C, 0x6F, 0x73, 0x73, 0x6C,
        0x65, 0x73, 0x73, 0x20, 0x63, 0x62, 0x71, 0x70, 0x6F, 0x66, 0x66, 0x73, 0x3D, 0x30, 0x20,
        0x63, 0x72, 0x71, 0x70, 0x6F, 0x66, 0x66, 0x73, 0x3D, 0x30, 0x20, 0x72, 0x63, 0x3D, 0x61,
        0x62, 0x72, 0x20, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x3D, 0x32, 0x33, 0x32, 0x30,
        0x30, 0x20, 0x71, 0x63, 0x6F, 0x6D, 0x70, 0x3D, 0x30, 0x2E, 0x36, 0x30, 0x20, 0x71, 0x70,
        0x73, 0x74, 0x65, 0x70, 0x3D, 0x34, 0x20, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2D, 0x77, 0x72,
        0x69, 0x74, 0x65, 0x3D, 0x30, 0x20, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2D, 0x72, 0x65, 0x61,
        0x64, 0x3D, 0x30, 0x20, 0x69, 0x70, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x3D, 0x31, 0x2E, 0x34,
        0x30, 0x20, 0x70, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x3D, 0x31, 0x2E, 0x33, 0x30, 0x20,
        0x61, 0x71, 0x2D, 0x6D, 0x6F, 0x64, 0x65, 0x3D, 0x31, 0x20, 0x61, 0x71, 0x2D, 0x73, 0x74,
        0x72, 0x65, 0x6E, 0x67, 0x74, 0x68, 0x3D, 0x31, 0x2E, 0x30, 0x30, 0x20, 0x63, 0x75, 0x74,
        0x72, 0x65, 0x65, 0x20, 0x7A, 0x6F, 0x6E, 0x65, 0x2D, 0x63, 0x6F, 0x75, 0x6E, 0x74, 0x3D,
        0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2D, 0x63, 0x62, 0x72,
        0x20, 0x71, 0x67, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3D, 0x33, 0x32, 0x20, 0x6E, 0x6F, 0x2D,
        0x72, 0x63, 0x2D, 0x67, 0x72, 0x61, 0x69, 0x6E, 0x20, 0x71, 0x70, 0x6D, 0x61, 0x78, 0x3D,
        0x36, 0x39, 0x20, 0x71, 0x70, 0x6D, 0x69, 0x6E, 0x3D, 0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x63,
        0x6F, 0x6E, 0x73, 0x74, 0x2D, 0x76, 0x62, 0x76, 0x20, 0x73, 0x61, 0x72, 0x3D, 0x31, 0x20,
        0x6F, 0x76, 0x65, 0x72, 0x73, 0x63, 0x61, 0x6E, 0x3D, 0x30, 0x20, 0x76, 0x69, 0x64, 0x65,
        0x6F, 0x66, 0x6F, 0x72, 0x6D, 0x61, 0x74, 0x3D, 0x35, 0x20, 0x72, 0x61, 0x6E, 0x67, 0x65,
        0x3D, 0x30, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x70, 0x72, 0x69, 0x6D, 0x3D, 0x32, 0x20,
        0x74, 0x72, 0x61, 0x6E, 0x73, 0x66, 0x65, 0x72, 0x3D, 0x32, 0x20, 0x63, 0x6F, 0x6C, 0x6F,
        0x72, 0x6D, 0x61, 0x74, 0x72, 0x69, 0x78, 0x3D, 0x32, 0x20, 0x63, 0x68, 0x72, 0x6F, 0x6D,
        0x61, 0x6C, 0x6F, 0x63, 0x3D, 0x30, 0x20, 0x64, 0x69, 0x73, 0x70, 0x6C, 0x61, 0x79, 0x2D,
        0x77, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x3D, 0x30, 0x20, 0x6D, 0x61, 0x78, 0x2D, 0x63, 0x6C,
        0x6C, 0x3D, 0x30, 0x2C, 0x30, 0x20, 0x6D, 0x69, 0x6E, 0x2D, 0x6C, 0x75, 0x6D, 0x61, 0x3D,
        0x30, 0x20, 0x6D, 0x61, 0x78, 0x2D, 0x6C, 0x75, 0x6D, 0x61, 0x3D, 0x32, 0x35, 0x35, 0x20,
        0x6C, 0x6F, 0x67, 0x32, 0x2D, 0x6D, 0x61, 0x78, 0x2D, 0x70, 0x6F, 0x63, 0x2D, 0x6C, 0x73,
        0x62, 0x3D, 0x38, 0x20, 0x76, 0x75, 0x69, 0x2D, 0x74, 0x69, 0x6D, 0x69, 0x6E, 0x67, 0x2D,
        0x69, 0x6E, 0x66, 0x6F, 0x20, 0x76, 0x75, 0x69, 0x2D, 0x68, 0x72, 0x64, 0x2D, 0x69, 0x6E,
        0x66, 0x6F, 0x20, 0x73, 0x6C, 0x69, 0x63, 0x65, 0x73, 0x3D, 0x31, 0x20, 0x6E, 0x6F, 0x2D,
        0x6F, 0x70, 0x74, 0x2D, 0x71, 0x70, 0x2D, 0x70, 0x70, 0x73, 0x20, 0x6E, 0x6F, 0x2D, 0x6F,
        0x70, 0x74, 0x2D, 0x72, 0x65, 0x66, 0x2D, 0x6C, 0x69, 0x73, 0x74, 0x2D, 0x6C, 0x65, 0x6E,
        0x67, 0x74, 0x68, 0x2D, 0x70, 0x70, 0x73, 0x20, 0x6E, 0x6F, 0x2D, 0x6D, 0x75, 0x6C, 0x74,
        0x69, 0x2D, 0x70, 0x61, 0x73, 0x73, 0x2D, 0x6F, 0x70, 0x74, 0x2D, 0x72, 0x70, 0x73, 0x20,
        0x73, 0x63, 0x65, 0x6E, 0x65, 0x63, 0x75, 0x74, 0x2D, 0x62, 0x69, 0x61, 0x73, 0x3D, 0x30,
        0x2E, 0x30, 0x35, 0x20, 0x6E, 0x6F, 0x2D, 0x6F, 0x70, 0x74, 0x2D, 0x63, 0x75, 0x2D, 0x64,
        0x65, 0x6C, 0x74, 0x61, 0x2D, 0x71, 0x70, 0x20, 0x6E, 0x6F, 0x2D, 0x61, 0x71, 0x2D, 0x6D,
        0x6F, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x6E, 0x6F, 0x2D, 0x68, 0x64, 0x72, 0x20, 0x6E, 0x6F,
        0x2D, 0x68, 0x64, 0x72, 0x2D, 0x6F, 0x70, 0x74, 0x20, 0x6E, 0x6F, 0x2D, 0x64, 0x68, 0x64,
        0x72, 0x31, 0x30, 0x2D, 0x6F, 0x70, 0x74, 0x20, 0x61, 0x6E, 0x61, 0x6C, 0x79, 0x73, 0x69,
        0x73, 0x2D, 0x72, 0x65, 0x75, 0x73, 0x65, 0x2D, 0x6C, 0x65, 0x76, 0x65, 0x6C, 0x3D, 0x35,
        0x20, 0x73, 0x63, 0x61, 0x6C, 0x65, 0x2D, 0x66, 0x61, 0x63, 0x74, 0x6F, 0x72, 0x3D, 0x30,
        0x20, 0x72, 0x65, 0x66, 0x69, 0x6E, 0x65, 0x2D, 0x69, 0x6E, 0x74, 0x72, 0x61, 0x3D, 0x30,
        0x20, 0x72, 0x65, 0x66, 0x69, 0x6E, 0x65, 0x2D, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x3D, 0x30,
        0x20, 0x72, 0x65, 0x66, 0x69, 0x6E, 0x65, 0x2D, 0x6D, 0x76, 0x3D, 0x30, 0x20, 0x6E, 0x6F,
        0x2D, 0x6C, 0x69, 0x6D, 0x69, 0x74, 0x2D, 0x73, 0x61, 0x6F, 0x20, 0x63, 0x74, 0x75, 0x2D,
        0x69, 0x6E, 0x66, 0x6F, 0x3D, 0x30, 0x20, 0x6E, 0x6F, 0x2D, 0x6C, 0x6F, 0x77, 0x70, 0x61,
        0x73, 0x73, 0x2D, 0x64, 0x63, 0x74, 0x20, 0x72, 0x65, 0x66, 0x69, 0x6E, 0x65, 0x2D, 0x6D,
        0x76, 0x2D, 0x74, 0x79, 0x70, 0x65, 0x3D, 0x30, 0x20, 0x63, 0x6F, 0x70, 0x79, 0x2D, 0x70,
        0x69, 0x63, 0x3D, 0x31, 0x80, 0x00, 0x00, 0x00, 0x0A, 0x66, 0x69, 0x65, 0x6C, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x10, 0x70, 0x61, 0x73, 0x70, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x14, 0x62, 0x74, 0x72, 0x74, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80,
        0x26, 0xB2, 0x01, 0x80, 0x26, 0xB2, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x74, 0x73, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x73, 0x74, 0x73, 0x63,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x73, 0x74, 0x73,
        0x7A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x10, 0x73, 0x74, 0x63, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x28, 0x6D, 0x76, 0x65, 0x78, 0x00, 0x00, 0x00, 0x20, 0x74, 0x72, 0x65, 0x78,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x75, 0x64,
        0x74, 0x61, 0x00, 0x00, 0x00, 0x59, 0x6D, 0x65, 0x74, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x21, 0x68, 0x64, 0x6C, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x6D, 0x64, 0x69, 0x72, 0x61, 0x70, 0x70, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x69, 0x6C, 0x73, 0x74, 0x00, 0x00, 0x00, 0x24, 0xA9,
        0x74, 0x6F, 0x6F, 0x00, 0x00, 0x00, 0x1C, 0x64, 0x61, 0x74, 0x61, 0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x4C, 0x61, 0x76, 0x66, 0x36, 0x31, 0x2E, 0x37, 0x2E, 0x31, 0x30,
        0x30, 0x00, 0x00, 0x00, 0x6C, 0x6D, 0x6F, 0x6F, 0x66, 0x00, 0x00, 0x00, 0x10, 0x6D, 0x66,
        0x68, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x54, 0x74,
        0x72, 0x61, 0x66, 0x00, 0x00, 0x00, 0x20, 0x74, 0x66, 0x68, 0x64, 0x00, 0x02, 0x00, 0x3A,
        0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0xF3,
        0x65, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x74, 0x66, 0x64, 0x74, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x74,
        0x72, 0x75, 0x6E, 0x01, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x74,
        0x02, 0x00, 0x00, 0x00,
    ];

    let buf = &mut std::io::Cursor::new(ENCODED);
    let ftyp = Ftyp::decode(buf).expect("failed to decode ftyp");

    assert_eq!(
        ftyp,
        Ftyp {
            major_brand: b"iso6".into(),
            minor_version: 512,
            compatible_brands: vec![b"iso6".into(), b"cmfc".into(), b"mp41".into()],
        }
    );

    let moov = Moov::decode(buf).expect("failed to decode moov");
    assert_eq!(
        moov,
        Moov {
            mvhd: Mvhd {
                creation_time: 0,
                modification_time: 0,
                timescale: 1000,
                duration: 0,
                rate: 1.into(),
                volume: 1.into(),
                matrix: Matrix {
                    a: 65536,
                    b: 0,
                    u: 0,
                    c: 0,
                    d: 65536,
                    v: 0,
                    x: 0,
                    y: 0,
                    w: 1073741824
                },
                next_track_id: 2
            },
            meta: None,
            mvex: Some(Mvex {
                mehd: None,
                trex: vec![Trex {
                    track_id: 1,
                    default_sample_description_index: 1,
                    default_sample_duration: 0,
                    default_sample_size: 0,
                    default_sample_flags: 0
                }]
            }),
            trak: vec![Trak {
                tkhd: Tkhd {
                    creation_time: 0,
                    modification_time: 0,
                    track_id: 1,
                    duration: 0,
                    layer: 0,
                    alternate_group: 0,
                    enabled: true,
                    volume: 0.into(),
                    matrix: Matrix {
                        a: 65536,
                        b: 0,
                        u: 0,
                        c: 0,
                        d: 65536,
                        v: 0,
                        x: 0,
                        y: 0,
                        w: 1073741824
                    },
                    width: 1920.into(),
                    height: 1080.into()
                },
                edts: None,
                meta: None,
                mdia: Mdia {
                    mdhd: Mdhd {
                        creation_time: 0,
                        modification_time: 0,
                        timescale: 15360,
                        duration: 0,
                        language: "und".into()
                    },
                    hdlr: Hdlr {
                        handler: b"vide".into(),
                        name: "VideoHandler".into()
                    },
                    minf: Minf {
                        vmhd: Some(Vmhd {
                            graphics_mode: 0,
                            op_color: RgbColor {
                                red: 0,
                                green: 0,
                                blue: 0
                            }
                        }),
                        smhd: None,
                        dinf: Dinf {
                            dref: Dref {
                                urls: vec![Url {
                                    location: "".to_string()
                                }]
                            }
                        },
                        stbl: Stbl {
                            stsd: Stsd {
                                codecs: vec![Hev1 {
                                    visual: Visual {
                                        data_reference_index: 1,
                                        width: 1920,
                                        height: 1080,
                                        horizresolution: 72.into(),
                                        vertresolution: 72.into(),
                                        frame_count: 1,
                                        compressor: "".into(),
                                        depth: 24
                                    },
                                    hvcc: Hvcc {
                                        configuration_version: 1,
                                        general_profile_space: 0,
                                        general_tier_flag: true,
                                        general_profile_idc: 1,
                                        general_profile_compatibility_flags: [96, 0, 0, 0],
                                        general_constraint_indicator_flags: [144, 0, 0, 0, 0, 0],
                                        general_level_idc: 120,
                                        min_spatial_segmentation_idc: 0,
                                        parallelism_type: 0,
                                        chroma_format_idc: 1,
                                        bit_depth_luma_minus8: 0,
                                        bit_depth_chroma_minus8: 0,
                                        avg_frame_rate: 0,
                                        constant_frame_rate: 0,
                                        num_temporal_layers: 1,
                                        temporal_id_nested: true,
                                        length_size_minus_one: 3,
                                        arrays: vec![
                                            HvcCArray {
                                                completeness: false,
                                                nal_unit_type: 32,
                                                nalus: vec![vec![
                                                    64, 1, 12, 1, 255, 255, 33, 96, 0, 0, 3, 0,
                                                    144, 0, 0, 3, 0, 0, 3, 0, 120, 149, 152, 9
                                                ]]
                                            },
                                            HvcCArray {
                                                completeness: false,
                                                nal_unit_type: 33,
                                                nalus: vec![vec![
                                                    66, 1, 1, 33, 96, 0, 0, 3, 0, 144, 0, 0, 3, 0,
                                                    0, 3, 0, 120, 160, 3, 192, 128, 16, 229, 150,
                                                    86, 105, 36, 202, 240, 16, 16, 0, 0, 3, 0, 16,
                                                    0, 0, 3, 1, 224, 128
                                                ]]
                                            },
                                            HvcCArray {
                                                completeness: false,
                                                nal_unit_type: 34,
                                                nalus: vec![vec![68, 1, 193, 114, 180, 98, 64]]
                                            },
                                            HvcCArray {
                                                completeness: false,
                                                nal_unit_type: 39,
                                                // It looks scary, but it's just the x265 CLI flags.
                                                nalus: vec![vec![
                                                    78, 1, 5, 255, 255, 255, 255, 255, 255, 255,
                                                    115, 44, 162, 222, 9, 181, 23, 71, 219, 187,
                                                    85, 164, 254, 127, 194, 252, 78, 120, 50, 54,
                                                    53, 32, 40, 98, 117, 105, 108, 100, 32, 49, 53,
                                                    49, 41, 32, 45, 32, 50, 46, 54, 43, 52, 57, 45,
                                                    55, 50, 49, 57, 51, 55, 54, 100, 101, 52, 50,
                                                    97, 58, 91, 87, 105, 110, 100, 111, 119, 115,
                                                    93, 91, 71, 67, 67, 32, 55, 46, 51, 46, 48, 93,
                                                    91, 54, 52, 32, 98, 105, 116, 93, 32, 56, 98,
                                                    105, 116, 43, 49, 48, 98, 105, 116, 32, 45, 32,
                                                    72, 46, 50, 54, 53, 47, 72, 69, 86, 67, 32, 99,
                                                    111, 100, 101, 99, 32, 45, 32, 67, 111, 112,
                                                    121, 114, 105, 103, 104, 116, 32, 50, 48, 49,
                                                    51, 45, 50, 48, 49, 56, 32, 40, 99, 41, 32, 77,
                                                    117, 108, 116, 105, 99, 111, 114, 101, 119, 97,
                                                    114, 101, 44, 32, 73, 110, 99, 32, 45, 32, 104,
                                                    116, 116, 112, 58, 47, 47, 120, 50, 54, 53, 46,
                                                    111, 114, 103, 32, 45, 32, 111, 112, 116, 105,
                                                    111, 110, 115, 58, 32, 99, 112, 117, 105, 100,
                                                    61, 49, 48, 53, 48, 49, 49, 49, 32, 102, 114,
                                                    97, 109, 101, 45, 116, 104, 114, 101, 97, 100,
                                                    115, 61, 51, 32, 110, 117, 109, 97, 45, 112,
                                                    111, 111, 108, 115, 61, 56, 32, 119, 112, 112,
                                                    32, 110, 111, 45, 112, 109, 111, 100, 101, 32,
                                                    110, 111, 45, 112, 109, 101, 32, 110, 111, 45,
                                                    112, 115, 110, 114, 32, 110, 111, 45, 115, 115,
                                                    105, 109, 32, 108, 111, 103, 45, 108, 101, 118,
                                                    101, 108, 61, 50, 32, 98, 105, 116, 100, 101,
                                                    112, 116, 104, 61, 56, 32, 105, 110, 112, 117,
                                                    116, 45, 99, 115, 112, 61, 49, 32, 102, 112,
                                                    115, 61, 51, 48, 47, 49, 32, 105, 110, 112,
                                                    117, 116, 45, 114, 101, 115, 61, 49, 57, 50,
                                                    48, 120, 49, 48, 56, 48, 32, 105, 110, 116,
                                                    101, 114, 108, 97, 99, 101, 61, 48, 32, 116,
                                                    111, 116, 97, 108, 45, 102, 114, 97, 109, 101,
                                                    115, 61, 48, 32, 108, 101, 118, 101, 108, 45,
                                                    105, 100, 99, 61, 48, 32, 104, 105, 103, 104,
                                                    45, 116, 105, 101, 114, 61, 49, 32, 117, 104,
                                                    100, 45, 98, 100, 61, 48, 32, 114, 101, 102,
                                                    61, 52, 32, 110, 111, 45, 97, 108, 108, 111,
                                                    119, 45, 110, 111, 110, 45, 99, 111, 110, 102,
                                                    111, 114, 109, 97, 110, 99, 101, 32, 110, 111,
                                                    45, 114, 101, 112, 101, 97, 116, 45, 104, 101,
                                                    97, 100, 101, 114, 115, 32, 97, 110, 110, 101,
                                                    120, 98, 32, 110, 111, 45, 97, 117, 100, 32,
                                                    110, 111, 45, 104, 114, 100, 32, 105, 110, 102,
                                                    111, 32, 104, 97, 115, 104, 61, 48, 32, 110,
                                                    111, 45, 116, 101, 109, 112, 111, 114, 97, 108,
                                                    45, 108, 97, 121, 101, 114, 115, 32, 111, 112,
                                                    101, 110, 45, 103, 111, 112, 32, 109, 105, 110,
                                                    45, 107, 101, 121, 105, 110, 116, 61, 50, 53,
                                                    32, 107, 101, 121, 105, 110, 116, 61, 50, 53,
                                                    48, 32, 103, 111, 112, 45, 108, 111, 111, 107,
                                                    97, 104, 101, 97, 100, 61, 48, 32, 98, 102,
                                                    114, 97, 109, 101, 115, 61, 52, 32, 98, 45, 97,
                                                    100, 97, 112, 116, 61, 50, 32, 98, 45, 112,
                                                    121, 114, 97, 109, 105, 100, 32, 98, 102, 114,
                                                    97, 109, 101, 45, 98, 105, 97, 115, 61, 48, 32,
                                                    114, 99, 45, 108, 111, 111, 107, 97, 104, 101,
                                                    97, 100, 61, 50, 53, 32, 108, 111, 111, 107,
                                                    97, 104, 101, 97, 100, 45, 115, 108, 105, 99,
                                                    101, 115, 61, 52, 32, 115, 99, 101, 110, 101,
                                                    99, 117, 116, 61, 52, 48, 32, 114, 97, 100,
                                                    108, 61, 48, 32, 110, 111, 45, 105, 110, 116,
                                                    114, 97, 45, 114, 101, 102, 114, 101, 115, 104,
                                                    32, 99, 116, 117, 61, 54, 52, 32, 109, 105,
                                                    110, 45, 99, 117, 45, 115, 105, 122, 101, 61,
                                                    56, 32, 114, 101, 99, 116, 32, 110, 111, 45,
                                                    97, 109, 112, 32, 109, 97, 120, 45, 116, 117,
                                                    45, 115, 105, 122, 101, 61, 51, 50, 32, 116,
                                                    117, 45, 105, 110, 116, 101, 114, 45, 100, 101,
                                                    112, 116, 104, 61, 49, 32, 116, 117, 45, 105,
                                                    110, 116, 114, 97, 45, 100, 101, 112, 116, 104,
                                                    61, 49, 32, 108, 105, 109, 105, 116, 45, 116,
                                                    117, 61, 48, 32, 114, 100, 111, 113, 45, 108,
                                                    101, 118, 101, 108, 61, 50, 32, 100, 121, 110,
                                                    97, 109, 105, 99, 45, 114, 100, 61, 48, 46, 48,
                                                    48, 32, 110, 111, 45, 115, 115, 105, 109, 45,
                                                    114, 100, 32, 115, 105, 103, 110, 104, 105,
                                                    100, 101, 32, 110, 111, 45, 116, 115, 107, 105,
                                                    112, 32, 110, 114, 45, 105, 110, 116, 114, 97,
                                                    61, 48, 32, 110, 114, 45, 105, 110, 116, 101,
                                                    114, 61, 48, 32, 110, 111, 45, 99, 111, 110,
                                                    115, 116, 114, 97, 105, 110, 101, 100, 45, 105,
                                                    110, 116, 114, 97, 32, 115, 116, 114, 111, 110,
                                                    103, 45, 105, 110, 116, 114, 97, 45, 115, 109,
                                                    111, 111, 116, 104, 105, 110, 103, 32, 109, 97,
                                                    120, 45, 109, 101, 114, 103, 101, 61, 51, 32,
                                                    108, 105, 109, 105, 116, 45, 114, 101, 102,
                                                    115, 61, 51, 32, 108, 105, 109, 105, 116, 45,
                                                    109, 111, 100, 101, 115, 32, 109, 101, 61, 51,
                                                    32, 115, 117, 98, 109, 101, 61, 51, 32, 109,
                                                    101, 114, 97, 110, 103, 101, 61, 53, 55, 32,
                                                    116, 101, 109, 112, 111, 114, 97, 108, 45, 109,
                                                    118, 112, 32, 119, 101, 105, 103, 104, 116,
                                                    112, 32, 110, 111, 45, 119, 101, 105, 103, 104,
                                                    116, 98, 32, 110, 111, 45, 97, 110, 97, 108,
                                                    121, 122, 101, 45, 115, 114, 99, 45, 112, 105,
                                                    99, 115, 32, 100, 101, 98, 108, 111, 99, 107,
                                                    61, 48, 58, 48, 32, 115, 97, 111, 32, 110, 111,
                                                    45, 115, 97, 111, 45, 110, 111, 110, 45, 100,
                                                    101, 98, 108, 111, 99, 107, 32, 114, 100, 61,
                                                    52, 32, 110, 111, 45, 101, 97, 114, 108, 121,
                                                    45, 115, 107, 105, 112, 32, 114, 115, 107, 105,
                                                    112, 32, 110, 111, 45, 102, 97, 115, 116, 45,
                                                    105, 110, 116, 114, 97, 32, 110, 111, 45, 116,
                                                    115, 107, 105, 112, 45, 102, 97, 115, 116, 32,
                                                    110, 111, 45, 99, 117, 45, 108, 111, 115, 115,
                                                    108, 101, 115, 115, 32, 110, 111, 45, 98, 45,
                                                    105, 110, 116, 114, 97, 32, 110, 111, 45, 115,
                                                    112, 108, 105, 116, 114, 100, 45, 115, 107,
                                                    105, 112, 32, 114, 100, 112, 101, 110, 97, 108,
                                                    116, 121, 61, 48, 32, 112, 115, 121, 45, 114,
                                                    100, 61, 50, 46, 48, 48, 32, 112, 115, 121, 45,
                                                    114, 100, 111, 113, 61, 49, 46, 48, 48, 32,
                                                    110, 111, 45, 114, 100, 45, 114, 101, 102, 105,
                                                    110, 101, 32, 110, 111, 45, 108, 111, 115, 115,
                                                    108, 101, 115, 115, 32, 99, 98, 113, 112, 111,
                                                    102, 102, 115, 61, 48, 32, 99, 114, 113, 112,
                                                    111, 102, 102, 115, 61, 48, 32, 114, 99, 61,
                                                    97, 98, 114, 32, 98, 105, 116, 114, 97, 116,
                                                    101, 61, 50, 51, 50, 48, 48, 32, 113, 99, 111,
                                                    109, 112, 61, 48, 46, 54, 48, 32, 113, 112,
                                                    115, 116, 101, 112, 61, 52, 32, 115, 116, 97,
                                                    116, 115, 45, 119, 114, 105, 116, 101, 61, 48,
                                                    32, 115, 116, 97, 116, 115, 45, 114, 101, 97,
                                                    100, 61, 48, 32, 105, 112, 114, 97, 116, 105,
                                                    111, 61, 49, 46, 52, 48, 32, 112, 98, 114, 97,
                                                    116, 105, 111, 61, 49, 46, 51, 48, 32, 97, 113,
                                                    45, 109, 111, 100, 101, 61, 49, 32, 97, 113,
                                                    45, 115, 116, 114, 101, 110, 103, 116, 104, 61,
                                                    49, 46, 48, 48, 32, 99, 117, 116, 114, 101,
                                                    101, 32, 122, 111, 110, 101, 45, 99, 111, 117,
                                                    110, 116, 61, 48, 32, 110, 111, 45, 115, 116,
                                                    114, 105, 99, 116, 45, 99, 98, 114, 32, 113,
                                                    103, 45, 115, 105, 122, 101, 61, 51, 50, 32,
                                                    110, 111, 45, 114, 99, 45, 103, 114, 97, 105,
                                                    110, 32, 113, 112, 109, 97, 120, 61, 54, 57,
                                                    32, 113, 112, 109, 105, 110, 61, 48, 32, 110,
                                                    111, 45, 99, 111, 110, 115, 116, 45, 118, 98,
                                                    118, 32, 115, 97, 114, 61, 49, 32, 111, 118,
                                                    101, 114, 115, 99, 97, 110, 61, 48, 32, 118,
                                                    105, 100, 101, 111, 102, 111, 114, 109, 97,
                                                    116, 61, 53, 32, 114, 97, 110, 103, 101, 61,
                                                    48, 32, 99, 111, 108, 111, 114, 112, 114, 105,
                                                    109, 61, 50, 32, 116, 114, 97, 110, 115, 102,
                                                    101, 114, 61, 50, 32, 99, 111, 108, 111, 114,
                                                    109, 97, 116, 114, 105, 120, 61, 50, 32, 99,
                                                    104, 114, 111, 109, 97, 108, 111, 99, 61, 48,
                                                    32, 100, 105, 115, 112, 108, 97, 121, 45, 119,
                                                    105, 110, 100, 111, 119, 61, 48, 32, 109, 97,
                                                    120, 45, 99, 108, 108, 61, 48, 44, 48, 32, 109,
                                                    105, 110, 45, 108, 117, 109, 97, 61, 48, 32,
                                                    109, 97, 120, 45, 108, 117, 109, 97, 61, 50,
                                                    53, 53, 32, 108, 111, 103, 50, 45, 109, 97,
                                                    120, 45, 112, 111, 99, 45, 108, 115, 98, 61,
                                                    56, 32, 118, 117, 105, 45, 116, 105, 109, 105,
                                                    110, 103, 45, 105, 110, 102, 111, 32, 118, 117,
                                                    105, 45, 104, 114, 100, 45, 105, 110, 102, 111,
                                                    32, 115, 108, 105, 99, 101, 115, 61, 49, 32,
                                                    110, 111, 45, 111, 112, 116, 45, 113, 112, 45,
                                                    112, 112, 115, 32, 110, 111, 45, 111, 112, 116,
                                                    45, 114, 101, 102, 45, 108, 105, 115, 116, 45,
                                                    108, 101, 110, 103, 116, 104, 45, 112, 112,
                                                    115, 32, 110, 111, 45, 109, 117, 108, 116, 105,
                                                    45, 112, 97, 115, 115, 45, 111, 112, 116, 45,
                                                    114, 112, 115, 32, 115, 99, 101, 110, 101, 99,
                                                    117, 116, 45, 98, 105, 97, 115, 61, 48, 46, 48,
                                                    53, 32, 110, 111, 45, 111, 112, 116, 45, 99,
                                                    117, 45, 100, 101, 108, 116, 97, 45, 113, 112,
                                                    32, 110, 111, 45, 97, 113, 45, 109, 111, 116,
                                                    105, 111, 110, 32, 110, 111, 45, 104, 100, 114,
                                                    32, 110, 111, 45, 104, 100, 114, 45, 111, 112,
                                                    116, 32, 110, 111, 45, 100, 104, 100, 114, 49,
                                                    48, 45, 111, 112, 116, 32, 97, 110, 97, 108,
                                                    121, 115, 105, 115, 45, 114, 101, 117, 115,
                                                    101, 45, 108, 101, 118, 101, 108, 61, 53, 32,
                                                    115, 99, 97, 108, 101, 45, 102, 97, 99, 116,
                                                    111, 114, 61, 48, 32, 114, 101, 102, 105, 110,
                                                    101, 45, 105, 110, 116, 114, 97, 61, 48, 32,
                                                    114, 101, 102, 105, 110, 101, 45, 105, 110,
                                                    116, 101, 114, 61, 48, 32, 114, 101, 102, 105,
                                                    110, 101, 45, 109, 118, 61, 48, 32, 110, 111,
                                                    45, 108, 105, 109, 105, 116, 45, 115, 97, 111,
                                                    32, 99, 116, 117, 45, 105, 110, 102, 111, 61,
                                                    48, 32, 110, 111, 45, 108, 111, 119, 112, 97,
                                                    115, 115, 45, 100, 99, 116, 32, 114, 101, 102,
                                                    105, 110, 101, 45, 109, 118, 45, 116, 121, 112,
                                                    101, 61, 48, 32, 99, 111, 112, 121, 45, 112,
                                                    105, 99, 61, 49, 128
                                                ]]
                                            }
                                        ]
                                    },
                                    btrt: Some(Btrt {
                                        buffer_size_db: 0,
                                        max_bitrate: 25175730,
                                        avg_bitrate: 25175730
                                    }),
                                    colr: None,
                                    pasp: Some(Pasp {
                                        h_spacing: 1,
                                        v_spacing: 1,
                                    }),
                                    taic: None,
                                }
                                .into()],
                            },
                            stco: Some(Stco { entries: vec![] }),
                            ..Default::default()
                        }
                    }
                },
                udta: None,
            }],
            udta: Some(Udta {
                meta: Some(Meta {
                    hdlr: Hdlr {
                        handler: FourCC::new(b"mdir"),
                        name: "".into()
                    },
                    items: vec![Ilst::default().into(),],
                }),
                skip: None,
            })
        }
    );

    // Make sure the hev1 atom encodes/decodes to the exact same content.
    let hev1 = &moov.trak[0].mdia.minf.stbl.stsd.codecs[0];
    hev1.assert_encode_decode();

    let mut buf = Vec::new();
    ftyp.encode(&mut buf).expect("failed to encode ftyp");
    moov.encode(&mut buf).expect("failed to encode moov");

    // assert_eq!(buf, ENCODED);
}
