// Code generated by protoc-gen-psrpc v0.5.1, DO NOT EDIT.
// source: rpc/sip.proto

package rpc

import (
	"context"

	"github.com/livekit/psrpc"
	"github.com/livekit/psrpc/pkg/client"
	"github.com/livekit/psrpc/pkg/info"
	"github.com/livekit/psrpc/pkg/rand"
	"github.com/livekit/psrpc/pkg/server"
	"github.com/livekit/psrpc/version"
)

var _ = version.PsrpcVersion_0_5

// ============================
// SIPInternal Client Interface
// ============================

type SIPInternalClient interface {
	CreateSIPParticipant(ctx context.Context, topic string, req *InternalCreateSIPParticipantRequest, opts ...psrpc.RequestOption) (*InternalCreateSIPParticipantResponse, error)
}

// ================================
// SIPInternal ServerImpl Interface
// ================================

type SIPInternalServerImpl interface {
	CreateSIPParticipant(context.Context, *InternalCreateSIPParticipantRequest) (*InternalCreateSIPParticipantResponse, error)
	CreateSIPParticipantAffinity(context.Context, *InternalCreateSIPParticipantRequest) float32
}

// ============================
// SIPInternal Server Interface
// ============================

type SIPInternalServer interface {
	RegisterCreateSIPParticipantTopic(topic string) error
	DeregisterCreateSIPParticipantTopic(topic string)

	// Close and wait for pending RPCs to complete
	Shutdown()

	// Close immediately, without waiting for pending RPCs
	Kill()
}

// ==================
// SIPInternal Client
// ==================

type sIPInternalClient struct {
	client *client.RPCClient
}

// NewSIPInternalClient creates a psrpc client that implements the SIPInternalClient interface.
func NewSIPInternalClient(bus psrpc.MessageBus, opts ...psrpc.ClientOption) (SIPInternalClient, error) {
	sd := &info.ServiceDefinition{
		Name: "SIPInternal",
		ID:   rand.NewClientID(),
	}

	sd.RegisterMethod("CreateSIPParticipant", true, false, true, false)

	rpcClient, err := client.NewRPCClient(sd, bus, opts...)
	if err != nil {
		return nil, err
	}

	return &sIPInternalClient{
		client: rpcClient,
	}, nil
}

func (c *sIPInternalClient) CreateSIPParticipant(ctx context.Context, topic string, req *InternalCreateSIPParticipantRequest, opts ...psrpc.RequestOption) (*InternalCreateSIPParticipantResponse, error) {
	return client.RequestSingle[*InternalCreateSIPParticipantResponse](ctx, c.client, "CreateSIPParticipant", []string{topic}, req, opts...)
}

// ==================
// SIPInternal Server
// ==================

type sIPInternalServer struct {
	svc SIPInternalServerImpl
	rpc *server.RPCServer
}

// NewSIPInternalServer builds a RPCServer that will route requests
// to the corresponding method in the provided svc implementation.
func NewSIPInternalServer(svc SIPInternalServerImpl, bus psrpc.MessageBus, opts ...psrpc.ServerOption) (SIPInternalServer, error) {
	sd := &info.ServiceDefinition{
		Name: "SIPInternal",
		ID:   rand.NewServerID(),
	}

	s := server.NewRPCServer(sd, bus, opts...)

	sd.RegisterMethod("CreateSIPParticipant", true, false, true, false)
	return &sIPInternalServer{
		svc: svc,
		rpc: s,
	}, nil
}

func (s *sIPInternalServer) RegisterCreateSIPParticipantTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "CreateSIPParticipant", []string{topic}, s.svc.CreateSIPParticipant, s.svc.CreateSIPParticipantAffinity)
}

func (s *sIPInternalServer) DeregisterCreateSIPParticipantTopic(topic string) {
	s.rpc.DeregisterHandler("CreateSIPParticipant", []string{topic})
}

func (s *sIPInternalServer) Shutdown() {
	s.rpc.Close(false)
}

func (s *sIPInternalServer) Kill() {
	s.rpc.Close(true)
}

var psrpcFileDescriptor8 = []byte{
	// 358 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0x4d, 0x4f, 0xc2, 0x30,
	0x18, 0xc7, 0x53, 0x90, 0x01, 0x8f, 0xc1, 0x98, 0x8a, 0xda, 0xe0, 0xc5, 0xa0, 0x26, 0x68, 0xcc,
	0xe6, 0xcb, 0x17, 0x30, 0x7a, 0xda, 0xc5, 0x10, 0xd0, 0x8b, 0x97, 0x65, 0x74, 0x0d, 0x36, 0x6c,
	0x6d, 0x6d, 0x3b, 0x16, 0x6f, 0x9e, 0x4c, 0xfc, 0x20, 0x7e, 0x01, 0x3f, 0xa1, 0xd9, 0x06, 0x28,
	0x89, 0x18, 0x4e, 0xcb, 0xff, 0xf9, 0x3d, 0xcf, 0xfa, 0xeb, 0x0b, 0xb4, 0xb4, 0xa2, 0x9e, 0xe1,
	0xca, 0x55, 0x5a, 0x5a, 0x89, 0xab, 0x5a, 0xd1, 0x4e, 0x4b, 0x2a, 0xcb, 0xa5, 0x30, 0x65, 0xad,
	0xfb, 0x59, 0x81, 0x23, 0x5f, 0x58, 0xa6, 0x45, 0x18, 0xdf, 0x69, 0x16, 0x5a, 0x36, 0xf4, 0xfb,
	0xfd, 0x50, 0x5b, 0x4e, 0xb9, 0x0a, 0x85, 0x1d, 0xb0, 0x97, 0x94, 0x19, 0x8b, 0x09, 0xd4, 0xc3,
	0x28, 0xd2, 0xcc, 0x18, 0x52, 0x39, 0x44, 0xbd, 0xe6, 0x60, 0x1e, 0xf1, 0x1e, 0x38, 0x22, 0x4d,
	0x46, 0x4c, 0x93, 0x6a, 0x01, 0x66, 0x09, 0xef, 0x43, 0x9d, 0x86, 0x71, 0x1c, 0x58, 0x49, 0x36,
	0x4a, 0x90, 0xc7, 0x07, 0x89, 0x3b, 0xd0, 0x48, 0x4d, 0xbe, 0x60, 0xc2, 0x48, 0xad, 0x20, 0x8b,
	0x9c, 0x33, 0x15, 0x1a, 0x93, 0x49, 0x1d, 0x11, 0xa7, 0x64, 0xf3, 0x8c, 0x0f, 0xa0, 0xa9, 0xa5,
	0x4c, 0x82, 0x62, 0xb0, 0x5e, 0xc2, 0xbc, 0x70, 0x9f, 0x0f, 0x5e, 0x42, 0x5b, 0xfd, 0x58, 0x07,
	0x3c, 0x62, 0xc2, 0x72, 0xfb, 0x4a, 0x1a, 0x45, 0xdf, 0xce, 0x2f, 0xe6, 0xcf, 0x10, 0x6e, 0x43,
	0xcd, 0xca, 0x09, 0x13, 0xa4, 0x59, 0xf4, 0x94, 0x01, 0xef, 0x82, 0x93, 0x99, 0x20, 0xd5, 0x31,
	0x81, 0xb2, 0x9c, 0x99, 0x47, 0x1d, 0x77, 0xdf, 0x10, 0x1c, 0xff, 0x7f, 0x4e, 0x46, 0x49, 0x61,
	0x18, 0x3e, 0x81, 0xad, 0x65, 0x11, 0x82, 0x8a, 0xff, 0xb4, 0x96, 0x14, 0x56, 0xfa, 0x56, 0x56,
	0xfa, 0x5e, 0xbd, 0x23, 0xd8, 0x1c, 0xfa, 0xfd, 0xb9, 0x05, 0xce, 0xa0, 0xfd, 0x97, 0x09, 0xee,
	0xb9, 0x5a, 0x51, 0x77, 0x8d, 0x4b, 0xed, 0x9c, 0xae, 0xd1, 0x59, 0x6e, 0xab, 0x0b, 0x5f, 0x1f,
	0xc8, 0xd9, 0x46, 0x37, 0xe8, 0x02, 0xdd, 0x9e, 0x3f, 0x9d, 0x8d, 0xb9, 0x7d, 0x4e, 0x47, 0x2e,
	0x95, 0x89, 0x17, 0xf3, 0x29, 0x9b, 0x70, 0xbb, 0xf8, 0xaa, 0xc9, 0xd8, 0x33, 0x4c, 0x4f, 0x39,
	0x65, 0x9e, 0x56, 0x74, 0xe4, 0x14, 0x0f, 0xed, 0xfa, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x30, 0x78,
	0xc9, 0xf9, 0x8d, 0x02, 0x00, 0x00,
}
