// Tests for muxing multiple audio tracks
//
// To run tests while enabling printing to stdout/stderr
//
//    cargo test --test multiaudio -- --show-output

pub mod common;
use std::env;
use ffprobe::ffprobe;
use file_format::FileFormat;
use dash_mpd::media::AudioTrack;
use dash_mpd::ffmpeg::mux_multiaudio_video_ffmpeg;
use dash_mpd::fetch::DashDownloader;
use common::{setup_logging};


// To set up the input test files:
//
//  ffmpeg -y -i ~/shared/Porco* -map 0:a:0 -acodec copy -ss 1000 -to 1005 /tmp/audio1.mp4
//  ffmpeg -y -i ~/shared/Porco* -map 0:a:1 -acodec copy -ss 1000 -to 1005 /tmp/audio2.mp4
//  ffmpeg -y -i ~/shared/Porco* -map 0:v -vcodec copy -ss 1000 -to 1005 /tmp/video.mp4
#[tokio::test]
#[cfg(not(feature = "libav"))]
async fn test_muxing_multiaudio() {
    setup_logging();

    // let tmpd = tempfile::tempdir().unwrap();
    // let out = tmpd.path().join("multiaudio.mp4");
    let out = env::temp_dir().join("multiaudio.mp4");
    let mut audio_tracks = Vec::new();
    audio_tracks.push(AudioTrack {
        language: String::from("&&fre"),
        path: env::temp_dir().join("audio1.mp4")
    });
    audio_tracks.push(AudioTrack {
        language: String::from("japèè##"),
        path: env::temp_dir().join("audio2.mp4")
    });
    let video_path = env::temp_dir().join("video.mp4");
    let downloader = DashDownloader::new("http://localhost/dummy")
        .verbosity(2);
    mux_multiaudio_video_ffmpeg(&downloader, &out, &audio_tracks, &video_path).unwrap();
    let format = FileFormat::from_file(out.clone()).unwrap();
    assert_eq!(format, FileFormat::Mpeg4Part14Video);
    let meta = ffprobe(out).unwrap();
    assert_eq!(meta.streams.iter()
        .filter(|s| s.codec_type.eq(&Some(String::from("audio"))))
        .count(), 2);
    // warn!("Multiaudio output in {}", tmpd.path().display());
    // let _ = fs::remove_dir_all(tmpd);
}
