// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetTerminologyInput {
    /// <p>The name of the custom terminology being retrieved.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub terminology_data_format: ::std::option::Option<crate::types::TerminologyDataFormat>,
}
impl GetTerminologyInput {
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn terminology_data_format(&self) -> ::std::option::Option<&crate::types::TerminologyDataFormat> {
        self.terminology_data_format.as_ref()
    }
}
impl GetTerminologyInput {
    /// Creates a new builder-style object to manufacture [`GetTerminologyInput`](crate::operation::get_terminology::GetTerminologyInput).
    pub fn builder() -> crate::operation::get_terminology::builders::GetTerminologyInputBuilder {
        crate::operation::get_terminology::builders::GetTerminologyInputBuilder::default()
    }
}

/// A builder for [`GetTerminologyInput`](crate::operation::get_terminology::GetTerminologyInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetTerminologyInputBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) terminology_data_format: ::std::option::Option<crate::types::TerminologyDataFormat>,
}
impl GetTerminologyInputBuilder {
    /// <p>The name of the custom terminology being retrieved.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn terminology_data_format(mut self, input: crate::types::TerminologyDataFormat) -> Self {
        self.terminology_data_format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn set_terminology_data_format(mut self, input: ::std::option::Option<crate::types::TerminologyDataFormat>) -> Self {
        self.terminology_data_format = input;
        self
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn get_terminology_data_format(&self) -> &::std::option::Option<crate::types::TerminologyDataFormat> {
        &self.terminology_data_format
    }
    /// Consumes the builder and constructs a [`GetTerminologyInput`](crate::operation::get_terminology::GetTerminologyInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::get_terminology::GetTerminologyInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::get_terminology::GetTerminologyInput {
            name: self.name,
            terminology_data_format: self.terminology_data_format,
        })
    }
}
