// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_medical_scribe_stream::_get_medical_scribe_stream_output::GetMedicalScribeStreamOutputBuilder;

pub use crate::operation::get_medical_scribe_stream::_get_medical_scribe_stream_input::GetMedicalScribeStreamInputBuilder;

impl crate::operation::get_medical_scribe_stream::builders::GetMedicalScribeStreamInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_medical_scribe_stream();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetMedicalScribeStream`.
///
/// <p>Provides details about the specified Amazon Web Services HealthScribe streaming session. To view the status of the streaming session, check the <code>StreamStatus</code> field in the response. To get the details of post-stream analytics, including its status, check the <code>PostStreamAnalyticsResult</code> field in the response.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetMedicalScribeStreamFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_medical_scribe_stream::builders::GetMedicalScribeStreamInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamOutput,
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError,
    > for GetMedicalScribeStreamFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamOutput,
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetMedicalScribeStreamFluentBuilder {
    /// Creates a new `GetMedicalScribeStreamFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetMedicalScribeStream as a reference.
    pub fn as_input(&self) -> &crate::operation::get_medical_scribe_stream::builders::GetMedicalScribeStreamInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_medical_scribe_stream::GetMedicalScribeStream::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStream::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamOutput,
        crate::operation::get_medical_scribe_stream::GetMedicalScribeStreamError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The identifier of the HealthScribe streaming session you want information about.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.session_id(input.into());
        self
    }
    /// <p>The identifier of the HealthScribe streaming session you want information about.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_session_id(input);
        self
    }
    /// <p>The identifier of the HealthScribe streaming session you want information about.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_session_id()
    }
}
