// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::start_speech_synthesis_task::_start_speech_synthesis_task_output::StartSpeechSynthesisTaskOutputBuilder;

pub use crate::operation::start_speech_synthesis_task::_start_speech_synthesis_task_input::StartSpeechSynthesisTaskInputBuilder;

impl crate::operation::start_speech_synthesis_task::builders::StartSpeechSynthesisTaskInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.start_speech_synthesis_task();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `StartSpeechSynthesisTask`.
///
/// <p>Allows the creation of an asynchronous synthesis task, by starting a new <code>SpeechSynthesisTask</code>. This operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket for the service to store the output of the synthesis task and two optional parameters (<code>OutputS3KeyPrefix</code> and <code>SnsTopicArn</code>). Once the synthesis task is created, this operation will return a <code>SpeechSynthesisTask</code> object, which will include an identifier of this task as well as the current status. The <code>SpeechSynthesisTask</code> object is available for 72 hours after starting the asynchronous synthesis task.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct StartSpeechSynthesisTaskFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::start_speech_synthesis_task::builders::StartSpeechSynthesisTaskInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
    > for StartSpeechSynthesisTaskFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
            crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl StartSpeechSynthesisTaskFluentBuilder {
    /// Creates a new `StartSpeechSynthesisTaskFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the StartSpeechSynthesisTask as a reference.
    pub fn as_input(&self) -> &crate::operation::start_speech_synthesis_task::builders::StartSpeechSynthesisTaskInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTask::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTask::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn engine(mut self, input: crate::types::Engine) -> Self {
        self.inner = self.inner.engine(input);
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn set_engine(mut self, input: ::std::option::Option<crate::types::Engine>) -> Self {
        self.inner = self.inner.set_engine(input);
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Using a voice that is not supported for the engine selected will result in an error.</p>
    pub fn get_engine(&self) -> &::std::option::Option<crate::types::Engine> {
        self.inner.get_engine()
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.inner = self.inner.language_code(input);
        self
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.inner = self.inner.set_language_code(input);
        self
    }
    /// <p>Optional language code for the Speech Synthesis request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p>
    /// <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        self.inner.get_language_code()
    }
    ///
    /// Appends an item to `LexiconNames`.
    ///
    /// To override the contents of this collection use [`set_lexicon_names`](Self::set_lexicon_names).
    ///
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn lexicon_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.lexicon_names(input.into());
        self
    }
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn set_lexicon_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_lexicon_names(input);
        self
    }
    /// <p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice.</p>
    pub fn get_lexicon_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_lexicon_names()
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn output_format(mut self, input: crate::types::OutputFormat) -> Self {
        self.inner = self.inner.output_format(input);
        self
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn set_output_format(mut self, input: ::std::option::Option<crate::types::OutputFormat>) -> Self {
        self.inner = self.inner.set_output_format(input);
        self
    }
    /// <p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p>
    pub fn get_output_format(&self) -> &::std::option::Option<crate::types::OutputFormat> {
        self.inner.get_output_format()
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn output_s3_bucket_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.output_s3_bucket_name(input.into());
        self
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn set_output_s3_bucket_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_output_s3_bucket_name(input);
        self
    }
    /// <p>Amazon S3 bucket name to which the output file will be saved.</p>
    pub fn get_output_s3_bucket_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_output_s3_bucket_name()
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn output_s3_key_prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.output_s3_key_prefix(input.into());
        self
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn set_output_s3_key_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_output_s3_key_prefix(input);
        self
    }
    /// <p>The Amazon S3 key prefix for the output speech file.</p>
    pub fn get_output_s3_key_prefix(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_output_s3_key_prefix()
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn sample_rate(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sample_rate(input.into());
        self
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn set_sample_rate(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sample_rate(input);
        self
    }
    /// <p>The audio frequency specified in Hz.</p>
    /// <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p>
    /// <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p>
    pub fn get_sample_rate(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sample_rate()
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn sns_topic_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sns_topic_arn(input.into());
        self
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn set_sns_topic_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sns_topic_arn(input);
        self
    }
    /// <p>ARN for the SNS topic optionally used for providing status notification for a speech synthesis task.</p>
    pub fn get_sns_topic_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sns_topic_arn()
    }
    ///
    /// Appends an item to `SpeechMarkTypes`.
    ///
    /// To override the contents of this collection use [`set_speech_mark_types`](Self::set_speech_mark_types).
    ///
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn speech_mark_types(mut self, input: crate::types::SpeechMarkType) -> Self {
        self.inner = self.inner.speech_mark_types(input);
        self
    }
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn set_speech_mark_types(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>>) -> Self {
        self.inner = self.inner.set_speech_mark_types(input);
        self
    }
    /// <p>The type of speech marks returned for the input text.</p>
    pub fn get_speech_mark_types(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::SpeechMarkType>> {
        self.inner.get_speech_mark_types()
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.text(input.into());
        self
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn set_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_text(input);
        self
    }
    /// <p>The input text to synthesize. If you specify ssml as the TextType, follow the SSML format for the input text.</p>
    pub fn get_text(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_text()
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn text_type(mut self, input: crate::types::TextType) -> Self {
        self.inner = self.inner.text_type(input);
        self
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn set_text_type(mut self, input: ::std::option::Option<crate::types::TextType>) -> Self {
        self.inner = self.inner.set_text_type(input);
        self
    }
    /// <p>Specifies whether the input text is plain text or SSML. The default value is plain text.</p>
    pub fn get_text_type(&self) -> &::std::option::Option<crate::types::TextType> {
        self.inner.get_text_type()
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn voice_id(mut self, input: crate::types::VoiceId) -> Self {
        self.inner = self.inner.voice_id(input);
        self
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn set_voice_id(mut self, input: ::std::option::Option<crate::types::VoiceId>) -> Self {
        self.inner = self.inner.set_voice_id(input);
        self
    }
    /// <p>Voice ID to use for the synthesis.</p>
    pub fn get_voice_id(&self) -> &::std::option::Option<crate::types::VoiceId> {
        self.inner.get_voice_id()
    }
}
