// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::list_signaling_channels::_list_signaling_channels_output::ListSignalingChannelsOutputBuilder;

pub use crate::operation::list_signaling_channels::_list_signaling_channels_input::ListSignalingChannelsInputBuilder;

impl crate::operation::list_signaling_channels::builders::ListSignalingChannelsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::list_signaling_channels::ListSignalingChannelsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_signaling_channels::ListSignalingChannelsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.list_signaling_channels();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `ListSignalingChannels`.
///
/// <p>Returns an array of <code>ChannelInfo</code> objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a <code>ChannelNameCondition</code>.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct ListSignalingChannelsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::list_signaling_channels::builders::ListSignalingChannelsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::list_signaling_channels::ListSignalingChannelsOutput,
        crate::operation::list_signaling_channels::ListSignalingChannelsError,
    > for ListSignalingChannelsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::list_signaling_channels::ListSignalingChannelsOutput,
            crate::operation::list_signaling_channels::ListSignalingChannelsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl ListSignalingChannelsFluentBuilder {
    /// Creates a new `ListSignalingChannelsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the ListSignalingChannels as a reference.
    pub fn as_input(&self) -> &crate::operation::list_signaling_channels::builders::ListSignalingChannelsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_signaling_channels::ListSignalingChannelsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_signaling_channels::ListSignalingChannelsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::list_signaling_channels::ListSignalingChannels::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::list_signaling_channels::ListSignalingChannels::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::list_signaling_channels::ListSignalingChannelsOutput,
        crate::operation::list_signaling_channels::ListSignalingChannelsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::list_signaling_channels::paginator::ListSignalingChannelsPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(self) -> crate::operation::list_signaling_channels::paginator::ListSignalingChannelsPaginator {
        crate::operation::list_signaling_channels::paginator::ListSignalingChannelsPaginator::new(self.handle, self.inner)
    }
    /// <p>The maximum number of channels to return in the response. The default is 500.</p>
    pub fn max_results(mut self, input: i32) -> Self {
        self.inner = self.inner.max_results(input);
        self
    }
    /// <p>The maximum number of channels to return in the response. The default is 500.</p>
    pub fn set_max_results(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_max_results(input);
        self
    }
    /// <p>The maximum number of channels to return in the response. The default is 500.</p>
    pub fn get_max_results(&self) -> &::std::option::Option<i32> {
        self.inner.get_max_results()
    }
    /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
    /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    pub fn channel_name_condition(mut self, input: crate::types::ChannelNameCondition) -> Self {
        self.inner = self.inner.channel_name_condition(input);
        self
    }
    /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    pub fn set_channel_name_condition(mut self, input: ::std::option::Option<crate::types::ChannelNameCondition>) -> Self {
        self.inner = self.inner.set_channel_name_condition(input);
        self
    }
    /// <p>Optional: Returns only the channels that satisfy a specific condition.</p>
    pub fn get_channel_name_condition(&self) -> &::std::option::Option<crate::types::ChannelNameCondition> {
        self.inner.get_channel_name_condition()
    }
}
