// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace GES {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Timeline : Gst.Bin, GES.IExtractable, GES.IMetaContainer {

		public Timeline (IntPtr raw) : base(raw) {}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_new();

		public Timeline () : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Timeline)) {
				CreateNativeObject (new string [0], new GLib.Value[0]);
				return;
			}
			Raw = ges_timeline_new();
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_new_audio_video();

		public static Timeline NewAudioVideo()
		{
			Timeline result = new Timeline (ges_timeline_new_audio_video());
			return result;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_new_from_uri(IntPtr uri);

		public Timeline (string uri) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Timeline)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			Raw = ges_timeline_new_from_uri(native_uri);
			GLib.Marshaller.Free (native_uri);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_get_auto_transition(IntPtr raw);

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_timeline_set_auto_transition(IntPtr raw, bool auto_transition);

		[GLib.Property ("auto-transition")]
		public bool AutoTransition {
			get  {
				bool raw_ret = ges_timeline_get_auto_transition(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				ges_timeline_set_auto_transition(Handle, value);
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong ges_timeline_get_duration(IntPtr raw);

		[GLib.Property ("duration")]
		public ulong Duration {
			get  {
				ulong raw_ret = ges_timeline_get_duration(Handle);
				ulong ret = raw_ret;
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong ges_timeline_get_snapping_distance(IntPtr raw);

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_timeline_set_snapping_distance(IntPtr raw, ulong snapping_distance);

		[GLib.Property ("snapping-distance")]
		public ulong SnappingDistance {
			get  {
				ulong raw_ret = ges_timeline_get_snapping_distance(Handle);
				ulong ret = raw_ret;
				return ret;
			}
			set  {
				ges_timeline_set_snapping_distance(Handle, value);
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_layers(IntPtr raw);

		public GES.Layer[] Layers {
			get  {
				IntPtr raw_ret = ges_timeline_get_layers(Handle);
				GES.Layer[] ret = (GES.Layer[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.List), true, true, typeof(GES.Layer));
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_tracks(IntPtr raw);

		public GES.Track[] Tracks {
			get  {
				IntPtr raw_ret = ges_timeline_get_tracks(Handle);
				GES.Track[] ret = (GES.Track[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.List), true, true, typeof(GES.Track));
				return ret;
			}
		}

		[GLib.Signal("track-added")]
		public event GES.TrackAddedHandler TrackAdded {
			add {
				this.AddSignalHandler ("track-added", value, typeof (GES.TrackAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("track-added", value);
			}
		}

		[GLib.Signal("commited")]
		public event System.EventHandler Commited {
			add {
				this.AddSignalHandler ("commited", value);
			}
			remove {
				this.RemoveSignalHandler ("commited", value);
			}
		}

		[GLib.Signal("group-added")]
		public event GES.GroupAddedHandler GroupAdded {
			add {
				this.AddSignalHandler ("group-added", value, typeof (GES.GroupAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("group-added", value);
			}
		}

		[GLib.Signal("layer-added")]
		public event GES.LayerAddedHandler LayerAdded {
			add {
				this.AddSignalHandler ("layer-added", value, typeof (GES.LayerAddedArgs));
			}
			remove {
				this.RemoveSignalHandler ("layer-added", value);
			}
		}

		[GLib.Signal("snapping-started")]
		public event GES.SnappingStartedHandler SnappingStarted {
			add {
				this.AddSignalHandler ("snapping-started", value, typeof (GES.SnappingStartedArgs));
			}
			remove {
				this.RemoveSignalHandler ("snapping-started", value);
			}
		}

		[GLib.Signal("layer-removed")]
		public event GES.LayerRemovedHandler LayerRemoved {
			add {
				this.AddSignalHandler ("layer-removed", value, typeof (GES.LayerRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("layer-removed", value);
			}
		}

		[GLib.Signal("select-element-track")]
		public event GES.SelectElementTrackHandler SelectElementTrack {
			add {
				this.AddSignalHandler ("select-element-track", value, typeof (GES.SelectElementTrackArgs));
			}
			remove {
				this.RemoveSignalHandler ("select-element-track", value);
			}
		}

		[GLib.Signal("track-removed")]
		public event GES.TrackRemovedHandler TrackRemoved {
			add {
				this.AddSignalHandler ("track-removed", value, typeof (GES.TrackRemovedArgs));
			}
			remove {
				this.RemoveSignalHandler ("track-removed", value);
			}
		}

		[GLib.Signal("snapping-ended")]
		public event GES.SnappingEndedHandler SnappingEnded {
			add {
				this.AddSignalHandler ("snapping-ended", value, typeof (GES.SnappingEndedArgs));
			}
			remove {
				this.RemoveSignalHandler ("snapping-ended", value);
			}
		}

		static CommitedNativeDelegate Commited_cb_delegate;
		static CommitedNativeDelegate CommitedVMCallback {
			get {
				if (Commited_cb_delegate == null)
					Commited_cb_delegate = new CommitedNativeDelegate (Commited_cb);
				return Commited_cb_delegate;
			}
		}

		static void OverrideCommited (GLib.GType gtype)
		{
			OverrideCommited (gtype, CommitedVMCallback);
		}

		static void OverrideCommited (GLib.GType gtype, CommitedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "commited", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void CommitedNativeDelegate (IntPtr inst);

		static void Commited_cb (IntPtr inst)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnCommited ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideCommited")]
		protected virtual void OnCommited ()
		{
			InternalCommited ();
		}

		private void InternalCommited ()
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (1);
			GLib.Value[] vals = new GLib.Value [1];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static SelectElementTrackNativeDelegate SelectElementTrack_cb_delegate;
		static SelectElementTrackNativeDelegate SelectElementTrackVMCallback {
			get {
				if (SelectElementTrack_cb_delegate == null)
					SelectElementTrack_cb_delegate = new SelectElementTrackNativeDelegate (SelectElementTrack_cb);
				return SelectElementTrack_cb_delegate;
			}
		}

		static void OverrideSelectElementTrack (GLib.GType gtype)
		{
			OverrideSelectElementTrack (gtype, SelectElementTrackVMCallback);
		}

		static void OverrideSelectElementTrack (GLib.GType gtype, SelectElementTrackNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "select-element-track", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr SelectElementTrackNativeDelegate (IntPtr inst, IntPtr clip, IntPtr track_element);

		static IntPtr SelectElementTrack_cb (IntPtr inst, IntPtr clip, IntPtr track_element)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				GES.Track __result;
				__result = __obj.OnSelectElementTrack (GLib.Object.GetObject(clip) as GES.Clip, GLib.Object.GetObject(track_element) as GES.TrackElement);
				return __result == null ? IntPtr.Zero : __result.OwnedHandle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideSelectElementTrack")]
		protected virtual GES.Track OnSelectElementTrack (GES.Clip clip, GES.TrackElement track_element)
		{
			return InternalSelectElementTrack (clip, track_element);
		}

		private GES.Track InternalSelectElementTrack (GES.Clip clip, GES.TrackElement track_element)
		{
			GLib.Value ret = new GLib.Value (GLib.GType.Object);
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (clip);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (track_element);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
			GES.Track result = (GES.Track) ret;
			ret.Dispose ();
			return result;
		}

		static SnappingEndedNativeDelegate SnappingEnded_cb_delegate;
		static SnappingEndedNativeDelegate SnappingEndedVMCallback {
			get {
				if (SnappingEnded_cb_delegate == null)
					SnappingEnded_cb_delegate = new SnappingEndedNativeDelegate (SnappingEnded_cb);
				return SnappingEnded_cb_delegate;
			}
		}

		static void OverrideSnappingEnded (GLib.GType gtype)
		{
			OverrideSnappingEnded (gtype, SnappingEndedVMCallback);
		}

		static void OverrideSnappingEnded (GLib.GType gtype, SnappingEndedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "snapping-ended", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SnappingEndedNativeDelegate (IntPtr inst, IntPtr obj1, IntPtr obj2, ulong position);

		static void SnappingEnded_cb (IntPtr inst, IntPtr obj1, IntPtr obj2, ulong position)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnSnappingEnded (GLib.Object.GetObject(obj1) as GES.TrackElement, GLib.Object.GetObject(obj2) as GES.TrackElement, position);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideSnappingEnded")]
		protected virtual void OnSnappingEnded (GES.TrackElement obj1, GES.TrackElement obj2, ulong position)
		{
			InternalSnappingEnded (obj1, obj2, position);
		}

		private void InternalSnappingEnded (GES.TrackElement obj1, GES.TrackElement obj2, ulong position)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (4);
			GLib.Value[] vals = new GLib.Value [4];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (obj1);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (obj2);
			inst_and_params.Append (vals [2]);
			vals [3] = new GLib.Value (position);
			inst_and_params.Append (vals [3]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static SnappingStartedNativeDelegate SnappingStarted_cb_delegate;
		static SnappingStartedNativeDelegate SnappingStartedVMCallback {
			get {
				if (SnappingStarted_cb_delegate == null)
					SnappingStarted_cb_delegate = new SnappingStartedNativeDelegate (SnappingStarted_cb);
				return SnappingStarted_cb_delegate;
			}
		}

		static void OverrideSnappingStarted (GLib.GType gtype)
		{
			OverrideSnappingStarted (gtype, SnappingStartedVMCallback);
		}

		static void OverrideSnappingStarted (GLib.GType gtype, SnappingStartedNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "snapping-started", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SnappingStartedNativeDelegate (IntPtr inst, IntPtr obj1, IntPtr obj2, ulong position);

		static void SnappingStarted_cb (IntPtr inst, IntPtr obj1, IntPtr obj2, ulong position)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnSnappingStarted (GLib.Object.GetObject(obj1) as GES.TrackElement, GLib.Object.GetObject(obj2) as GES.TrackElement, position);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideSnappingStarted")]
		protected virtual void OnSnappingStarted (GES.TrackElement obj1, GES.TrackElement obj2, ulong position)
		{
			InternalSnappingStarted (obj1, obj2, position);
		}

		private void InternalSnappingStarted (GES.TrackElement obj1, GES.TrackElement obj2, ulong position)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (4);
			GLib.Value[] vals = new GLib.Value [4];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (obj1);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (obj2);
			inst_and_params.Append (vals [2]);
			vals [3] = new GLib.Value (position);
			inst_and_params.Append (vals [3]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static TrackAddedNativeDelegate TrackAdded_cb_delegate;
		static TrackAddedNativeDelegate TrackAddedVMCallback {
			get {
				if (TrackAdded_cb_delegate == null)
					TrackAdded_cb_delegate = new TrackAddedNativeDelegate (TrackAdded_cb);
				return TrackAdded_cb_delegate;
			}
		}

		static void OverrideTrackAdded (GLib.GType gtype)
		{
			OverrideTrackAdded (gtype, TrackAddedVMCallback);
		}

		static void OverrideTrackAdded (GLib.GType gtype, TrackAddedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("track_added"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void TrackAddedNativeDelegate (IntPtr inst, IntPtr track);

		static void TrackAdded_cb (IntPtr inst, IntPtr track)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnTrackAdded (GLib.Object.GetObject(track) as GES.Track);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideTrackAdded")]
		protected virtual void OnTrackAdded (GES.Track track)
		{
			InternalTrackAdded (track);
		}

		private void InternalTrackAdded (GES.Track track)
		{
			TrackAddedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("track_added"));
				unmanaged = (TrackAddedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(TrackAddedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, track == null ? IntPtr.Zero : track.Handle);
		}

		static TrackRemovedNativeDelegate TrackRemoved_cb_delegate;
		static TrackRemovedNativeDelegate TrackRemovedVMCallback {
			get {
				if (TrackRemoved_cb_delegate == null)
					TrackRemoved_cb_delegate = new TrackRemovedNativeDelegate (TrackRemoved_cb);
				return TrackRemoved_cb_delegate;
			}
		}

		static void OverrideTrackRemoved (GLib.GType gtype)
		{
			OverrideTrackRemoved (gtype, TrackRemovedVMCallback);
		}

		static void OverrideTrackRemoved (GLib.GType gtype, TrackRemovedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("track_removed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void TrackRemovedNativeDelegate (IntPtr inst, IntPtr track);

		static void TrackRemoved_cb (IntPtr inst, IntPtr track)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnTrackRemoved (GLib.Object.GetObject(track) as GES.Track);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideTrackRemoved")]
		protected virtual void OnTrackRemoved (GES.Track track)
		{
			InternalTrackRemoved (track);
		}

		private void InternalTrackRemoved (GES.Track track)
		{
			TrackRemovedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("track_removed"));
				unmanaged = (TrackRemovedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(TrackRemovedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, track == null ? IntPtr.Zero : track.Handle);
		}

		static LayerAddedNativeDelegate LayerAdded_cb_delegate;
		static LayerAddedNativeDelegate LayerAddedVMCallback {
			get {
				if (LayerAdded_cb_delegate == null)
					LayerAdded_cb_delegate = new LayerAddedNativeDelegate (LayerAdded_cb);
				return LayerAdded_cb_delegate;
			}
		}

		static void OverrideLayerAdded (GLib.GType gtype)
		{
			OverrideLayerAdded (gtype, LayerAddedVMCallback);
		}

		static void OverrideLayerAdded (GLib.GType gtype, LayerAddedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("layer_added"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void LayerAddedNativeDelegate (IntPtr inst, IntPtr layer);

		static void LayerAdded_cb (IntPtr inst, IntPtr layer)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnLayerAdded (GLib.Object.GetObject(layer) as GES.Layer);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideLayerAdded")]
		protected virtual void OnLayerAdded (GES.Layer layer)
		{
			InternalLayerAdded (layer);
		}

		private void InternalLayerAdded (GES.Layer layer)
		{
			LayerAddedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("layer_added"));
				unmanaged = (LayerAddedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(LayerAddedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, layer == null ? IntPtr.Zero : layer.Handle);
		}

		static LayerRemovedNativeDelegate LayerRemoved_cb_delegate;
		static LayerRemovedNativeDelegate LayerRemovedVMCallback {
			get {
				if (LayerRemoved_cb_delegate == null)
					LayerRemoved_cb_delegate = new LayerRemovedNativeDelegate (LayerRemoved_cb);
				return LayerRemoved_cb_delegate;
			}
		}

		static void OverrideLayerRemoved (GLib.GType gtype)
		{
			OverrideLayerRemoved (gtype, LayerRemovedVMCallback);
		}

		static void OverrideLayerRemoved (GLib.GType gtype, LayerRemovedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("layer_removed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void LayerRemovedNativeDelegate (IntPtr inst, IntPtr layer);

		static void LayerRemoved_cb (IntPtr inst, IntPtr layer)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnLayerRemoved (GLib.Object.GetObject(layer) as GES.Layer);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideLayerRemoved")]
		protected virtual void OnLayerRemoved (GES.Layer layer)
		{
			InternalLayerRemoved (layer);
		}

		private void InternalLayerRemoved (GES.Layer layer)
		{
			LayerRemovedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("layer_removed"));
				unmanaged = (LayerRemovedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(LayerRemovedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, layer == null ? IntPtr.Zero : layer.Handle);
		}

		static GroupAddedNativeDelegate GroupAdded_cb_delegate;
		static GroupAddedNativeDelegate GroupAddedVMCallback {
			get {
				if (GroupAdded_cb_delegate == null)
					GroupAdded_cb_delegate = new GroupAddedNativeDelegate (GroupAdded_cb);
				return GroupAdded_cb_delegate;
			}
		}

		static void OverrideGroupAdded (GLib.GType gtype)
		{
			OverrideGroupAdded (gtype, GroupAddedVMCallback);
		}

		static void OverrideGroupAdded (GLib.GType gtype, GroupAddedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("group_added"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GroupAddedNativeDelegate (IntPtr inst, IntPtr group);

		static void GroupAdded_cb (IntPtr inst, IntPtr group)
		{
			try {
				Timeline __obj = GLib.Object.GetObject (inst, false) as Timeline;
				__obj.OnGroupAdded (GLib.Object.GetObject(group) as GES.Group);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideGroupAdded")]
		protected virtual void OnGroupAdded (GES.Group group)
		{
			InternalGroupAdded (group);
		}

		private void InternalGroupAdded (GES.Group group)
		{
			GroupAddedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("group_added"));
				unmanaged = (GroupAddedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GroupAddedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, group == null ? IntPtr.Zero : group.Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("track_added"
							, Gst.Bin.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // track_added
							, null
							, "track_removed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("track_removed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // track_removed
							, "track_added"
							, "layer_added"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("layer_added"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // layer_added
							, "track_removed"
							, "layer_removed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("layer_removed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // layer_removed
							, "layer_added"
							, "group_added"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("group_added"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // group_added
							, "layer_removed"
							, "group_removed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("group_removed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // group_removed
							, "group_added"
							, "_ges_reserved"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_ges_reserved"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) * 4 // _ges_reserved
							, "group_removed"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = ges_timeline_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_add_layer(IntPtr raw, IntPtr layer);

		[Obsolete]
		public bool AddLayer(GES.Layer layer) {
			bool raw_ret = ges_timeline_add_layer(Handle, layer == null ? IntPtr.Zero : layer.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_add_track(IntPtr raw, IntPtr track);

		public bool AddTrack(GES.Track track) {
			bool raw_ret = ges_timeline_add_track(Handle, track == null ? IntPtr.Zero : track.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_append_layer(IntPtr raw);

		public GES.Layer AppendLayer() {
			IntPtr raw_ret = ges_timeline_append_layer(Handle);
			GES.Layer ret = GLib.Object.GetObject(raw_ret) as GES.Layer;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_commit(IntPtr raw);

		public bool Commit() {
			bool raw_ret = ges_timeline_commit(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_commit_sync(IntPtr raw);

		public bool CommitSync() {
			bool raw_ret = ges_timeline_commit_sync(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_timeline_disable_edit_apis(IntPtr raw, bool disable_edit_apis);

		public void DisableEditApis(bool disable_edit_apis) {
			ges_timeline_disable_edit_apis(Handle, disable_edit_apis);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_timeline_freeze_commit(IntPtr raw);

		public void FreezeCommit() {
			ges_timeline_freeze_commit(Handle);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_get_edit_apis_disabled(IntPtr raw);

		public bool EditApisDisabled { 
			get {
				bool raw_ret = ges_timeline_get_edit_apis_disabled(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_element(IntPtr raw, IntPtr name);

		public GES.TimelineElement GetElement(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = ges_timeline_get_element(Handle, native_name);
			GES.TimelineElement ret = GLib.Object.GetObject(raw_ret, true) as GES.TimelineElement;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern long ges_timeline_get_frame_at(IntPtr raw, ulong timestamp);

		public long GetFrameAt(ulong timestamp) {
			long raw_ret = ges_timeline_get_frame_at(Handle, timestamp);
			long ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong ges_timeline_get_frame_time(IntPtr raw, long frame_number);

		public ulong GetFrameTime(long frame_number) {
			ulong raw_ret = ges_timeline_get_frame_time(Handle, frame_number);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_groups(IntPtr raw);

		public GES.Group[] Groups { 
			get {
				IntPtr raw_ret = ges_timeline_get_groups(Handle);
				GES.Group[] ret = (GES.Group[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.List), false, false, typeof(GES.Group));
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_layer(IntPtr raw, uint priority);

		public GES.Layer GetLayer(uint priority) {
			IntPtr raw_ret = ges_timeline_get_layer(Handle, priority);
			GES.Layer ret = GLib.Object.GetObject(raw_ret, true) as GES.Layer;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_pad_for_track(IntPtr raw, IntPtr track);

		public Gst.Pad GetPadForTrack(GES.Track track) {
			IntPtr raw_ret = ges_timeline_get_pad_for_track(Handle, track == null ? IntPtr.Zero : track.Handle);
			Gst.Pad ret = GLib.Object.GetObject(raw_ret) as Gst.Pad;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_get_track_for_pad(IntPtr raw, IntPtr pad);

		public GES.Track GetTrackForPad(Gst.Pad pad) {
			IntPtr raw_ret = ges_timeline_get_track_for_pad(Handle, pad == null ? IntPtr.Zero : pad.Handle);
			GES.Track ret = GLib.Object.GetObject(raw_ret) as GES.Track;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_is_empty(IntPtr raw);

		public bool IsEmpty { 
			get {
				bool raw_ret = ges_timeline_is_empty(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool ges_timeline_load_from_uri(IntPtr raw, IntPtr uri, out IntPtr error);

		public unsafe bool LoadFromUri(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = ges_timeline_load_from_uri(Handle, native_uri, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_uri);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_move_layer(IntPtr raw, IntPtr layer, uint new_layer_priority);

		public bool MoveLayer(GES.Layer layer, uint new_layer_priority) {
			bool raw_ret = ges_timeline_move_layer(Handle, layer == null ? IntPtr.Zero : layer.Handle, new_layer_priority);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_timeline_paste_element(IntPtr raw, IntPtr element, ulong position, int layer_priority);

		public GES.TimelineElement PasteElement(GES.TimelineElement element, ulong position, int layer_priority) {
			IntPtr raw_ret = ges_timeline_paste_element(Handle, element == null ? IntPtr.Zero : element.Handle, position, layer_priority);
			GES.TimelineElement ret = GLib.Object.GetObject(raw_ret, true) as GES.TimelineElement;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_remove_layer(IntPtr raw, IntPtr layer);

		public bool RemoveLayer(GES.Layer layer) {
			bool raw_ret = ges_timeline_remove_layer(Handle, layer == null ? IntPtr.Zero : layer.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_timeline_remove_track(IntPtr raw, IntPtr track);

		public bool RemoveTrack(GES.Track track) {
			bool raw_ret = ges_timeline_remove_track(Handle, track == null ? IntPtr.Zero : track.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool ges_timeline_save_to_uri(IntPtr raw, IntPtr uri, IntPtr formatter_asset, bool overwrite, out IntPtr error);

		public unsafe bool SaveToUri(string uri, GES.Asset formatter_asset, bool overwrite) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = ges_timeline_save_to_uri(Handle, native_uri, formatter_asset == null ? IntPtr.Zero : formatter_asset.Handle, overwrite, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_uri);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		public bool SaveToUri(string uri, bool overwrite) {
			return SaveToUri (uri, null, overwrite);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_timeline_thaw_commit(IntPtr raw);

		public void ThawCommit() {
			ges_timeline_thaw_commit(Handle);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_extractable_get_asset(IntPtr raw);

		public GES.Asset Asset { 
			get {
				IntPtr raw_ret = ges_extractable_get_asset(Handle);
				GES.Asset ret = GLib.Object.GetObject(raw_ret) as GES.Asset;
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_extractable_get_id(IntPtr raw);

		public string Id { 
			get {
				IntPtr raw_ret = ges_extractable_get_id(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_extractable_set_asset(IntPtr raw, IntPtr asset);

		public bool SetAsset(GES.Asset asset) {
			bool raw_ret = ges_extractable_set_asset(Handle, asset == null ? IntPtr.Zero : asset.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_add_metas_from_string(IntPtr raw, IntPtr str);

		public bool AddMetasFromString(string str) {
			IntPtr native_str = GLib.Marshaller.StringToPtrGStrdup (str);
			bool raw_ret = ges_meta_container_add_metas_from_string(Handle, native_str);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_str);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_check_meta_registered(IntPtr raw, IntPtr meta_item, out int flags, out IntPtr type);

		public bool CheckMetaRegistered(string meta_item, out GES.MetaFlag flags, out GLib.GType type) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			int native_flags;
			IntPtr native_type;
			bool raw_ret = ges_meta_container_check_meta_registered(Handle, native_meta_item, out native_flags, out native_type);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			flags = (GES.MetaFlag) native_flags;
			type = new GLib.GType(native_type);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern void ges_meta_container_foreach(IntPtr raw, GESSharp.MetaForeachFuncNative func, IntPtr user_data);

		public void Foreach(GES.MetaForeachFunc func) {
			GESSharp.MetaForeachFuncWrapper func_wrapper = new GESSharp.MetaForeachFuncWrapper (func);
			ges_meta_container_foreach(Handle, func_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_boolean(IntPtr raw, IntPtr meta_item, out bool dest);

		public bool GetBoolean(string meta_item, out bool dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_boolean(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_date(IntPtr raw, IntPtr meta_item, out IntPtr dest);

		public bool GetDate(string meta_item, out GLib.Date dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_dest;
			bool raw_ret = ges_meta_container_get_date(Handle, native_meta_item, out native_dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			dest = new GLib.Date(native_dest);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_date_time(IntPtr raw, IntPtr meta_item, out IntPtr dest);

		public bool GetDateTime(string meta_item, out Gst.DateTime dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_dest;
			bool raw_ret = ges_meta_container_get_date_time(Handle, native_meta_item, out native_dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			dest = native_dest == IntPtr.Zero ? null : (Gst.DateTime) GLib.Opaque.GetOpaque (native_dest, typeof (Gst.DateTime), true);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_double(IntPtr raw, IntPtr meta_item, out double dest);

		public bool GetDouble(string meta_item, out double dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_double(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_float(IntPtr raw, IntPtr meta_item, out float dest);

		public bool GetFloat(string meta_item, out float dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_float(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_int(IntPtr raw, IntPtr meta_item, out int dest);

		public bool GetInt(string meta_item, out int dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_int(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_int64(IntPtr raw, IntPtr meta_item, out long dest);

		public bool GetInt64(string meta_item, out long dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_int64(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_meta_container_get_marker_list(IntPtr raw, IntPtr key);

		public GES.MarkerList GetMarkerList(string key) {
			IntPtr native_key = GLib.Marshaller.StringToPtrGStrdup (key);
			IntPtr raw_ret = ges_meta_container_get_marker_list(Handle, native_key);
			GES.MarkerList ret = GLib.Object.GetObject(raw_ret, true) as GES.MarkerList;
			GLib.Marshaller.Free (native_key);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_meta_container_get_meta(IntPtr raw, IntPtr key);

		public GLib.Value GetMeta(string key) {
			IntPtr native_key = GLib.Marshaller.StringToPtrGStrdup (key);
			IntPtr raw_ret = ges_meta_container_get_meta(Handle, native_key);
			GLib.Value ret = (GLib.Value) Marshal.PtrToStructure (raw_ret, typeof (GLib.Value));
			GLib.Marshaller.Free (native_key);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_meta_container_get_string(IntPtr raw, IntPtr meta_item);

		public string GetString(string meta_item) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr raw_ret = ges_meta_container_get_string(Handle, native_meta_item);
			string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_uint(IntPtr raw, IntPtr meta_item, out uint dest);

		public bool GetUint(string meta_item, out uint dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_uint(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_get_uint64(IntPtr raw, IntPtr meta_item, out ulong dest);

		public bool GetUint64(string meta_item, out ulong dest) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_get_uint64(Handle, native_meta_item, out dest);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr ges_meta_container_metas_to_string(IntPtr raw);

		public string MetasToString() {
			IntPtr raw_ret = ges_meta_container_metas_to_string(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta(IntPtr raw, int flags, IntPtr meta_item, IntPtr value);

		public bool RegisterMeta(GES.MetaFlag flags, string meta_item, GLib.Value value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_value = GLib.Marshaller.StructureToPtrAlloc (value);
			bool raw_ret = ges_meta_container_register_meta(Handle, (int) flags, native_meta_item, native_value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			Marshal.FreeHGlobal (native_value);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_boolean(IntPtr raw, int flags, IntPtr meta_item, bool value);

		public bool RegisterMetaBoolean(GES.MetaFlag flags, string meta_item, bool value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_boolean(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_date(IntPtr raw, int flags, IntPtr meta_item, IntPtr value);

		public bool RegisterMetaDate(GES.MetaFlag flags, string meta_item, GLib.Date value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_date(Handle, (int) flags, native_meta_item, value == null ? IntPtr.Zero : value.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_date_time(IntPtr raw, int flags, IntPtr meta_item, IntPtr value);

		public bool RegisterMetaDateTime(GES.MetaFlag flags, string meta_item, Gst.DateTime value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_date_time(Handle, (int) flags, native_meta_item, value == null ? IntPtr.Zero : value.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_double(IntPtr raw, int flags, IntPtr meta_item, double value);

		public bool RegisterMetaDouble(GES.MetaFlag flags, string meta_item, double value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_double(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_float(IntPtr raw, int flags, IntPtr meta_item, float value);

		public bool RegisterMetaFloat(GES.MetaFlag flags, string meta_item, float value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_float(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_int(IntPtr raw, int flags, IntPtr meta_item, int value);

		public bool RegisterMetaInt(GES.MetaFlag flags, string meta_item, int value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_int(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_int64(IntPtr raw, int flags, IntPtr meta_item, long value);

		public bool RegisterMetaInt64(GES.MetaFlag flags, string meta_item, long value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_int64(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_string(IntPtr raw, int flags, IntPtr meta_item, IntPtr value);

		public bool RegisterMetaString(GES.MetaFlag flags, string meta_item, string value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			bool raw_ret = ges_meta_container_register_meta_string(Handle, (int) flags, native_meta_item, native_value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			GLib.Marshaller.Free (native_value);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_uint(IntPtr raw, int flags, IntPtr meta_item, uint value);

		public bool RegisterMetaUint(GES.MetaFlag flags, string meta_item, uint value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_uint(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_meta_uint64(IntPtr raw, int flags, IntPtr meta_item, ulong value);

		public bool RegisterMetaUint64(GES.MetaFlag flags, string meta_item, ulong value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_meta_uint64(Handle, (int) flags, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_register_static_meta(IntPtr raw, int flags, IntPtr meta_item, IntPtr type);

		public bool RegisterStaticMeta(GES.MetaFlag flags, string meta_item, GLib.GType type) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_register_static_meta(Handle, (int) flags, native_meta_item, type.Val);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_boolean(IntPtr raw, IntPtr meta_item, bool value);

		public bool SetBoolean(string meta_item, bool value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_boolean(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_date(IntPtr raw, IntPtr meta_item, IntPtr value);

		public bool SetDate(string meta_item, GLib.Date value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_date(Handle, native_meta_item, value == null ? IntPtr.Zero : value.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_date_time(IntPtr raw, IntPtr meta_item, IntPtr value);

		public bool SetDateTime(string meta_item, Gst.DateTime value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_date_time(Handle, native_meta_item, value == null ? IntPtr.Zero : value.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_double(IntPtr raw, IntPtr meta_item, double value);

		public bool SetDouble(string meta_item, double value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_double(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_float(IntPtr raw, IntPtr meta_item, float value);

		public bool SetFloat(string meta_item, float value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_float(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_int(IntPtr raw, IntPtr meta_item, int value);

		public bool SetInt(string meta_item, int value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_int(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_int64(IntPtr raw, IntPtr meta_item, long value);

		public bool SetInt64(string meta_item, long value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_int64(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_marker_list(IntPtr raw, IntPtr meta_item, IntPtr list);

		public bool SetMarkerList(string meta_item, GES.MarkerList list) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_marker_list(Handle, native_meta_item, list == null ? IntPtr.Zero : list.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_meta(IntPtr raw, IntPtr meta_item, IntPtr value);

		public bool SetMeta(string meta_item, GLib.Value value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_value = GLib.Marshaller.StructureToPtrAlloc (value);
			bool raw_ret = ges_meta_container_set_meta(Handle, native_meta_item, native_value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			Marshal.FreeHGlobal (native_value);
			return ret;
		}

		public bool SetMeta(string meta_item) {
			return SetMeta (meta_item, GLib.Value.Empty);
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_string(IntPtr raw, IntPtr meta_item, IntPtr value);

		public bool SetString(string meta_item, string value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			bool raw_ret = ges_meta_container_set_string(Handle, native_meta_item, native_value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			GLib.Marshaller.Free (native_value);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_uint(IntPtr raw, IntPtr meta_item, uint value);

		public bool SetUint(string meta_item, uint value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_uint(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[DllImport("ges-1.0", CallingConvention = CallingConvention.Cdecl)]
		static extern bool ges_meta_container_set_uint64(IntPtr raw, IntPtr meta_item, ulong value);

		public bool SetUint64(string meta_item, ulong value) {
			IntPtr native_meta_item = GLib.Marshaller.StringToPtrGStrdup (meta_item);
			bool raw_ret = ges_meta_container_set_uint64(Handle, native_meta_item, value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_meta_item);
			return ret;
		}

		[GLib.Signal("notify-meta")]
		public event GES.NotifyMetaHandler NotifyMeta {
			add {
				this.AddSignalHandler ("notify-meta", value, typeof (GES.NotifyMetaArgs));
			}
			remove {
				this.RemoveSignalHandler ("notify-meta", value);
			}
		}

		static NotifyMetaNativeDelegate NotifyMeta_cb_delegate;
		static NotifyMetaNativeDelegate NotifyMetaVMCallback {
			get {
				if (NotifyMeta_cb_delegate == null)
					NotifyMeta_cb_delegate = new NotifyMetaNativeDelegate (NotifyMeta_cb);
				return NotifyMeta_cb_delegate;
			}
		}

		static void OverrideNotifyMeta (GLib.GType gtype)
		{
			OverrideNotifyMeta (gtype, NotifyMetaVMCallback);
		}

		static void OverrideNotifyMeta (GLib.GType gtype, NotifyMetaNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "notify-meta", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void NotifyMetaNativeDelegate (IntPtr inst, IntPtr key, IntPtr value);

		static void NotifyMeta_cb (IntPtr inst, IntPtr key, IntPtr value)
		{
			try {
				GES.Timeline __obj = GLib.Object.GetObject (inst, false) as GES.Timeline;
				__obj.OnNotifyMeta (GLib.Marshaller.Utf8PtrToString (key), (GLib.Value) Marshal.PtrToStructure (value, typeof (GLib.Value)));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(GES.Timeline), ConnectionMethod="OverrideNotifyMeta")]
		protected virtual void OnNotifyMeta (string key, GLib.Value value)
		{
			InternalNotifyMeta (key, value);
		}

		private void InternalNotifyMeta (string key, GLib.Value value)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (3);
			GLib.Value[] vals = new GLib.Value [3];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (key);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (value);
			inst_and_params.Append (vals [2]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}


		static Timeline ()
		{
			GtkSharp.GstEditingServices.ObjectManager.Initialize ();
		}

		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("layers"
							, Gst.Bin.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // layers
							, null
							, "tracks"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("tracks"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // tracks
							, "layers"
							, "priv"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("priv"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, "tracks"
							, "_ges_reserved"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_ges_reserved"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) * 4 // _ges_reserved
							, "priv"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
