// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_rtc.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SignalTarget int32

const (
	SignalTarget_PUBLISHER  SignalTarget = 0
	SignalTarget_SUBSCRIBER SignalTarget = 1
)

// Enum value maps for SignalTarget.
var (
	SignalTarget_name = map[int32]string{
		0: "PUBLISHER",
		1: "SUBSCRIBER",
	}
	SignalTarget_value = map[string]int32{
		"PUBLISHER":  0,
		"SUBSCRIBER": 1,
	}
)

func (x SignalTarget) Enum() *SignalTarget {
	p := new(SignalTarget)
	*p = x
	return p
}

func (x SignalTarget) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SignalTarget) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_rtc_proto_enumTypes[0].Descriptor()
}

func (SignalTarget) Type() protoreflect.EnumType {
	return &file_livekit_rtc_proto_enumTypes[0]
}

func (x SignalTarget) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SignalTarget.Descriptor instead.
func (SignalTarget) EnumDescriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{0}
}

type StreamState int32

const (
	StreamState_ACTIVE StreamState = 0
	StreamState_PAUSED StreamState = 1
)

// Enum value maps for StreamState.
var (
	StreamState_name = map[int32]string{
		0: "ACTIVE",
		1: "PAUSED",
	}
	StreamState_value = map[string]int32{
		"ACTIVE": 0,
		"PAUSED": 1,
	}
)

func (x StreamState) Enum() *StreamState {
	p := new(StreamState)
	*p = x
	return p
}

func (x StreamState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamState) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_rtc_proto_enumTypes[1].Descriptor()
}

func (StreamState) Type() protoreflect.EnumType {
	return &file_livekit_rtc_proto_enumTypes[1]
}

func (x StreamState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamState.Descriptor instead.
func (StreamState) EnumDescriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{1}
}

type CandidateProtocol int32

const (
	CandidateProtocol_UDP CandidateProtocol = 0
	CandidateProtocol_TCP CandidateProtocol = 1
	CandidateProtocol_TLS CandidateProtocol = 2
)

// Enum value maps for CandidateProtocol.
var (
	CandidateProtocol_name = map[int32]string{
		0: "UDP",
		1: "TCP",
		2: "TLS",
	}
	CandidateProtocol_value = map[string]int32{
		"UDP": 0,
		"TCP": 1,
		"TLS": 2,
	}
)

func (x CandidateProtocol) Enum() *CandidateProtocol {
	p := new(CandidateProtocol)
	*p = x
	return p
}

func (x CandidateProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CandidateProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_rtc_proto_enumTypes[2].Descriptor()
}

func (CandidateProtocol) Type() protoreflect.EnumType {
	return &file_livekit_rtc_proto_enumTypes[2]
}

func (x CandidateProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CandidateProtocol.Descriptor instead.
func (CandidateProtocol) EnumDescriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{2}
}

// indicates action clients should take on receiving this message
type LeaveRequest_Action int32

const (
	LeaveRequest_DISCONNECT LeaveRequest_Action = 0 // should disconnect
	LeaveRequest_RESUME     LeaveRequest_Action = 1 // should attempt a resume with `reconnect=1` in join URL
	LeaveRequest_RECONNECT  LeaveRequest_Action = 2 // should attempt a reconnect, i. e. no `reconnect=1`
)

// Enum value maps for LeaveRequest_Action.
var (
	LeaveRequest_Action_name = map[int32]string{
		0: "DISCONNECT",
		1: "RESUME",
		2: "RECONNECT",
	}
	LeaveRequest_Action_value = map[string]int32{
		"DISCONNECT": 0,
		"RESUME":     1,
		"RECONNECT":  2,
	}
)

func (x LeaveRequest_Action) Enum() *LeaveRequest_Action {
	p := new(LeaveRequest_Action)
	*p = x
	return p
}

func (x LeaveRequest_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LeaveRequest_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_rtc_proto_enumTypes[3].Descriptor()
}

func (LeaveRequest_Action) Type() protoreflect.EnumType {
	return &file_livekit_rtc_proto_enumTypes[3]
}

func (x LeaveRequest_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LeaveRequest_Action.Descriptor instead.
func (LeaveRequest_Action) EnumDescriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{14, 0}
}

type SignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*SignalRequest_Offer
	//	*SignalRequest_Answer
	//	*SignalRequest_Trickle
	//	*SignalRequest_AddTrack
	//	*SignalRequest_Mute
	//	*SignalRequest_Subscription
	//	*SignalRequest_TrackSetting
	//	*SignalRequest_Leave
	//	*SignalRequest_UpdateLayers
	//	*SignalRequest_SubscriptionPermission
	//	*SignalRequest_SyncState
	//	*SignalRequest_Simulate
	//	*SignalRequest_Ping
	//	*SignalRequest_UpdateMetadata
	//	*SignalRequest_PingReq
	Message isSignalRequest_Message `protobuf_oneof:"message"`
}

func (x *SignalRequest) Reset() {
	*x = SignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignalRequest) ProtoMessage() {}

func (x *SignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignalRequest.ProtoReflect.Descriptor instead.
func (*SignalRequest) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{0}
}

func (m *SignalRequest) GetMessage() isSignalRequest_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *SignalRequest) GetOffer() *SessionDescription {
	if x, ok := x.GetMessage().(*SignalRequest_Offer); ok {
		return x.Offer
	}
	return nil
}

func (x *SignalRequest) GetAnswer() *SessionDescription {
	if x, ok := x.GetMessage().(*SignalRequest_Answer); ok {
		return x.Answer
	}
	return nil
}

func (x *SignalRequest) GetTrickle() *TrickleRequest {
	if x, ok := x.GetMessage().(*SignalRequest_Trickle); ok {
		return x.Trickle
	}
	return nil
}

func (x *SignalRequest) GetAddTrack() *AddTrackRequest {
	if x, ok := x.GetMessage().(*SignalRequest_AddTrack); ok {
		return x.AddTrack
	}
	return nil
}

func (x *SignalRequest) GetMute() *MuteTrackRequest {
	if x, ok := x.GetMessage().(*SignalRequest_Mute); ok {
		return x.Mute
	}
	return nil
}

func (x *SignalRequest) GetSubscription() *UpdateSubscription {
	if x, ok := x.GetMessage().(*SignalRequest_Subscription); ok {
		return x.Subscription
	}
	return nil
}

func (x *SignalRequest) GetTrackSetting() *UpdateTrackSettings {
	if x, ok := x.GetMessage().(*SignalRequest_TrackSetting); ok {
		return x.TrackSetting
	}
	return nil
}

func (x *SignalRequest) GetLeave() *LeaveRequest {
	if x, ok := x.GetMessage().(*SignalRequest_Leave); ok {
		return x.Leave
	}
	return nil
}

func (x *SignalRequest) GetUpdateLayers() *UpdateVideoLayers {
	if x, ok := x.GetMessage().(*SignalRequest_UpdateLayers); ok {
		return x.UpdateLayers
	}
	return nil
}

func (x *SignalRequest) GetSubscriptionPermission() *SubscriptionPermission {
	if x, ok := x.GetMessage().(*SignalRequest_SubscriptionPermission); ok {
		return x.SubscriptionPermission
	}
	return nil
}

func (x *SignalRequest) GetSyncState() *SyncState {
	if x, ok := x.GetMessage().(*SignalRequest_SyncState); ok {
		return x.SyncState
	}
	return nil
}

func (x *SignalRequest) GetSimulate() *SimulateScenario {
	if x, ok := x.GetMessage().(*SignalRequest_Simulate); ok {
		return x.Simulate
	}
	return nil
}

func (x *SignalRequest) GetPing() int64 {
	if x, ok := x.GetMessage().(*SignalRequest_Ping); ok {
		return x.Ping
	}
	return 0
}

func (x *SignalRequest) GetUpdateMetadata() *UpdateParticipantMetadata {
	if x, ok := x.GetMessage().(*SignalRequest_UpdateMetadata); ok {
		return x.UpdateMetadata
	}
	return nil
}

func (x *SignalRequest) GetPingReq() *Ping {
	if x, ok := x.GetMessage().(*SignalRequest_PingReq); ok {
		return x.PingReq
	}
	return nil
}

type isSignalRequest_Message interface {
	isSignalRequest_Message()
}

type SignalRequest_Offer struct {
	// initial join exchange, for publisher
	Offer *SessionDescription `protobuf:"bytes,1,opt,name=offer,proto3,oneof"`
}

type SignalRequest_Answer struct {
	// participant answering publisher offer
	Answer *SessionDescription `protobuf:"bytes,2,opt,name=answer,proto3,oneof"`
}

type SignalRequest_Trickle struct {
	Trickle *TrickleRequest `protobuf:"bytes,3,opt,name=trickle,proto3,oneof"`
}

type SignalRequest_AddTrack struct {
	AddTrack *AddTrackRequest `protobuf:"bytes,4,opt,name=add_track,json=addTrack,proto3,oneof"`
}

type SignalRequest_Mute struct {
	// mute the participant's published tracks
	Mute *MuteTrackRequest `protobuf:"bytes,5,opt,name=mute,proto3,oneof"`
}

type SignalRequest_Subscription struct {
	// Subscribe or unsubscribe from tracks
	Subscription *UpdateSubscription `protobuf:"bytes,6,opt,name=subscription,proto3,oneof"`
}

type SignalRequest_TrackSetting struct {
	// Update settings of subscribed tracks
	TrackSetting *UpdateTrackSettings `protobuf:"bytes,7,opt,name=track_setting,json=trackSetting,proto3,oneof"`
}

type SignalRequest_Leave struct {
	// Immediately terminate session
	Leave *LeaveRequest `protobuf:"bytes,8,opt,name=leave,proto3,oneof"`
}

type SignalRequest_UpdateLayers struct {
	// Update published video layers
	UpdateLayers *UpdateVideoLayers `protobuf:"bytes,10,opt,name=update_layers,json=updateLayers,proto3,oneof"`
}

type SignalRequest_SubscriptionPermission struct {
	// Update subscriber permissions
	SubscriptionPermission *SubscriptionPermission `protobuf:"bytes,11,opt,name=subscription_permission,json=subscriptionPermission,proto3,oneof"`
}

type SignalRequest_SyncState struct {
	// sync client's subscribe state to server during reconnect
	SyncState *SyncState `protobuf:"bytes,12,opt,name=sync_state,json=syncState,proto3,oneof"`
}

type SignalRequest_Simulate struct {
	// Simulate conditions, for client validations
	Simulate *SimulateScenario `protobuf:"bytes,13,opt,name=simulate,proto3,oneof"`
}

type SignalRequest_Ping struct {
	// client triggered ping to server
	Ping int64 `protobuf:"varint,14,opt,name=ping,proto3,oneof"` // deprecated by ping_req (message Ping)
}

type SignalRequest_UpdateMetadata struct {
	// update a participant's own metadata and/or name
	UpdateMetadata *UpdateParticipantMetadata `protobuf:"bytes,15,opt,name=update_metadata,json=updateMetadata,proto3,oneof"`
}

type SignalRequest_PingReq struct {
	PingReq *Ping `protobuf:"bytes,16,opt,name=ping_req,json=pingReq,proto3,oneof"`
}

func (*SignalRequest_Offer) isSignalRequest_Message() {}

func (*SignalRequest_Answer) isSignalRequest_Message() {}

func (*SignalRequest_Trickle) isSignalRequest_Message() {}

func (*SignalRequest_AddTrack) isSignalRequest_Message() {}

func (*SignalRequest_Mute) isSignalRequest_Message() {}

func (*SignalRequest_Subscription) isSignalRequest_Message() {}

func (*SignalRequest_TrackSetting) isSignalRequest_Message() {}

func (*SignalRequest_Leave) isSignalRequest_Message() {}

func (*SignalRequest_UpdateLayers) isSignalRequest_Message() {}

func (*SignalRequest_SubscriptionPermission) isSignalRequest_Message() {}

func (*SignalRequest_SyncState) isSignalRequest_Message() {}

func (*SignalRequest_Simulate) isSignalRequest_Message() {}

func (*SignalRequest_Ping) isSignalRequest_Message() {}

func (*SignalRequest_UpdateMetadata) isSignalRequest_Message() {}

func (*SignalRequest_PingReq) isSignalRequest_Message() {}

type SignalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*SignalResponse_Join
	//	*SignalResponse_Answer
	//	*SignalResponse_Offer
	//	*SignalResponse_Trickle
	//	*SignalResponse_Update
	//	*SignalResponse_TrackPublished
	//	*SignalResponse_Leave
	//	*SignalResponse_Mute
	//	*SignalResponse_SpeakersChanged
	//	*SignalResponse_RoomUpdate
	//	*SignalResponse_ConnectionQuality
	//	*SignalResponse_StreamStateUpdate
	//	*SignalResponse_SubscribedQualityUpdate
	//	*SignalResponse_SubscriptionPermissionUpdate
	//	*SignalResponse_RefreshToken
	//	*SignalResponse_TrackUnpublished
	//	*SignalResponse_Pong
	//	*SignalResponse_Reconnect
	//	*SignalResponse_PongResp
	//	*SignalResponse_SubscriptionResponse
	Message isSignalResponse_Message `protobuf_oneof:"message"`
}

func (x *SignalResponse) Reset() {
	*x = SignalResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignalResponse) ProtoMessage() {}

func (x *SignalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignalResponse.ProtoReflect.Descriptor instead.
func (*SignalResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{1}
}

func (m *SignalResponse) GetMessage() isSignalResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *SignalResponse) GetJoin() *JoinResponse {
	if x, ok := x.GetMessage().(*SignalResponse_Join); ok {
		return x.Join
	}
	return nil
}

func (x *SignalResponse) GetAnswer() *SessionDescription {
	if x, ok := x.GetMessage().(*SignalResponse_Answer); ok {
		return x.Answer
	}
	return nil
}

func (x *SignalResponse) GetOffer() *SessionDescription {
	if x, ok := x.GetMessage().(*SignalResponse_Offer); ok {
		return x.Offer
	}
	return nil
}

func (x *SignalResponse) GetTrickle() *TrickleRequest {
	if x, ok := x.GetMessage().(*SignalResponse_Trickle); ok {
		return x.Trickle
	}
	return nil
}

func (x *SignalResponse) GetUpdate() *ParticipantUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_Update); ok {
		return x.Update
	}
	return nil
}

func (x *SignalResponse) GetTrackPublished() *TrackPublishedResponse {
	if x, ok := x.GetMessage().(*SignalResponse_TrackPublished); ok {
		return x.TrackPublished
	}
	return nil
}

func (x *SignalResponse) GetLeave() *LeaveRequest {
	if x, ok := x.GetMessage().(*SignalResponse_Leave); ok {
		return x.Leave
	}
	return nil
}

func (x *SignalResponse) GetMute() *MuteTrackRequest {
	if x, ok := x.GetMessage().(*SignalResponse_Mute); ok {
		return x.Mute
	}
	return nil
}

func (x *SignalResponse) GetSpeakersChanged() *SpeakersChanged {
	if x, ok := x.GetMessage().(*SignalResponse_SpeakersChanged); ok {
		return x.SpeakersChanged
	}
	return nil
}

func (x *SignalResponse) GetRoomUpdate() *RoomUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_RoomUpdate); ok {
		return x.RoomUpdate
	}
	return nil
}

func (x *SignalResponse) GetConnectionQuality() *ConnectionQualityUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_ConnectionQuality); ok {
		return x.ConnectionQuality
	}
	return nil
}

func (x *SignalResponse) GetStreamStateUpdate() *StreamStateUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_StreamStateUpdate); ok {
		return x.StreamStateUpdate
	}
	return nil
}

func (x *SignalResponse) GetSubscribedQualityUpdate() *SubscribedQualityUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_SubscribedQualityUpdate); ok {
		return x.SubscribedQualityUpdate
	}
	return nil
}

func (x *SignalResponse) GetSubscriptionPermissionUpdate() *SubscriptionPermissionUpdate {
	if x, ok := x.GetMessage().(*SignalResponse_SubscriptionPermissionUpdate); ok {
		return x.SubscriptionPermissionUpdate
	}
	return nil
}

func (x *SignalResponse) GetRefreshToken() string {
	if x, ok := x.GetMessage().(*SignalResponse_RefreshToken); ok {
		return x.RefreshToken
	}
	return ""
}

func (x *SignalResponse) GetTrackUnpublished() *TrackUnpublishedResponse {
	if x, ok := x.GetMessage().(*SignalResponse_TrackUnpublished); ok {
		return x.TrackUnpublished
	}
	return nil
}

func (x *SignalResponse) GetPong() int64 {
	if x, ok := x.GetMessage().(*SignalResponse_Pong); ok {
		return x.Pong
	}
	return 0
}

func (x *SignalResponse) GetReconnect() *ReconnectResponse {
	if x, ok := x.GetMessage().(*SignalResponse_Reconnect); ok {
		return x.Reconnect
	}
	return nil
}

func (x *SignalResponse) GetPongResp() *Pong {
	if x, ok := x.GetMessage().(*SignalResponse_PongResp); ok {
		return x.PongResp
	}
	return nil
}

func (x *SignalResponse) GetSubscriptionResponse() *SubscriptionResponse {
	if x, ok := x.GetMessage().(*SignalResponse_SubscriptionResponse); ok {
		return x.SubscriptionResponse
	}
	return nil
}

type isSignalResponse_Message interface {
	isSignalResponse_Message()
}

type SignalResponse_Join struct {
	// sent when join is accepted
	Join *JoinResponse `protobuf:"bytes,1,opt,name=join,proto3,oneof"`
}

type SignalResponse_Answer struct {
	// sent when server answers publisher
	Answer *SessionDescription `protobuf:"bytes,2,opt,name=answer,proto3,oneof"`
}

type SignalResponse_Offer struct {
	// sent when server is sending subscriber an offer
	Offer *SessionDescription `protobuf:"bytes,3,opt,name=offer,proto3,oneof"`
}

type SignalResponse_Trickle struct {
	// sent when an ICE candidate is available
	Trickle *TrickleRequest `protobuf:"bytes,4,opt,name=trickle,proto3,oneof"`
}

type SignalResponse_Update struct {
	// sent when participants in the room has changed
	Update *ParticipantUpdate `protobuf:"bytes,5,opt,name=update,proto3,oneof"`
}

type SignalResponse_TrackPublished struct {
	// sent to the participant when their track has been published
	TrackPublished *TrackPublishedResponse `protobuf:"bytes,6,opt,name=track_published,json=trackPublished,proto3,oneof"`
}

type SignalResponse_Leave struct {
	// Immediately terminate session
	Leave *LeaveRequest `protobuf:"bytes,8,opt,name=leave,proto3,oneof"`
}

type SignalResponse_Mute struct {
	// server initiated mute
	Mute *MuteTrackRequest `protobuf:"bytes,9,opt,name=mute,proto3,oneof"`
}

type SignalResponse_SpeakersChanged struct {
	// indicates changes to speaker status, including when they've gone to not speaking
	SpeakersChanged *SpeakersChanged `protobuf:"bytes,10,opt,name=speakers_changed,json=speakersChanged,proto3,oneof"`
}

type SignalResponse_RoomUpdate struct {
	// sent when metadata of the room has changed
	RoomUpdate *RoomUpdate `protobuf:"bytes,11,opt,name=room_update,json=roomUpdate,proto3,oneof"`
}

type SignalResponse_ConnectionQuality struct {
	// when connection quality changed
	ConnectionQuality *ConnectionQualityUpdate `protobuf:"bytes,12,opt,name=connection_quality,json=connectionQuality,proto3,oneof"`
}

type SignalResponse_StreamStateUpdate struct {
	// when streamed tracks state changed, used to notify when any of the streams were paused due to
	// congestion
	StreamStateUpdate *StreamStateUpdate `protobuf:"bytes,13,opt,name=stream_state_update,json=streamStateUpdate,proto3,oneof"`
}

type SignalResponse_SubscribedQualityUpdate struct {
	// when max subscribe quality changed, used by dynamic broadcasting to disable unused layers
	SubscribedQualityUpdate *SubscribedQualityUpdate `protobuf:"bytes,14,opt,name=subscribed_quality_update,json=subscribedQualityUpdate,proto3,oneof"`
}

type SignalResponse_SubscriptionPermissionUpdate struct {
	// when subscription permission changed
	SubscriptionPermissionUpdate *SubscriptionPermissionUpdate `protobuf:"bytes,15,opt,name=subscription_permission_update,json=subscriptionPermissionUpdate,proto3,oneof"`
}

type SignalResponse_RefreshToken struct {
	// update the token the client was using, to prevent an active client from using an expired token
	RefreshToken string `protobuf:"bytes,16,opt,name=refresh_token,json=refreshToken,proto3,oneof"`
}

type SignalResponse_TrackUnpublished struct {
	// server initiated track unpublish
	TrackUnpublished *TrackUnpublishedResponse `protobuf:"bytes,17,opt,name=track_unpublished,json=trackUnpublished,proto3,oneof"`
}

type SignalResponse_Pong struct {
	// respond to ping
	Pong int64 `protobuf:"varint,18,opt,name=pong,proto3,oneof"` // deprecated by pong_resp (message Pong)
}

type SignalResponse_Reconnect struct {
	// sent when client reconnects
	Reconnect *ReconnectResponse `protobuf:"bytes,19,opt,name=reconnect,proto3,oneof"`
}

type SignalResponse_PongResp struct {
	// respond to Ping
	PongResp *Pong `protobuf:"bytes,20,opt,name=pong_resp,json=pongResp,proto3,oneof"`
}

type SignalResponse_SubscriptionResponse struct {
	// Subscription response, client should not expect any media from this subscription if it fails
	SubscriptionResponse *SubscriptionResponse `protobuf:"bytes,21,opt,name=subscription_response,json=subscriptionResponse,proto3,oneof"`
}

func (*SignalResponse_Join) isSignalResponse_Message() {}

func (*SignalResponse_Answer) isSignalResponse_Message() {}

func (*SignalResponse_Offer) isSignalResponse_Message() {}

func (*SignalResponse_Trickle) isSignalResponse_Message() {}

func (*SignalResponse_Update) isSignalResponse_Message() {}

func (*SignalResponse_TrackPublished) isSignalResponse_Message() {}

func (*SignalResponse_Leave) isSignalResponse_Message() {}

func (*SignalResponse_Mute) isSignalResponse_Message() {}

func (*SignalResponse_SpeakersChanged) isSignalResponse_Message() {}

func (*SignalResponse_RoomUpdate) isSignalResponse_Message() {}

func (*SignalResponse_ConnectionQuality) isSignalResponse_Message() {}

func (*SignalResponse_StreamStateUpdate) isSignalResponse_Message() {}

func (*SignalResponse_SubscribedQualityUpdate) isSignalResponse_Message() {}

func (*SignalResponse_SubscriptionPermissionUpdate) isSignalResponse_Message() {}

func (*SignalResponse_RefreshToken) isSignalResponse_Message() {}

func (*SignalResponse_TrackUnpublished) isSignalResponse_Message() {}

func (*SignalResponse_Pong) isSignalResponse_Message() {}

func (*SignalResponse_Reconnect) isSignalResponse_Message() {}

func (*SignalResponse_PongResp) isSignalResponse_Message() {}

func (*SignalResponse_SubscriptionResponse) isSignalResponse_Message() {}

type SimulcastCodec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	Cid   string `protobuf:"bytes,2,opt,name=cid,proto3" json:"cid,omitempty"`
}

func (x *SimulcastCodec) Reset() {
	*x = SimulcastCodec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulcastCodec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulcastCodec) ProtoMessage() {}

func (x *SimulcastCodec) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulcastCodec.ProtoReflect.Descriptor instead.
func (*SimulcastCodec) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{2}
}

func (x *SimulcastCodec) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *SimulcastCodec) GetCid() string {
	if x != nil {
		return x.Cid
	}
	return ""
}

type AddTrackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// client ID of track, to match it when RTC track is received
	Cid  string    `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	Name string    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type TrackType `protobuf:"varint,3,opt,name=type,proto3,enum=livekit.TrackType" json:"type,omitempty"`
	// to be deprecated in favor of layers
	Width  uint32 `protobuf:"varint,4,opt,name=width,proto3" json:"width,omitempty"`
	Height uint32 `protobuf:"varint,5,opt,name=height,proto3" json:"height,omitempty"`
	// true to add track and initialize to muted
	Muted bool `protobuf:"varint,6,opt,name=muted,proto3" json:"muted,omitempty"`
	// true if DTX (Discontinuous Transmission) is disabled for audio
	DisableDtx      bool              `protobuf:"varint,7,opt,name=disable_dtx,json=disableDtx,proto3" json:"disable_dtx,omitempty"`
	Source          TrackSource       `protobuf:"varint,8,opt,name=source,proto3,enum=livekit.TrackSource" json:"source,omitempty"`
	Layers          []*VideoLayer     `protobuf:"bytes,9,rep,name=layers,proto3" json:"layers,omitempty"`
	SimulcastCodecs []*SimulcastCodec `protobuf:"bytes,10,rep,name=simulcast_codecs,json=simulcastCodecs,proto3" json:"simulcast_codecs,omitempty"`
	// server ID of track, publish new codec to exist track
	Sid    string `protobuf:"bytes,11,opt,name=sid,proto3" json:"sid,omitempty"`
	Stereo bool   `protobuf:"varint,12,opt,name=stereo,proto3" json:"stereo,omitempty"`
	// true if RED (Redundant Encoding) is disabled for audio
	DisableRed bool            `protobuf:"varint,13,opt,name=disable_red,json=disableRed,proto3" json:"disable_red,omitempty"`
	Encryption Encryption_Type `protobuf:"varint,14,opt,name=encryption,proto3,enum=livekit.Encryption_Type" json:"encryption,omitempty"`
	// which stream the track belongs to, used to group tracks together.
	// if not specified, server will infer it from track source to bundle camera/microphone, screenshare/audio together
	Stream string `protobuf:"bytes,15,opt,name=stream,proto3" json:"stream,omitempty"`
}

func (x *AddTrackRequest) Reset() {
	*x = AddTrackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTrackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTrackRequest) ProtoMessage() {}

func (x *AddTrackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTrackRequest.ProtoReflect.Descriptor instead.
func (*AddTrackRequest) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{3}
}

func (x *AddTrackRequest) GetCid() string {
	if x != nil {
		return x.Cid
	}
	return ""
}

func (x *AddTrackRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AddTrackRequest) GetType() TrackType {
	if x != nil {
		return x.Type
	}
	return TrackType_AUDIO
}

func (x *AddTrackRequest) GetWidth() uint32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *AddTrackRequest) GetHeight() uint32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *AddTrackRequest) GetMuted() bool {
	if x != nil {
		return x.Muted
	}
	return false
}

func (x *AddTrackRequest) GetDisableDtx() bool {
	if x != nil {
		return x.DisableDtx
	}
	return false
}

func (x *AddTrackRequest) GetSource() TrackSource {
	if x != nil {
		return x.Source
	}
	return TrackSource_UNKNOWN
}

func (x *AddTrackRequest) GetLayers() []*VideoLayer {
	if x != nil {
		return x.Layers
	}
	return nil
}

func (x *AddTrackRequest) GetSimulcastCodecs() []*SimulcastCodec {
	if x != nil {
		return x.SimulcastCodecs
	}
	return nil
}

func (x *AddTrackRequest) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *AddTrackRequest) GetStereo() bool {
	if x != nil {
		return x.Stereo
	}
	return false
}

func (x *AddTrackRequest) GetDisableRed() bool {
	if x != nil {
		return x.DisableRed
	}
	return false
}

func (x *AddTrackRequest) GetEncryption() Encryption_Type {
	if x != nil {
		return x.Encryption
	}
	return Encryption_NONE
}

func (x *AddTrackRequest) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

type TrickleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CandidateInit string       `protobuf:"bytes,1,opt,name=candidateInit,proto3" json:"candidateInit,omitempty"`
	Target        SignalTarget `protobuf:"varint,2,opt,name=target,proto3,enum=livekit.SignalTarget" json:"target,omitempty"`
}

func (x *TrickleRequest) Reset() {
	*x = TrickleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrickleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrickleRequest) ProtoMessage() {}

func (x *TrickleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrickleRequest.ProtoReflect.Descriptor instead.
func (*TrickleRequest) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{4}
}

func (x *TrickleRequest) GetCandidateInit() string {
	if x != nil {
		return x.CandidateInit
	}
	return ""
}

func (x *TrickleRequest) GetTarget() SignalTarget {
	if x != nil {
		return x.Target
	}
	return SignalTarget_PUBLISHER
}

type MuteTrackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sid   string `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	Muted bool   `protobuf:"varint,2,opt,name=muted,proto3" json:"muted,omitempty"`
}

func (x *MuteTrackRequest) Reset() {
	*x = MuteTrackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuteTrackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuteTrackRequest) ProtoMessage() {}

func (x *MuteTrackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuteTrackRequest.ProtoReflect.Descriptor instead.
func (*MuteTrackRequest) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{5}
}

func (x *MuteTrackRequest) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *MuteTrackRequest) GetMuted() bool {
	if x != nil {
		return x.Muted
	}
	return false
}

type JoinResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room              *Room              `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
	Participant       *ParticipantInfo   `protobuf:"bytes,2,opt,name=participant,proto3" json:"participant,omitempty"`
	OtherParticipants []*ParticipantInfo `protobuf:"bytes,3,rep,name=other_participants,json=otherParticipants,proto3" json:"other_participants,omitempty"`
	// deprecated. use server_info.version instead.
	ServerVersion string       `protobuf:"bytes,4,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	IceServers    []*ICEServer `protobuf:"bytes,5,rep,name=ice_servers,json=iceServers,proto3" json:"ice_servers,omitempty"`
	// use subscriber as the primary PeerConnection
	SubscriberPrimary bool `protobuf:"varint,6,opt,name=subscriber_primary,json=subscriberPrimary,proto3" json:"subscriber_primary,omitempty"`
	// when the current server isn't available, return alternate url to retry connection
	// when this is set, the other fields will be largely empty
	AlternativeUrl      string               `protobuf:"bytes,7,opt,name=alternative_url,json=alternativeUrl,proto3" json:"alternative_url,omitempty"`
	ClientConfiguration *ClientConfiguration `protobuf:"bytes,8,opt,name=client_configuration,json=clientConfiguration,proto3" json:"client_configuration,omitempty"`
	// deprecated. use server_info.region instead.
	ServerRegion string      `protobuf:"bytes,9,opt,name=server_region,json=serverRegion,proto3" json:"server_region,omitempty"`
	PingTimeout  int32       `protobuf:"varint,10,opt,name=ping_timeout,json=pingTimeout,proto3" json:"ping_timeout,omitempty"`
	PingInterval int32       `protobuf:"varint,11,opt,name=ping_interval,json=pingInterval,proto3" json:"ping_interval,omitempty"`
	ServerInfo   *ServerInfo `protobuf:"bytes,12,opt,name=server_info,json=serverInfo,proto3" json:"server_info,omitempty"`
	// Server-Injected-Frame byte trailer, used to identify unencrypted frames when e2ee is enabled
	SifTrailer []byte `protobuf:"bytes,13,opt,name=sif_trailer,json=sifTrailer,proto3" json:"sif_trailer,omitempty"`
}

func (x *JoinResponse) Reset() {
	*x = JoinResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JoinResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinResponse) ProtoMessage() {}

func (x *JoinResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinResponse.ProtoReflect.Descriptor instead.
func (*JoinResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{6}
}

func (x *JoinResponse) GetRoom() *Room {
	if x != nil {
		return x.Room
	}
	return nil
}

func (x *JoinResponse) GetParticipant() *ParticipantInfo {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *JoinResponse) GetOtherParticipants() []*ParticipantInfo {
	if x != nil {
		return x.OtherParticipants
	}
	return nil
}

func (x *JoinResponse) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

func (x *JoinResponse) GetIceServers() []*ICEServer {
	if x != nil {
		return x.IceServers
	}
	return nil
}

func (x *JoinResponse) GetSubscriberPrimary() bool {
	if x != nil {
		return x.SubscriberPrimary
	}
	return false
}

func (x *JoinResponse) GetAlternativeUrl() string {
	if x != nil {
		return x.AlternativeUrl
	}
	return ""
}

func (x *JoinResponse) GetClientConfiguration() *ClientConfiguration {
	if x != nil {
		return x.ClientConfiguration
	}
	return nil
}

func (x *JoinResponse) GetServerRegion() string {
	if x != nil {
		return x.ServerRegion
	}
	return ""
}

func (x *JoinResponse) GetPingTimeout() int32 {
	if x != nil {
		return x.PingTimeout
	}
	return 0
}

func (x *JoinResponse) GetPingInterval() int32 {
	if x != nil {
		return x.PingInterval
	}
	return 0
}

func (x *JoinResponse) GetServerInfo() *ServerInfo {
	if x != nil {
		return x.ServerInfo
	}
	return nil
}

func (x *JoinResponse) GetSifTrailer() []byte {
	if x != nil {
		return x.SifTrailer
	}
	return nil
}

type ReconnectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IceServers          []*ICEServer         `protobuf:"bytes,1,rep,name=ice_servers,json=iceServers,proto3" json:"ice_servers,omitempty"`
	ClientConfiguration *ClientConfiguration `protobuf:"bytes,2,opt,name=client_configuration,json=clientConfiguration,proto3" json:"client_configuration,omitempty"`
}

func (x *ReconnectResponse) Reset() {
	*x = ReconnectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconnectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconnectResponse) ProtoMessage() {}

func (x *ReconnectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconnectResponse.ProtoReflect.Descriptor instead.
func (*ReconnectResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{7}
}

func (x *ReconnectResponse) GetIceServers() []*ICEServer {
	if x != nil {
		return x.IceServers
	}
	return nil
}

func (x *ReconnectResponse) GetClientConfiguration() *ClientConfiguration {
	if x != nil {
		return x.ClientConfiguration
	}
	return nil
}

type TrackPublishedResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cid   string     `protobuf:"bytes,1,opt,name=cid,proto3" json:"cid,omitempty"`
	Track *TrackInfo `protobuf:"bytes,2,opt,name=track,proto3" json:"track,omitempty"`
}

func (x *TrackPublishedResponse) Reset() {
	*x = TrackPublishedResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackPublishedResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackPublishedResponse) ProtoMessage() {}

func (x *TrackPublishedResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackPublishedResponse.ProtoReflect.Descriptor instead.
func (*TrackPublishedResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{8}
}

func (x *TrackPublishedResponse) GetCid() string {
	if x != nil {
		return x.Cid
	}
	return ""
}

func (x *TrackPublishedResponse) GetTrack() *TrackInfo {
	if x != nil {
		return x.Track
	}
	return nil
}

type TrackUnpublishedResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSid string `protobuf:"bytes,1,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
}

func (x *TrackUnpublishedResponse) Reset() {
	*x = TrackUnpublishedResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackUnpublishedResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackUnpublishedResponse) ProtoMessage() {}

func (x *TrackUnpublishedResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackUnpublishedResponse.ProtoReflect.Descriptor instead.
func (*TrackUnpublishedResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{9}
}

func (x *TrackUnpublishedResponse) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

type SessionDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"` // "answer" | "offer" | "pranswer" | "rollback"
	Sdp  string `protobuf:"bytes,2,opt,name=sdp,proto3" json:"sdp,omitempty"`
}

func (x *SessionDescription) Reset() {
	*x = SessionDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionDescription) ProtoMessage() {}

func (x *SessionDescription) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionDescription.ProtoReflect.Descriptor instead.
func (*SessionDescription) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{10}
}

func (x *SessionDescription) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SessionDescription) GetSdp() string {
	if x != nil {
		return x.Sdp
	}
	return ""
}

type ParticipantUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Participants []*ParticipantInfo `protobuf:"bytes,1,rep,name=participants,proto3" json:"participants,omitempty"`
}

func (x *ParticipantUpdate) Reset() {
	*x = ParticipantUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParticipantUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantUpdate) ProtoMessage() {}

func (x *ParticipantUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantUpdate.ProtoReflect.Descriptor instead.
func (*ParticipantUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{11}
}

func (x *ParticipantUpdate) GetParticipants() []*ParticipantInfo {
	if x != nil {
		return x.Participants
	}
	return nil
}

type UpdateSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSids         []string             `protobuf:"bytes,1,rep,name=track_sids,json=trackSids,proto3" json:"track_sids,omitempty"`
	Subscribe         bool                 `protobuf:"varint,2,opt,name=subscribe,proto3" json:"subscribe,omitempty"`
	ParticipantTracks []*ParticipantTracks `protobuf:"bytes,3,rep,name=participant_tracks,json=participantTracks,proto3" json:"participant_tracks,omitempty"`
}

func (x *UpdateSubscription) Reset() {
	*x = UpdateSubscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubscription) ProtoMessage() {}

func (x *UpdateSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubscription.ProtoReflect.Descriptor instead.
func (*UpdateSubscription) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateSubscription) GetTrackSids() []string {
	if x != nil {
		return x.TrackSids
	}
	return nil
}

func (x *UpdateSubscription) GetSubscribe() bool {
	if x != nil {
		return x.Subscribe
	}
	return false
}

func (x *UpdateSubscription) GetParticipantTracks() []*ParticipantTracks {
	if x != nil {
		return x.ParticipantTracks
	}
	return nil
}

type UpdateTrackSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSids []string `protobuf:"bytes,1,rep,name=track_sids,json=trackSids,proto3" json:"track_sids,omitempty"`
	// when true, the track is placed in a paused state, with no new data returned
	Disabled bool `protobuf:"varint,3,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// deprecated in favor of width & height
	Quality VideoQuality `protobuf:"varint,4,opt,name=quality,proto3,enum=livekit.VideoQuality" json:"quality,omitempty"`
	// for video, width to receive
	Width uint32 `protobuf:"varint,5,opt,name=width,proto3" json:"width,omitempty"`
	// for video, height to receive
	Height uint32 `protobuf:"varint,6,opt,name=height,proto3" json:"height,omitempty"`
	Fps    uint32 `protobuf:"varint,7,opt,name=fps,proto3" json:"fps,omitempty"`
	// subscription priority. 1 being the highest (0 is unset)
	// when unset, server sill assign priority based on the order of subscription
	// server will use priority in the following ways:
	//  1. when subscribed tracks exceed per-participant subscription limit, server will
	//     pause the lowest priority tracks
	//  2. when the network is congested, server will assign available bandwidth to
	//     higher priority tracks first. lowest priority tracks can be paused
	Priority uint32 `protobuf:"varint,8,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *UpdateTrackSettings) Reset() {
	*x = UpdateTrackSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTrackSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTrackSettings) ProtoMessage() {}

func (x *UpdateTrackSettings) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTrackSettings.ProtoReflect.Descriptor instead.
func (*UpdateTrackSettings) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateTrackSettings) GetTrackSids() []string {
	if x != nil {
		return x.TrackSids
	}
	return nil
}

func (x *UpdateTrackSettings) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *UpdateTrackSettings) GetQuality() VideoQuality {
	if x != nil {
		return x.Quality
	}
	return VideoQuality_LOW
}

func (x *UpdateTrackSettings) GetWidth() uint32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *UpdateTrackSettings) GetHeight() uint32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *UpdateTrackSettings) GetFps() uint32 {
	if x != nil {
		return x.Fps
	}
	return 0
}

func (x *UpdateTrackSettings) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

type LeaveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// sent when server initiates the disconnect due to server-restart
	// indicates clients should attempt full-reconnect sequence
	// NOTE: `can_reconnect` obsoleted by `action` starting in protocol version 13
	CanReconnect bool                `protobuf:"varint,1,opt,name=can_reconnect,json=canReconnect,proto3" json:"can_reconnect,omitempty"`
	Reason       DisconnectReason    `protobuf:"varint,2,opt,name=reason,proto3,enum=livekit.DisconnectReason" json:"reason,omitempty"`
	Action       LeaveRequest_Action `protobuf:"varint,3,opt,name=action,proto3,enum=livekit.LeaveRequest_Action" json:"action,omitempty"`
	Regions      *RegionSettings     `protobuf:"bytes,4,opt,name=regions,proto3" json:"regions,omitempty"`
}

func (x *LeaveRequest) Reset() {
	*x = LeaveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeaveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaveRequest) ProtoMessage() {}

func (x *LeaveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaveRequest.ProtoReflect.Descriptor instead.
func (*LeaveRequest) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{14}
}

func (x *LeaveRequest) GetCanReconnect() bool {
	if x != nil {
		return x.CanReconnect
	}
	return false
}

func (x *LeaveRequest) GetReason() DisconnectReason {
	if x != nil {
		return x.Reason
	}
	return DisconnectReason_UNKNOWN_REASON
}

func (x *LeaveRequest) GetAction() LeaveRequest_Action {
	if x != nil {
		return x.Action
	}
	return LeaveRequest_DISCONNECT
}

func (x *LeaveRequest) GetRegions() *RegionSettings {
	if x != nil {
		return x.Regions
	}
	return nil
}

// message to indicate published video track dimensions are changing
type UpdateVideoLayers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSid string        `protobuf:"bytes,1,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	Layers   []*VideoLayer `protobuf:"bytes,2,rep,name=layers,proto3" json:"layers,omitempty"`
}

func (x *UpdateVideoLayers) Reset() {
	*x = UpdateVideoLayers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVideoLayers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVideoLayers) ProtoMessage() {}

func (x *UpdateVideoLayers) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVideoLayers.ProtoReflect.Descriptor instead.
func (*UpdateVideoLayers) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateVideoLayers) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *UpdateVideoLayers) GetLayers() []*VideoLayer {
	if x != nil {
		return x.Layers
	}
	return nil
}

type UpdateParticipantMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metadata string `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Name     string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateParticipantMetadata) Reset() {
	*x = UpdateParticipantMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateParticipantMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateParticipantMetadata) ProtoMessage() {}

func (x *UpdateParticipantMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateParticipantMetadata.ProtoReflect.Descriptor instead.
func (*UpdateParticipantMetadata) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateParticipantMetadata) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

func (x *UpdateParticipantMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ICEServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urls       []string `protobuf:"bytes,1,rep,name=urls,proto3" json:"urls,omitempty"`
	Username   string   `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	Credential string   `protobuf:"bytes,3,opt,name=credential,proto3" json:"credential,omitempty"`
}

func (x *ICEServer) Reset() {
	*x = ICEServer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ICEServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ICEServer) ProtoMessage() {}

func (x *ICEServer) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ICEServer.ProtoReflect.Descriptor instead.
func (*ICEServer) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{17}
}

func (x *ICEServer) GetUrls() []string {
	if x != nil {
		return x.Urls
	}
	return nil
}

func (x *ICEServer) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ICEServer) GetCredential() string {
	if x != nil {
		return x.Credential
	}
	return ""
}

type SpeakersChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Speakers []*SpeakerInfo `protobuf:"bytes,1,rep,name=speakers,proto3" json:"speakers,omitempty"`
}

func (x *SpeakersChanged) Reset() {
	*x = SpeakersChanged{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeakersChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeakersChanged) ProtoMessage() {}

func (x *SpeakersChanged) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeakersChanged.ProtoReflect.Descriptor instead.
func (*SpeakersChanged) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{18}
}

func (x *SpeakersChanged) GetSpeakers() []*SpeakerInfo {
	if x != nil {
		return x.Speakers
	}
	return nil
}

type RoomUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Room *Room `protobuf:"bytes,1,opt,name=room,proto3" json:"room,omitempty"`
}

func (x *RoomUpdate) Reset() {
	*x = RoomUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoomUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoomUpdate) ProtoMessage() {}

func (x *RoomUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoomUpdate.ProtoReflect.Descriptor instead.
func (*RoomUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{19}
}

func (x *RoomUpdate) GetRoom() *Room {
	if x != nil {
		return x.Room
	}
	return nil
}

type ConnectionQualityInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParticipantSid string            `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	Quality        ConnectionQuality `protobuf:"varint,2,opt,name=quality,proto3,enum=livekit.ConnectionQuality" json:"quality,omitempty"`
	Score          float32           `protobuf:"fixed32,3,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *ConnectionQualityInfo) Reset() {
	*x = ConnectionQualityInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionQualityInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionQualityInfo) ProtoMessage() {}

func (x *ConnectionQualityInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionQualityInfo.ProtoReflect.Descriptor instead.
func (*ConnectionQualityInfo) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{20}
}

func (x *ConnectionQualityInfo) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *ConnectionQualityInfo) GetQuality() ConnectionQuality {
	if x != nil {
		return x.Quality
	}
	return ConnectionQuality_POOR
}

func (x *ConnectionQualityInfo) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

type ConnectionQualityUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Updates []*ConnectionQualityInfo `protobuf:"bytes,1,rep,name=updates,proto3" json:"updates,omitempty"`
}

func (x *ConnectionQualityUpdate) Reset() {
	*x = ConnectionQualityUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionQualityUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionQualityUpdate) ProtoMessage() {}

func (x *ConnectionQualityUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionQualityUpdate.ProtoReflect.Descriptor instead.
func (*ConnectionQualityUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{21}
}

func (x *ConnectionQualityUpdate) GetUpdates() []*ConnectionQualityInfo {
	if x != nil {
		return x.Updates
	}
	return nil
}

type StreamStateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParticipantSid string      `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	TrackSid       string      `protobuf:"bytes,2,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	State          StreamState `protobuf:"varint,3,opt,name=state,proto3,enum=livekit.StreamState" json:"state,omitempty"`
}

func (x *StreamStateInfo) Reset() {
	*x = StreamStateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamStateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamStateInfo) ProtoMessage() {}

func (x *StreamStateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamStateInfo.ProtoReflect.Descriptor instead.
func (*StreamStateInfo) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{22}
}

func (x *StreamStateInfo) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *StreamStateInfo) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *StreamStateInfo) GetState() StreamState {
	if x != nil {
		return x.State
	}
	return StreamState_ACTIVE
}

type StreamStateUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StreamStates []*StreamStateInfo `protobuf:"bytes,1,rep,name=stream_states,json=streamStates,proto3" json:"stream_states,omitempty"`
}

func (x *StreamStateUpdate) Reset() {
	*x = StreamStateUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamStateUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamStateUpdate) ProtoMessage() {}

func (x *StreamStateUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamStateUpdate.ProtoReflect.Descriptor instead.
func (*StreamStateUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{23}
}

func (x *StreamStateUpdate) GetStreamStates() []*StreamStateInfo {
	if x != nil {
		return x.StreamStates
	}
	return nil
}

type SubscribedQuality struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Quality VideoQuality `protobuf:"varint,1,opt,name=quality,proto3,enum=livekit.VideoQuality" json:"quality,omitempty"`
	Enabled bool         `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *SubscribedQuality) Reset() {
	*x = SubscribedQuality{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribedQuality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribedQuality) ProtoMessage() {}

func (x *SubscribedQuality) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribedQuality.ProtoReflect.Descriptor instead.
func (*SubscribedQuality) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{24}
}

func (x *SubscribedQuality) GetQuality() VideoQuality {
	if x != nil {
		return x.Quality
	}
	return VideoQuality_LOW
}

func (x *SubscribedQuality) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type SubscribedCodec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Codec     string               `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	Qualities []*SubscribedQuality `protobuf:"bytes,2,rep,name=qualities,proto3" json:"qualities,omitempty"`
}

func (x *SubscribedCodec) Reset() {
	*x = SubscribedCodec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribedCodec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribedCodec) ProtoMessage() {}

func (x *SubscribedCodec) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribedCodec.ProtoReflect.Descriptor instead.
func (*SubscribedCodec) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{25}
}

func (x *SubscribedCodec) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *SubscribedCodec) GetQualities() []*SubscribedQuality {
	if x != nil {
		return x.Qualities
	}
	return nil
}

type SubscribedQualityUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSid            string               `protobuf:"bytes,1,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	SubscribedQualities []*SubscribedQuality `protobuf:"bytes,2,rep,name=subscribed_qualities,json=subscribedQualities,proto3" json:"subscribed_qualities,omitempty"`
	SubscribedCodecs    []*SubscribedCodec   `protobuf:"bytes,3,rep,name=subscribed_codecs,json=subscribedCodecs,proto3" json:"subscribed_codecs,omitempty"`
}

func (x *SubscribedQualityUpdate) Reset() {
	*x = SubscribedQualityUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscribedQualityUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscribedQualityUpdate) ProtoMessage() {}

func (x *SubscribedQualityUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscribedQualityUpdate.ProtoReflect.Descriptor instead.
func (*SubscribedQualityUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{26}
}

func (x *SubscribedQualityUpdate) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *SubscribedQualityUpdate) GetSubscribedQualities() []*SubscribedQuality {
	if x != nil {
		return x.SubscribedQualities
	}
	return nil
}

func (x *SubscribedQualityUpdate) GetSubscribedCodecs() []*SubscribedCodec {
	if x != nil {
		return x.SubscribedCodecs
	}
	return nil
}

type TrackPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// permission could be granted either by participant sid or identity
	ParticipantSid      string   `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	AllTracks           bool     `protobuf:"varint,2,opt,name=all_tracks,json=allTracks,proto3" json:"all_tracks,omitempty"`
	TrackSids           []string `protobuf:"bytes,3,rep,name=track_sids,json=trackSids,proto3" json:"track_sids,omitempty"`
	ParticipantIdentity string   `protobuf:"bytes,4,opt,name=participant_identity,json=participantIdentity,proto3" json:"participant_identity,omitempty"`
}

func (x *TrackPermission) Reset() {
	*x = TrackPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackPermission) ProtoMessage() {}

func (x *TrackPermission) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackPermission.ProtoReflect.Descriptor instead.
func (*TrackPermission) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{27}
}

func (x *TrackPermission) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *TrackPermission) GetAllTracks() bool {
	if x != nil {
		return x.AllTracks
	}
	return false
}

func (x *TrackPermission) GetTrackSids() []string {
	if x != nil {
		return x.TrackSids
	}
	return nil
}

func (x *TrackPermission) GetParticipantIdentity() string {
	if x != nil {
		return x.ParticipantIdentity
	}
	return ""
}

type SubscriptionPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AllParticipants  bool               `protobuf:"varint,1,opt,name=all_participants,json=allParticipants,proto3" json:"all_participants,omitempty"`
	TrackPermissions []*TrackPermission `protobuf:"bytes,2,rep,name=track_permissions,json=trackPermissions,proto3" json:"track_permissions,omitempty"`
}

func (x *SubscriptionPermission) Reset() {
	*x = SubscriptionPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionPermission) ProtoMessage() {}

func (x *SubscriptionPermission) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionPermission.ProtoReflect.Descriptor instead.
func (*SubscriptionPermission) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{28}
}

func (x *SubscriptionPermission) GetAllParticipants() bool {
	if x != nil {
		return x.AllParticipants
	}
	return false
}

func (x *SubscriptionPermission) GetTrackPermissions() []*TrackPermission {
	if x != nil {
		return x.TrackPermissions
	}
	return nil
}

type SubscriptionPermissionUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParticipantSid string `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	TrackSid       string `protobuf:"bytes,2,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	Allowed        bool   `protobuf:"varint,3,opt,name=allowed,proto3" json:"allowed,omitempty"`
}

func (x *SubscriptionPermissionUpdate) Reset() {
	*x = SubscriptionPermissionUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionPermissionUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionPermissionUpdate) ProtoMessage() {}

func (x *SubscriptionPermissionUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionPermissionUpdate.ProtoReflect.Descriptor instead.
func (*SubscriptionPermissionUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{29}
}

func (x *SubscriptionPermissionUpdate) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *SubscriptionPermissionUpdate) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *SubscriptionPermissionUpdate) GetAllowed() bool {
	if x != nil {
		return x.Allowed
	}
	return false
}

type SyncState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// last subscribe answer before reconnecting
	Answer        *SessionDescription       `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	Subscription  *UpdateSubscription       `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	PublishTracks []*TrackPublishedResponse `protobuf:"bytes,3,rep,name=publish_tracks,json=publishTracks,proto3" json:"publish_tracks,omitempty"`
	DataChannels  []*DataChannelInfo        `protobuf:"bytes,4,rep,name=data_channels,json=dataChannels,proto3" json:"data_channels,omitempty"`
	// last received server side offer before reconnecting
	Offer             *SessionDescription `protobuf:"bytes,5,opt,name=offer,proto3" json:"offer,omitempty"`
	TrackSidsDisabled []string            `protobuf:"bytes,6,rep,name=track_sids_disabled,json=trackSidsDisabled,proto3" json:"track_sids_disabled,omitempty"`
}

func (x *SyncState) Reset() {
	*x = SyncState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncState) ProtoMessage() {}

func (x *SyncState) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncState.ProtoReflect.Descriptor instead.
func (*SyncState) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{30}
}

func (x *SyncState) GetAnswer() *SessionDescription {
	if x != nil {
		return x.Answer
	}
	return nil
}

func (x *SyncState) GetSubscription() *UpdateSubscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *SyncState) GetPublishTracks() []*TrackPublishedResponse {
	if x != nil {
		return x.PublishTracks
	}
	return nil
}

func (x *SyncState) GetDataChannels() []*DataChannelInfo {
	if x != nil {
		return x.DataChannels
	}
	return nil
}

func (x *SyncState) GetOffer() *SessionDescription {
	if x != nil {
		return x.Offer
	}
	return nil
}

func (x *SyncState) GetTrackSidsDisabled() []string {
	if x != nil {
		return x.TrackSidsDisabled
	}
	return nil
}

type DataChannelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Label  string       `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	Id     uint32       `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Target SignalTarget `protobuf:"varint,3,opt,name=target,proto3,enum=livekit.SignalTarget" json:"target,omitempty"`
}

func (x *DataChannelInfo) Reset() {
	*x = DataChannelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataChannelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataChannelInfo) ProtoMessage() {}

func (x *DataChannelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataChannelInfo.ProtoReflect.Descriptor instead.
func (*DataChannelInfo) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{31}
}

func (x *DataChannelInfo) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *DataChannelInfo) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *DataChannelInfo) GetTarget() SignalTarget {
	if x != nil {
		return x.Target
	}
	return SignalTarget_PUBLISHER
}

type SimulateScenario struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Scenario:
	//
	//	*SimulateScenario_SpeakerUpdate
	//	*SimulateScenario_NodeFailure
	//	*SimulateScenario_Migration
	//	*SimulateScenario_ServerLeave
	//	*SimulateScenario_SwitchCandidateProtocol
	//	*SimulateScenario_SubscriberBandwidth
	//	*SimulateScenario_DisconnectSignalOnResume
	//	*SimulateScenario_DisconnectSignalOnResumeNoMessages
	Scenario isSimulateScenario_Scenario `protobuf_oneof:"scenario"`
}

func (x *SimulateScenario) Reset() {
	*x = SimulateScenario{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateScenario) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateScenario) ProtoMessage() {}

func (x *SimulateScenario) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateScenario.ProtoReflect.Descriptor instead.
func (*SimulateScenario) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{32}
}

func (m *SimulateScenario) GetScenario() isSimulateScenario_Scenario {
	if m != nil {
		return m.Scenario
	}
	return nil
}

func (x *SimulateScenario) GetSpeakerUpdate() int32 {
	if x, ok := x.GetScenario().(*SimulateScenario_SpeakerUpdate); ok {
		return x.SpeakerUpdate
	}
	return 0
}

func (x *SimulateScenario) GetNodeFailure() bool {
	if x, ok := x.GetScenario().(*SimulateScenario_NodeFailure); ok {
		return x.NodeFailure
	}
	return false
}

func (x *SimulateScenario) GetMigration() bool {
	if x, ok := x.GetScenario().(*SimulateScenario_Migration); ok {
		return x.Migration
	}
	return false
}

func (x *SimulateScenario) GetServerLeave() bool {
	if x, ok := x.GetScenario().(*SimulateScenario_ServerLeave); ok {
		return x.ServerLeave
	}
	return false
}

func (x *SimulateScenario) GetSwitchCandidateProtocol() CandidateProtocol {
	if x, ok := x.GetScenario().(*SimulateScenario_SwitchCandidateProtocol); ok {
		return x.SwitchCandidateProtocol
	}
	return CandidateProtocol_UDP
}

func (x *SimulateScenario) GetSubscriberBandwidth() int64 {
	if x, ok := x.GetScenario().(*SimulateScenario_SubscriberBandwidth); ok {
		return x.SubscriberBandwidth
	}
	return 0
}

func (x *SimulateScenario) GetDisconnectSignalOnResume() bool {
	if x, ok := x.GetScenario().(*SimulateScenario_DisconnectSignalOnResume); ok {
		return x.DisconnectSignalOnResume
	}
	return false
}

func (x *SimulateScenario) GetDisconnectSignalOnResumeNoMessages() bool {
	if x, ok := x.GetScenario().(*SimulateScenario_DisconnectSignalOnResumeNoMessages); ok {
		return x.DisconnectSignalOnResumeNoMessages
	}
	return false
}

type isSimulateScenario_Scenario interface {
	isSimulateScenario_Scenario()
}

type SimulateScenario_SpeakerUpdate struct {
	// simulate N seconds of speaker activity
	SpeakerUpdate int32 `protobuf:"varint,1,opt,name=speaker_update,json=speakerUpdate,proto3,oneof"`
}

type SimulateScenario_NodeFailure struct {
	// simulate local node failure
	NodeFailure bool `protobuf:"varint,2,opt,name=node_failure,json=nodeFailure,proto3,oneof"`
}

type SimulateScenario_Migration struct {
	// simulate migration
	Migration bool `protobuf:"varint,3,opt,name=migration,proto3,oneof"`
}

type SimulateScenario_ServerLeave struct {
	// server to send leave
	ServerLeave bool `protobuf:"varint,4,opt,name=server_leave,json=serverLeave,proto3,oneof"`
}

type SimulateScenario_SwitchCandidateProtocol struct {
	// switch candidate protocol to tcp
	SwitchCandidateProtocol CandidateProtocol `protobuf:"varint,5,opt,name=switch_candidate_protocol,json=switchCandidateProtocol,proto3,enum=livekit.CandidateProtocol,oneof"`
}

type SimulateScenario_SubscriberBandwidth struct {
	// maximum bandwidth for subscribers, in bps
	// when zero, clears artificial bandwidth limit
	SubscriberBandwidth int64 `protobuf:"varint,6,opt,name=subscriber_bandwidth,json=subscriberBandwidth,proto3,oneof"`
}

type SimulateScenario_DisconnectSignalOnResume struct {
	// disconnect signal on resume
	DisconnectSignalOnResume bool `protobuf:"varint,7,opt,name=disconnect_signal_on_resume,json=disconnectSignalOnResume,proto3,oneof"`
}

type SimulateScenario_DisconnectSignalOnResumeNoMessages struct {
	// disconnect signal on resume before sending any messages from server
	DisconnectSignalOnResumeNoMessages bool `protobuf:"varint,8,opt,name=disconnect_signal_on_resume_no_messages,json=disconnectSignalOnResumeNoMessages,proto3,oneof"`
}

func (*SimulateScenario_SpeakerUpdate) isSimulateScenario_Scenario() {}

func (*SimulateScenario_NodeFailure) isSimulateScenario_Scenario() {}

func (*SimulateScenario_Migration) isSimulateScenario_Scenario() {}

func (*SimulateScenario_ServerLeave) isSimulateScenario_Scenario() {}

func (*SimulateScenario_SwitchCandidateProtocol) isSimulateScenario_Scenario() {}

func (*SimulateScenario_SubscriberBandwidth) isSimulateScenario_Scenario() {}

func (*SimulateScenario_DisconnectSignalOnResume) isSimulateScenario_Scenario() {}

func (*SimulateScenario_DisconnectSignalOnResumeNoMessages) isSimulateScenario_Scenario() {}

type Ping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// rtt in milliseconds calculated by client
	Rtt int64 `protobuf:"varint,2,opt,name=rtt,proto3" json:"rtt,omitempty"`
}

func (x *Ping) Reset() {
	*x = Ping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Ping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ping) ProtoMessage() {}

func (x *Ping) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ping.ProtoReflect.Descriptor instead.
func (*Ping) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{33}
}

func (x *Ping) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Ping) GetRtt() int64 {
	if x != nil {
		return x.Rtt
	}
	return 0
}

type Pong struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// timestamp field of last received ping request
	LastPingTimestamp int64 `protobuf:"varint,1,opt,name=last_ping_timestamp,json=lastPingTimestamp,proto3" json:"last_ping_timestamp,omitempty"`
	Timestamp         int64 `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *Pong) Reset() {
	*x = Pong{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pong) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pong) ProtoMessage() {}

func (x *Pong) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pong.ProtoReflect.Descriptor instead.
func (*Pong) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{34}
}

func (x *Pong) GetLastPingTimestamp() int64 {
	if x != nil {
		return x.LastPingTimestamp
	}
	return 0
}

func (x *Pong) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type RegionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Regions []*RegionInfo `protobuf:"bytes,1,rep,name=regions,proto3" json:"regions,omitempty"`
}

func (x *RegionSettings) Reset() {
	*x = RegionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegionSettings) ProtoMessage() {}

func (x *RegionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegionSettings.ProtoReflect.Descriptor instead.
func (*RegionSettings) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{35}
}

func (x *RegionSettings) GetRegions() []*RegionInfo {
	if x != nil {
		return x.Regions
	}
	return nil
}

type RegionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Region   string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	Url      string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	Distance int64  `protobuf:"varint,3,opt,name=distance,proto3" json:"distance,omitempty"`
}

func (x *RegionInfo) Reset() {
	*x = RegionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegionInfo) ProtoMessage() {}

func (x *RegionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegionInfo.ProtoReflect.Descriptor instead.
func (*RegionInfo) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{36}
}

func (x *RegionInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *RegionInfo) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *RegionInfo) GetDistance() int64 {
	if x != nil {
		return x.Distance
	}
	return 0
}

type SubscriptionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackSid string            `protobuf:"bytes,1,opt,name=track_sid,json=trackSid,proto3" json:"track_sid,omitempty"`
	Err      SubscriptionError `protobuf:"varint,2,opt,name=err,proto3,enum=livekit.SubscriptionError" json:"err,omitempty"`
}

func (x *SubscriptionResponse) Reset() {
	*x = SubscriptionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_rtc_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionResponse) ProtoMessage() {}

func (x *SubscriptionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_rtc_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionResponse.ProtoReflect.Descriptor instead.
func (*SubscriptionResponse) Descriptor() ([]byte, []int) {
	return file_livekit_rtc_proto_rawDescGZIP(), []int{37}
}

func (x *SubscriptionResponse) GetTrackSid() string {
	if x != nil {
		return x.TrackSid
	}
	return ""
}

func (x *SubscriptionResponse) GetErr() SubscriptionError {
	if x != nil {
		return x.Err
	}
	return SubscriptionError_SE_UNKNOWN
}

var File_livekit_rtc_proto protoreflect.FileDescriptor

var file_livekit_rtc_proto_rawDesc = []byte{
	0x0a, 0x11, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x72, 0x74, 0x63, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x1a, 0x14, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xfa, 0x06, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x35, 0x0a, 0x06, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x12, 0x33, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x69, 0x63,
	0x6b, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x74, 0x72,
	0x69, 0x63, 0x6b, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x5f, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x64, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x2f,
	0x0a, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x12,
	0x41, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2d, 0x0a, 0x05, 0x6c, 0x65, 0x61, 0x76, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x05, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x12, 0x5a, 0x0a, 0x17, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x0a, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x09, 0x73, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53,
	0x63, 0x65, 0x6e, 0x61, 0x72, 0x69, 0x6f, 0x48, 0x00, 0x52, 0x08, 0x73, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x04, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x4d, 0x0a, 0x0f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2a, 0x0a, 0x08, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x71, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x07, 0x70, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x89, 0x0a, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x6a, 0x6f, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6a, 0x6f, 0x69, 0x6e, 0x12,
	0x35, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x07, 0x74,
	0x72, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x74, 0x72, 0x69, 0x63, 0x6b, 0x6c, 0x65,
	0x12, 0x34, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x00, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x12, 0x2d, 0x0a, 0x05, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x65, 0x61, 0x76,
	0x65, 0x12, 0x2f, 0x0a, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x75,
	0x74, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65,
	0x72, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x0b, 0x72, 0x6f, 0x6f,
	0x6d, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x51, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x4c, 0x0a, 0x13, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52,
	0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x5e, 0x0a, 0x19, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64,
	0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x17, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x6d, 0x0a, 0x1e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x1c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x25, 0x0a, 0x0d, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x50, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x5f, 0x75, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x55, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x10, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x55,
	0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x6f,
	0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x04, 0x70, 0x6f, 0x6e, 0x67,
	0x12, 0x3a, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x2c, 0x0a, 0x09,
	0x70, 0x6f, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x6f, 0x6e, 0x67, 0x48, 0x00,
	0x52, 0x08, 0x70, 0x6f, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x54, 0x0a, 0x15, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x14, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x38, 0x0a, 0x0e, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x63, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x63, 0x69, 0x64, 0x22, 0x80, 0x04, 0x0a, 0x0f, 0x41, 0x64, 0x64, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a,
	0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x74, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x74, 0x78, 0x12, 0x2c, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2b, 0x0a, 0x06, 0x6c, 0x61,
	0x79, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x52,
	0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x12, 0x42, 0x0a, 0x10, 0x73, 0x69, 0x6d, 0x75, 0x6c,
	0x63, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x63, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x52, 0x0f, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x63, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73,
	0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x74, 0x65, 0x72, 0x65, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73,
	0x74, 0x65, 0x72, 0x65, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x72, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x65, 0x0a, 0x0e, 0x54, 0x72, 0x69, 0x63,
	0x6b, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x63, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x69, 0x74,
	0x12, 0x2d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22,
	0x3a, 0x0a, 0x10, 0x4d, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x22, 0xff, 0x04, 0x0a, 0x0c,
	0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x04,
	0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12,
	0x3a, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x12, 0x6f,
	0x74, 0x68, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x11, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x0b, 0x69,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x43, 0x45, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x52, 0x0a, 0x69, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x12, 0x2d, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x12,
	0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x4f, 0x0a, 0x14, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x21,
	0x0a, 0x0c, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x70, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x70, 0x69, 0x6e, 0x67, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x34, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x69, 0x66, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6c, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x73, 0x69, 0x66, 0x54, 0x72, 0x61, 0x69, 0x6c, 0x65, 0x72, 0x22, 0x99, 0x01,
	0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x0b, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x49, 0x43, 0x45, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x0a, 0x69, 0x63,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x14, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0x0a, 0x16, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x63, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x22,
	0x37, 0x0a, 0x18, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x55, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x22, 0x3a, 0x0a, 0x12, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x64, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x64, 0x70, 0x22, 0x51, 0x0a, 0x11, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x0c, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x49, 0x0a, 0x12, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x73, 0x52, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x22, 0xdd, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2f, 0x0a, 0x07, 0x71, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x66, 0x70, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x66, 0x70, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x84, 0x02, 0x0a, 0x0c, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61, 0x6e, 0x5f, 0x72,
	0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x63, 0x61, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x31, 0x0a, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x34, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x33, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x02, 0x22, 0x5d, 0x0a,
	0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65,
	0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x12,
	0x2b, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x22, 0x4b, 0x0a, 0x19,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a, 0x09, 0x49, 0x43, 0x45,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x22, 0x43, 0x0a, 0x0f, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65,
	0x72, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x08, 0x73, 0x70, 0x65,
	0x61, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x08, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x22, 0x2f, 0x0a, 0x0a, 0x52,
	0x6f, 0x6f, 0x6d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x04, 0x72, 0x6f, 0x6f,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x8c, 0x01, 0x0a,
	0x15, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x12,
	0x34, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x07, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0x53, 0x0a, 0x17, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x38, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x22, 0x83, 0x01, 0x0a, 0x0f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x52, 0x0a, 0x11, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0d, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x5e, 0x0a, 0x11, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x2f, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x61, 0x0a, 0x0f, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x12, 0x38, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xcc, 0x01,
	0x0a, 0x17, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x12, 0x4d, 0x0a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x13, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x62, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x52, 0x10, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x22, 0xab, 0x01, 0x0a,
	0x0f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f,
	0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x6c, 0x6c,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61,
	0x6c, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x5f, 0x73, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x61, 0x6c, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x12, 0x45, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7e, 0x0a, 0x1c, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x12, 0x18, 0x0a,
	0x07, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x22, 0xeb, 0x02, 0x0a, 0x09, 0x53, 0x79, 0x6e, 0x63,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x0c, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x12, 0x31, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05,
	0x6f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73,
	0x69, 0x64, 0x73, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x11, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64, 0x73, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x66, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2d,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xd8, 0x03,
	0x0a, 0x10, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x63, 0x65, 0x6e, 0x61, 0x72,
	0x69, 0x6f, 0x12, 0x27, 0x0a, 0x0e, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x70,
	0x65, 0x61, 0x6b, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x12, 0x1e, 0x0a, 0x09, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6c, 0x65, 0x61, 0x76, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x4c, 0x65, 0x61, 0x76, 0x65, 0x12, 0x58, 0x0a, 0x19, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5f,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x17, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x43, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12,
	0x33, 0x0a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x13, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x42, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x12, 0x3f, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x18, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x4f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6d, 0x65, 0x5f, 0x6e, 0x6f, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x22, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x4f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6d, 0x65, 0x4e, 0x6f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08,
	0x73, 0x63, 0x65, 0x6e, 0x61, 0x72, 0x69, 0x6f, 0x22, 0x36, 0x0a, 0x04, 0x50, 0x69, 0x6e, 0x67,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x10,
	0x0a, 0x03, 0x72, 0x74, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x72, 0x74, 0x74,
	0x22, 0x54, 0x0a, 0x04, 0x50, 0x6f, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x69, 0x6e, 0x67, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x3f, 0x0a, 0x0e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x07, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x52, 0x0a, 0x0a, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x61, 0x0a, 0x14, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x69, 0x64,
	0x12, 0x2c, 0x0a, 0x03, 0x65, 0x72, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x03, 0x65, 0x72, 0x72, 0x2a, 0x2d,
	0x0a, 0x0c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x0d,
	0x0a, 0x09, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x52, 0x10, 0x01, 0x2a, 0x25, 0x0a,
	0x0b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53,
	0x45, 0x44, 0x10, 0x01, 0x2a, 0x2e, 0x0a, 0x11, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x44, 0x50,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x54,
	0x4c, 0x53, 0x10, 0x02, 0x42, 0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69,
	0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69,
	0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_rtc_proto_rawDescOnce sync.Once
	file_livekit_rtc_proto_rawDescData = file_livekit_rtc_proto_rawDesc
)

func file_livekit_rtc_proto_rawDescGZIP() []byte {
	file_livekit_rtc_proto_rawDescOnce.Do(func() {
		file_livekit_rtc_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_rtc_proto_rawDescData)
	})
	return file_livekit_rtc_proto_rawDescData
}

var file_livekit_rtc_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_livekit_rtc_proto_msgTypes = make([]protoimpl.MessageInfo, 38)
var file_livekit_rtc_proto_goTypes = []interface{}{
	(SignalTarget)(0),                    // 0: livekit.SignalTarget
	(StreamState)(0),                     // 1: livekit.StreamState
	(CandidateProtocol)(0),               // 2: livekit.CandidateProtocol
	(LeaveRequest_Action)(0),             // 3: livekit.LeaveRequest.Action
	(*SignalRequest)(nil),                // 4: livekit.SignalRequest
	(*SignalResponse)(nil),               // 5: livekit.SignalResponse
	(*SimulcastCodec)(nil),               // 6: livekit.SimulcastCodec
	(*AddTrackRequest)(nil),              // 7: livekit.AddTrackRequest
	(*TrickleRequest)(nil),               // 8: livekit.TrickleRequest
	(*MuteTrackRequest)(nil),             // 9: livekit.MuteTrackRequest
	(*JoinResponse)(nil),                 // 10: livekit.JoinResponse
	(*ReconnectResponse)(nil),            // 11: livekit.ReconnectResponse
	(*TrackPublishedResponse)(nil),       // 12: livekit.TrackPublishedResponse
	(*TrackUnpublishedResponse)(nil),     // 13: livekit.TrackUnpublishedResponse
	(*SessionDescription)(nil),           // 14: livekit.SessionDescription
	(*ParticipantUpdate)(nil),            // 15: livekit.ParticipantUpdate
	(*UpdateSubscription)(nil),           // 16: livekit.UpdateSubscription
	(*UpdateTrackSettings)(nil),          // 17: livekit.UpdateTrackSettings
	(*LeaveRequest)(nil),                 // 18: livekit.LeaveRequest
	(*UpdateVideoLayers)(nil),            // 19: livekit.UpdateVideoLayers
	(*UpdateParticipantMetadata)(nil),    // 20: livekit.UpdateParticipantMetadata
	(*ICEServer)(nil),                    // 21: livekit.ICEServer
	(*SpeakersChanged)(nil),              // 22: livekit.SpeakersChanged
	(*RoomUpdate)(nil),                   // 23: livekit.RoomUpdate
	(*ConnectionQualityInfo)(nil),        // 24: livekit.ConnectionQualityInfo
	(*ConnectionQualityUpdate)(nil),      // 25: livekit.ConnectionQualityUpdate
	(*StreamStateInfo)(nil),              // 26: livekit.StreamStateInfo
	(*StreamStateUpdate)(nil),            // 27: livekit.StreamStateUpdate
	(*SubscribedQuality)(nil),            // 28: livekit.SubscribedQuality
	(*SubscribedCodec)(nil),              // 29: livekit.SubscribedCodec
	(*SubscribedQualityUpdate)(nil),      // 30: livekit.SubscribedQualityUpdate
	(*TrackPermission)(nil),              // 31: livekit.TrackPermission
	(*SubscriptionPermission)(nil),       // 32: livekit.SubscriptionPermission
	(*SubscriptionPermissionUpdate)(nil), // 33: livekit.SubscriptionPermissionUpdate
	(*SyncState)(nil),                    // 34: livekit.SyncState
	(*DataChannelInfo)(nil),              // 35: livekit.DataChannelInfo
	(*SimulateScenario)(nil),             // 36: livekit.SimulateScenario
	(*Ping)(nil),                         // 37: livekit.Ping
	(*Pong)(nil),                         // 38: livekit.Pong
	(*RegionSettings)(nil),               // 39: livekit.RegionSettings
	(*RegionInfo)(nil),                   // 40: livekit.RegionInfo
	(*SubscriptionResponse)(nil),         // 41: livekit.SubscriptionResponse
	(TrackType)(0),                       // 42: livekit.TrackType
	(TrackSource)(0),                     // 43: livekit.TrackSource
	(*VideoLayer)(nil),                   // 44: livekit.VideoLayer
	(Encryption_Type)(0),                 // 45: livekit.Encryption.Type
	(*Room)(nil),                         // 46: livekit.Room
	(*ParticipantInfo)(nil),              // 47: livekit.ParticipantInfo
	(*ClientConfiguration)(nil),          // 48: livekit.ClientConfiguration
	(*ServerInfo)(nil),                   // 49: livekit.ServerInfo
	(*TrackInfo)(nil),                    // 50: livekit.TrackInfo
	(*ParticipantTracks)(nil),            // 51: livekit.ParticipantTracks
	(VideoQuality)(0),                    // 52: livekit.VideoQuality
	(DisconnectReason)(0),                // 53: livekit.DisconnectReason
	(*SpeakerInfo)(nil),                  // 54: livekit.SpeakerInfo
	(ConnectionQuality)(0),               // 55: livekit.ConnectionQuality
	(SubscriptionError)(0),               // 56: livekit.SubscriptionError
}
var file_livekit_rtc_proto_depIdxs = []int32{
	14, // 0: livekit.SignalRequest.offer:type_name -> livekit.SessionDescription
	14, // 1: livekit.SignalRequest.answer:type_name -> livekit.SessionDescription
	8,  // 2: livekit.SignalRequest.trickle:type_name -> livekit.TrickleRequest
	7,  // 3: livekit.SignalRequest.add_track:type_name -> livekit.AddTrackRequest
	9,  // 4: livekit.SignalRequest.mute:type_name -> livekit.MuteTrackRequest
	16, // 5: livekit.SignalRequest.subscription:type_name -> livekit.UpdateSubscription
	17, // 6: livekit.SignalRequest.track_setting:type_name -> livekit.UpdateTrackSettings
	18, // 7: livekit.SignalRequest.leave:type_name -> livekit.LeaveRequest
	19, // 8: livekit.SignalRequest.update_layers:type_name -> livekit.UpdateVideoLayers
	32, // 9: livekit.SignalRequest.subscription_permission:type_name -> livekit.SubscriptionPermission
	34, // 10: livekit.SignalRequest.sync_state:type_name -> livekit.SyncState
	36, // 11: livekit.SignalRequest.simulate:type_name -> livekit.SimulateScenario
	20, // 12: livekit.SignalRequest.update_metadata:type_name -> livekit.UpdateParticipantMetadata
	37, // 13: livekit.SignalRequest.ping_req:type_name -> livekit.Ping
	10, // 14: livekit.SignalResponse.join:type_name -> livekit.JoinResponse
	14, // 15: livekit.SignalResponse.answer:type_name -> livekit.SessionDescription
	14, // 16: livekit.SignalResponse.offer:type_name -> livekit.SessionDescription
	8,  // 17: livekit.SignalResponse.trickle:type_name -> livekit.TrickleRequest
	15, // 18: livekit.SignalResponse.update:type_name -> livekit.ParticipantUpdate
	12, // 19: livekit.SignalResponse.track_published:type_name -> livekit.TrackPublishedResponse
	18, // 20: livekit.SignalResponse.leave:type_name -> livekit.LeaveRequest
	9,  // 21: livekit.SignalResponse.mute:type_name -> livekit.MuteTrackRequest
	22, // 22: livekit.SignalResponse.speakers_changed:type_name -> livekit.SpeakersChanged
	23, // 23: livekit.SignalResponse.room_update:type_name -> livekit.RoomUpdate
	25, // 24: livekit.SignalResponse.connection_quality:type_name -> livekit.ConnectionQualityUpdate
	27, // 25: livekit.SignalResponse.stream_state_update:type_name -> livekit.StreamStateUpdate
	30, // 26: livekit.SignalResponse.subscribed_quality_update:type_name -> livekit.SubscribedQualityUpdate
	33, // 27: livekit.SignalResponse.subscription_permission_update:type_name -> livekit.SubscriptionPermissionUpdate
	13, // 28: livekit.SignalResponse.track_unpublished:type_name -> livekit.TrackUnpublishedResponse
	11, // 29: livekit.SignalResponse.reconnect:type_name -> livekit.ReconnectResponse
	38, // 30: livekit.SignalResponse.pong_resp:type_name -> livekit.Pong
	41, // 31: livekit.SignalResponse.subscription_response:type_name -> livekit.SubscriptionResponse
	42, // 32: livekit.AddTrackRequest.type:type_name -> livekit.TrackType
	43, // 33: livekit.AddTrackRequest.source:type_name -> livekit.TrackSource
	44, // 34: livekit.AddTrackRequest.layers:type_name -> livekit.VideoLayer
	6,  // 35: livekit.AddTrackRequest.simulcast_codecs:type_name -> livekit.SimulcastCodec
	45, // 36: livekit.AddTrackRequest.encryption:type_name -> livekit.Encryption.Type
	0,  // 37: livekit.TrickleRequest.target:type_name -> livekit.SignalTarget
	46, // 38: livekit.JoinResponse.room:type_name -> livekit.Room
	47, // 39: livekit.JoinResponse.participant:type_name -> livekit.ParticipantInfo
	47, // 40: livekit.JoinResponse.other_participants:type_name -> livekit.ParticipantInfo
	21, // 41: livekit.JoinResponse.ice_servers:type_name -> livekit.ICEServer
	48, // 42: livekit.JoinResponse.client_configuration:type_name -> livekit.ClientConfiguration
	49, // 43: livekit.JoinResponse.server_info:type_name -> livekit.ServerInfo
	21, // 44: livekit.ReconnectResponse.ice_servers:type_name -> livekit.ICEServer
	48, // 45: livekit.ReconnectResponse.client_configuration:type_name -> livekit.ClientConfiguration
	50, // 46: livekit.TrackPublishedResponse.track:type_name -> livekit.TrackInfo
	47, // 47: livekit.ParticipantUpdate.participants:type_name -> livekit.ParticipantInfo
	51, // 48: livekit.UpdateSubscription.participant_tracks:type_name -> livekit.ParticipantTracks
	52, // 49: livekit.UpdateTrackSettings.quality:type_name -> livekit.VideoQuality
	53, // 50: livekit.LeaveRequest.reason:type_name -> livekit.DisconnectReason
	3,  // 51: livekit.LeaveRequest.action:type_name -> livekit.LeaveRequest.Action
	39, // 52: livekit.LeaveRequest.regions:type_name -> livekit.RegionSettings
	44, // 53: livekit.UpdateVideoLayers.layers:type_name -> livekit.VideoLayer
	54, // 54: livekit.SpeakersChanged.speakers:type_name -> livekit.SpeakerInfo
	46, // 55: livekit.RoomUpdate.room:type_name -> livekit.Room
	55, // 56: livekit.ConnectionQualityInfo.quality:type_name -> livekit.ConnectionQuality
	24, // 57: livekit.ConnectionQualityUpdate.updates:type_name -> livekit.ConnectionQualityInfo
	1,  // 58: livekit.StreamStateInfo.state:type_name -> livekit.StreamState
	26, // 59: livekit.StreamStateUpdate.stream_states:type_name -> livekit.StreamStateInfo
	52, // 60: livekit.SubscribedQuality.quality:type_name -> livekit.VideoQuality
	28, // 61: livekit.SubscribedCodec.qualities:type_name -> livekit.SubscribedQuality
	28, // 62: livekit.SubscribedQualityUpdate.subscribed_qualities:type_name -> livekit.SubscribedQuality
	29, // 63: livekit.SubscribedQualityUpdate.subscribed_codecs:type_name -> livekit.SubscribedCodec
	31, // 64: livekit.SubscriptionPermission.track_permissions:type_name -> livekit.TrackPermission
	14, // 65: livekit.SyncState.answer:type_name -> livekit.SessionDescription
	16, // 66: livekit.SyncState.subscription:type_name -> livekit.UpdateSubscription
	12, // 67: livekit.SyncState.publish_tracks:type_name -> livekit.TrackPublishedResponse
	35, // 68: livekit.SyncState.data_channels:type_name -> livekit.DataChannelInfo
	14, // 69: livekit.SyncState.offer:type_name -> livekit.SessionDescription
	0,  // 70: livekit.DataChannelInfo.target:type_name -> livekit.SignalTarget
	2,  // 71: livekit.SimulateScenario.switch_candidate_protocol:type_name -> livekit.CandidateProtocol
	40, // 72: livekit.RegionSettings.regions:type_name -> livekit.RegionInfo
	56, // 73: livekit.SubscriptionResponse.err:type_name -> livekit.SubscriptionError
	74, // [74:74] is the sub-list for method output_type
	74, // [74:74] is the sub-list for method input_type
	74, // [74:74] is the sub-list for extension type_name
	74, // [74:74] is the sub-list for extension extendee
	0,  // [0:74] is the sub-list for field type_name
}

func init() { file_livekit_rtc_proto_init() }
func file_livekit_rtc_proto_init() {
	if File_livekit_rtc_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_rtc_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignalResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulcastCodec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTrackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrickleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuteTrackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JoinResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReconnectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackPublishedResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackUnpublishedResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParticipantUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTrackSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeaveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVideoLayers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateParticipantMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ICEServer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeakersChanged); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoomUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionQualityInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionQualityUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamStateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamStateUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribedQuality); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribedCodec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscribedQualityUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionPermissionUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataChannelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulateScenario); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Ping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pong); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_rtc_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_rtc_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*SignalRequest_Offer)(nil),
		(*SignalRequest_Answer)(nil),
		(*SignalRequest_Trickle)(nil),
		(*SignalRequest_AddTrack)(nil),
		(*SignalRequest_Mute)(nil),
		(*SignalRequest_Subscription)(nil),
		(*SignalRequest_TrackSetting)(nil),
		(*SignalRequest_Leave)(nil),
		(*SignalRequest_UpdateLayers)(nil),
		(*SignalRequest_SubscriptionPermission)(nil),
		(*SignalRequest_SyncState)(nil),
		(*SignalRequest_Simulate)(nil),
		(*SignalRequest_Ping)(nil),
		(*SignalRequest_UpdateMetadata)(nil),
		(*SignalRequest_PingReq)(nil),
	}
	file_livekit_rtc_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*SignalResponse_Join)(nil),
		(*SignalResponse_Answer)(nil),
		(*SignalResponse_Offer)(nil),
		(*SignalResponse_Trickle)(nil),
		(*SignalResponse_Update)(nil),
		(*SignalResponse_TrackPublished)(nil),
		(*SignalResponse_Leave)(nil),
		(*SignalResponse_Mute)(nil),
		(*SignalResponse_SpeakersChanged)(nil),
		(*SignalResponse_RoomUpdate)(nil),
		(*SignalResponse_ConnectionQuality)(nil),
		(*SignalResponse_StreamStateUpdate)(nil),
		(*SignalResponse_SubscribedQualityUpdate)(nil),
		(*SignalResponse_SubscriptionPermissionUpdate)(nil),
		(*SignalResponse_RefreshToken)(nil),
		(*SignalResponse_TrackUnpublished)(nil),
		(*SignalResponse_Pong)(nil),
		(*SignalResponse_Reconnect)(nil),
		(*SignalResponse_PongResp)(nil),
		(*SignalResponse_SubscriptionResponse)(nil),
	}
	file_livekit_rtc_proto_msgTypes[32].OneofWrappers = []interface{}{
		(*SimulateScenario_SpeakerUpdate)(nil),
		(*SimulateScenario_NodeFailure)(nil),
		(*SimulateScenario_Migration)(nil),
		(*SimulateScenario_ServerLeave)(nil),
		(*SimulateScenario_SwitchCandidateProtocol)(nil),
		(*SimulateScenario_SubscriberBandwidth)(nil),
		(*SimulateScenario_DisconnectSignalOnResume)(nil),
		(*SimulateScenario_DisconnectSignalOnResumeNoMessages)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_rtc_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   38,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_livekit_rtc_proto_goTypes,
		DependencyIndexes: file_livekit_rtc_proto_depIdxs,
		EnumInfos:         file_livekit_rtc_proto_enumTypes,
		MessageInfos:      file_livekit_rtc_proto_msgTypes,
	}.Build()
	File_livekit_rtc_proto = out.File
	file_livekit_rtc_proto_rawDesc = nil
	file_livekit_rtc_proto_goTypes = nil
	file_livekit_rtc_proto_depIdxs = nil
}
