// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The data associated with the custom terminology. For information about the custom terminology file, see <a href="https://docs.aws.amazon.com/translate/latest/dg/creating-custom-terminology.html"> Creating a Custom Terminology</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct TerminologyData {
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>
    pub file: ::aws_smithy_types::Blob,
    /// <p>The data format of the custom terminology.</p>
    pub format: crate::types::TerminologyDataFormat,
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub directionality: ::std::option::Option<crate::types::Directionality>,
}
impl TerminologyData {
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>
    pub fn file(&self) -> &::aws_smithy_types::Blob {
        &self.file
    }
    /// <p>The data format of the custom terminology.</p>
    pub fn format(&self) -> &crate::types::TerminologyDataFormat {
        &self.format
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub fn directionality(&self) -> ::std::option::Option<&crate::types::Directionality> {
        self.directionality.as_ref()
    }
}
impl ::std::fmt::Debug for TerminologyData {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("TerminologyData");
        formatter.field("file", &"*** Sensitive Data Redacted ***");
        formatter.field("format", &self.format);
        formatter.field("directionality", &self.directionality);
        formatter.finish()
    }
}
impl TerminologyData {
    /// Creates a new builder-style object to manufacture [`TerminologyData`](crate::types::TerminologyData).
    pub fn builder() -> crate::types::builders::TerminologyDataBuilder {
        crate::types::builders::TerminologyDataBuilder::default()
    }
}

/// A builder for [`TerminologyData`](crate::types::TerminologyData).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct TerminologyDataBuilder {
    pub(crate) file: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) format: ::std::option::Option<crate::types::TerminologyDataFormat>,
    pub(crate) directionality: ::std::option::Option<crate::types::Directionality>,
}
impl TerminologyDataBuilder {
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>
    /// This field is required.
    pub fn file(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.file = ::std::option::Option::Some(input);
        self
    }
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>
    pub fn set_file(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.file = input;
        self
    }
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding themselves.</p>
    pub fn get_file(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.file
    }
    /// <p>The data format of the custom terminology.</p>
    /// This field is required.
    pub fn format(mut self, input: crate::types::TerminologyDataFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The data format of the custom terminology.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::TerminologyDataFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The data format of the custom terminology.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::TerminologyDataFormat> {
        &self.format
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub fn directionality(mut self, input: crate::types::Directionality) -> Self {
        self.directionality = ::std::option::Option::Some(input);
        self
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub fn set_directionality(mut self, input: ::std::option::Option<crate::types::Directionality>) -> Self {
        self.directionality = input;
        self
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target language. A single multi-directional terminology resource can be used for jobs that translate different language pairs. For example, if the terminology contains English and Spanish terms, it can be used for jobs that translate English to Spanish and Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub fn get_directionality(&self) -> &::std::option::Option<crate::types::Directionality> {
        &self.directionality
    }
    /// Consumes the builder and constructs a [`TerminologyData`](crate::types::TerminologyData).
    /// This method will fail if any of the following fields are not set:
    /// - [`file`](crate::types::builders::TerminologyDataBuilder::file)
    /// - [`format`](crate::types::builders::TerminologyDataBuilder::format)
    pub fn build(self) -> ::std::result::Result<crate::types::TerminologyData, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::TerminologyData {
            file: self.file.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "file",
                    "file was not specified but it is required when building TerminologyData",
                )
            })?,
            format: self.format.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "format",
                    "format was not specified but it is required when building TerminologyData",
                )
            })?,
            directionality: self.directionality,
        })
    }
}
impl ::std::fmt::Debug for TerminologyDataBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("TerminologyDataBuilder");
        formatter.field("file", &"*** Sensitive Data Redacted ***");
        formatter.field("format", &self.format);
        formatter.field("directionality", &self.directionality);
        formatter.finish()
    }
}
