// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains encryption related settings to be used for data encryption with Key Management Service, including KmsEncryptionContext and KmsKeyId. The KmsKeyId is required, while KmsEncryptionContext is optional for additional layer of security.</p>
/// <p>By default, Amazon Web Services HealthScribe provides encryption at rest to protect sensitive customer data using Amazon S3-managed keys. HealthScribe uses the KMS key you specify as a second layer of encryption.</p>
/// <p>Your <code>ResourceAccessRoleArn</code> must permission to use your KMS key. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-encryption.html">Data Encryption at rest for Amazon Web Services HealthScribe</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeEncryptionSettings {
    /// <p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMSencryption context </a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS </a>.</p>
    pub kms_encryption_context: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>The ID of the KMS key you want to use for your streaming session. You can specify its KMS key ID, key Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Alias name: alias/ExampleAlias</p></li>
    /// <li>
    /// <p>Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListKeys.html">ListKeys</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html">DescribeKey</a> KMS API operations. To get the alias name and alias ARN, use <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListAliases.html">ListKeys</a> API operation.</p>
    pub kms_key_id: ::std::string::String,
}
impl MedicalScribeEncryptionSettings {
    /// <p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMSencryption context </a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS </a>.</p>
    pub fn kms_encryption_context(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.kms_encryption_context.as_ref()
    }
    /// <p>The ID of the KMS key you want to use for your streaming session. You can specify its KMS key ID, key Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Alias name: alias/ExampleAlias</p></li>
    /// <li>
    /// <p>Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListKeys.html">ListKeys</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html">DescribeKey</a> KMS API operations. To get the alias name and alias ARN, use <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListAliases.html">ListKeys</a> API operation.</p>
    pub fn kms_key_id(&self) -> &str {
        use std::ops::Deref;
        self.kms_key_id.deref()
    }
}
impl MedicalScribeEncryptionSettings {
    /// Creates a new builder-style object to manufacture [`MedicalScribeEncryptionSettings`](crate::types::MedicalScribeEncryptionSettings).
    pub fn builder() -> crate::types::builders::MedicalScribeEncryptionSettingsBuilder {
        crate::types::builders::MedicalScribeEncryptionSettingsBuilder::default()
    }
}

/// A builder for [`MedicalScribeEncryptionSettings`](crate::types::MedicalScribeEncryptionSettings).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeEncryptionSettingsBuilder {
    pub(crate) kms_encryption_context: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) kms_key_id: ::std::option::Option<::std::string::String>,
}
impl MedicalScribeEncryptionSettingsBuilder {
    /// Adds a key-value pair to `kms_encryption_context`.
    ///
    /// To override the contents of this collection use [`set_kms_encryption_context`](Self::set_kms_encryption_context).
    ///
    /// <p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMSencryption context </a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS </a>.</p>
    pub fn kms_encryption_context(
        mut self,
        k: impl ::std::convert::Into<::std::string::String>,
        v: impl ::std::convert::Into<::std::string::String>,
    ) -> Self {
        let mut hash_map = self.kms_encryption_context.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.kms_encryption_context = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMSencryption context </a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS </a>.</p>
    pub fn set_kms_encryption_context(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    ) -> Self {
        self.kms_encryption_context = input;
        self
    }
    /// <p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMSencryption context </a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS </a>.</p>
    pub fn get_kms_encryption_context(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.kms_encryption_context
    }
    /// <p>The ID of the KMS key you want to use for your streaming session. You can specify its KMS key ID, key Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Alias name: alias/ExampleAlias</p></li>
    /// <li>
    /// <p>Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListKeys.html">ListKeys</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html">DescribeKey</a> KMS API operations. To get the alias name and alias ARN, use <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListAliases.html">ListKeys</a> API operation.</p>
    /// This field is required.
    pub fn kms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the KMS key you want to use for your streaming session. You can specify its KMS key ID, key Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Alias name: alias/ExampleAlias</p></li>
    /// <li>
    /// <p>Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListKeys.html">ListKeys</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html">DescribeKey</a> KMS API operations. To get the alias name and alias ARN, use <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListAliases.html">ListKeys</a> API operation.</p>
    pub fn set_kms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_key_id = input;
        self
    }
    /// <p>The ID of the KMS key you want to use for your streaming session. You can specify its KMS key ID, key Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</p></li>
    /// <li>
    /// <p>Alias name: alias/ExampleAlias</p></li>
    /// <li>
    /// <p>Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListKeys.html">ListKeys</a> or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html">DescribeKey</a> KMS API operations. To get the alias name and alias ARN, use <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ListAliases.html">ListKeys</a> API operation.</p>
    pub fn get_kms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_key_id
    }
    /// Consumes the builder and constructs a [`MedicalScribeEncryptionSettings`](crate::types::MedicalScribeEncryptionSettings).
    /// This method will fail if any of the following fields are not set:
    /// - [`kms_key_id`](crate::types::builders::MedicalScribeEncryptionSettingsBuilder::kms_key_id)
    pub fn build(self) -> ::std::result::Result<crate::types::MedicalScribeEncryptionSettings, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MedicalScribeEncryptionSettings {
            kms_encryption_context: self.kms_encryption_context,
            kms_key_id: self.kms_key_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "kms_key_id",
                    "kms_key_id was not specified but it is required when building MedicalScribeEncryptionSettings",
                )
            })?,
        })
    }
}
