// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains entities identified as personal health information (PHI) in your transcription output, along with various associated attributes. Examples include category, confidence score, type, stability score, and start and end times.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalEntity {
    /// <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
    pub start_time: f64,
    /// <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
    pub end_time: f64,
    /// <p>The category of information identified. The only category is <code>PHI</code>.</p>
    pub category: ::std::option::Option<::std::string::String>,
    /// <p>The word or words identified as PHI.</p>
    pub content: ::std::option::Option<::std::string::String>,
    /// <p>The confidence score associated with the identified PHI entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub confidence: ::std::option::Option<f64>,
}
impl MedicalEntity {
    /// <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn start_time(&self) -> f64 {
        self.start_time
    }
    /// <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn end_time(&self) -> f64 {
        self.end_time
    }
    /// <p>The category of information identified. The only category is <code>PHI</code>.</p>
    pub fn category(&self) -> ::std::option::Option<&str> {
        self.category.as_deref()
    }
    /// <p>The word or words identified as PHI.</p>
    pub fn content(&self) -> ::std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The confidence score associated with the identified PHI entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn confidence(&self) -> ::std::option::Option<f64> {
        self.confidence
    }
}
impl MedicalEntity {
    /// Creates a new builder-style object to manufacture [`MedicalEntity`](crate::types::MedicalEntity).
    pub fn builder() -> crate::types::builders::MedicalEntityBuilder {
        crate::types::builders::MedicalEntityBuilder::default()
    }
}

/// A builder for [`MedicalEntity`](crate::types::MedicalEntity).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalEntityBuilder {
    pub(crate) start_time: ::std::option::Option<f64>,
    pub(crate) end_time: ::std::option::Option<f64>,
    pub(crate) category: ::std::option::Option<::std::string::String>,
    pub(crate) content: ::std::option::Option<::std::string::String>,
    pub(crate) confidence: ::std::option::Option<f64>,
}
impl MedicalEntityBuilder {
    /// <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn start_time(mut self, input: f64) -> Self {
        self.start_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn set_start_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.start_time = input;
        self
    }
    /// <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn get_start_time(&self) -> &::std::option::Option<f64> {
        &self.start_time
    }
    /// <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn end_time(mut self, input: f64) -> Self {
        self.end_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn set_end_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.end_time = input;
        self
    }
    /// <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
    pub fn get_end_time(&self) -> &::std::option::Option<f64> {
        &self.end_time
    }
    /// <p>The category of information identified. The only category is <code>PHI</code>.</p>
    pub fn category(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.category = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The category of information identified. The only category is <code>PHI</code>.</p>
    pub fn set_category(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.category = input;
        self
    }
    /// <p>The category of information identified. The only category is <code>PHI</code>.</p>
    pub fn get_category(&self) -> &::std::option::Option<::std::string::String> {
        &self.category
    }
    /// <p>The word or words identified as PHI.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The word or words identified as PHI.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content = input;
        self
    }
    /// <p>The word or words identified as PHI.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        &self.content
    }
    /// <p>The confidence score associated with the identified PHI entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn confidence(mut self, input: f64) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>The confidence score associated with the identified PHI entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<f64>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>The confidence score associated with the identified PHI entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<f64> {
        &self.confidence
    }
    /// Consumes the builder and constructs a [`MedicalEntity`](crate::types::MedicalEntity).
    pub fn build(self) -> crate::types::MedicalEntity {
        crate::types::MedicalEntity {
            start_time: self.start_time.unwrap_or_default(),
            end_time: self.end_time.unwrap_or_default(),
            category: self.category,
            content: self.content,
            confidence: self.confidence,
        }
    }
}
