// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListObjectVersions`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name that contains the objects.</p><br>
    ///   - [`delimiter(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::delimiter) / [`set_delimiter(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_delimiter):<br>required: **false**<br><p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in <code>CommonPrefixes</code>. These groups are counted as one result against the <code>max-keys</code> limitation. These keys are not returned elsewhere in the response.</p><br>
    ///   - [`encoding_type(EncodingType)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_encoding_type):<br>required: **false**<br><p>Encoding type used by Amazon S3 to encode the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html">object keys</a> in the response. Responses are encoded only in UTF-8. An object key can contain any Unicode character. However, the XML 1.0 parser can't parse certain characters, such as characters with an ASCII value from 0 to 10. For characters that aren't supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response. For more information about characters to avoid in object key names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-guidelines">Object key naming guidelines</a>.</p><note>  <p>When using the URL encoding type, non-ASCII characters that are used in an object's key name will be percent-encoded according to UTF-8 code values. For example, the object <code>test_file(3).png</code> will appear as <code>test_file%283%29.png</code>.</p> </note><br>
    ///   - [`key_marker(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::key_marker) / [`set_key_marker(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_key_marker):<br>required: **false**<br><p>Specifies the key to start with when listing objects in a bucket.</p><br>
    ///   - [`max_keys(i32)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::max_keys) / [`set_max_keys(Option<i32>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_max_keys):<br>required: **false**<br><p>Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because <code>max-keys</code> was exceeded, the response contains <code><istruncated>    true   </istruncated></code>. To return the additional keys, see <code>key-marker</code> and <code>version-id-marker</code>.</p><br>
    ///   - [`prefix(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::prefix) / [`set_prefix(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_prefix):<br>required: **false**<br><p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using <code>prefix</code> to make groups in the same way that you'd use a folder in a file system.) You can use <code>prefix</code> with <code>delimiter</code> to roll up numerous objects into a single result under <code>CommonPrefixes</code>.</p><br>
    ///   - [`version_id_marker(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::version_id_marker) / [`set_version_id_marker(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_version_id_marker):<br>required: **false**<br><p>Specifies the object version you want to start listing from.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`optional_object_attributes(OptionalObjectAttributes)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::optional_object_attributes) / [`set_optional_object_attributes(Option<Vec::<OptionalObjectAttributes>>)`](crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::set_optional_object_attributes):<br>required: **false**<br><p>Specifies the optional fields that you want returned in the response. Fields that you do not specify are not returned.</p><br>
    /// - On success, responds with [`ListObjectVersionsOutput`](crate::operation::list_object_versions::ListObjectVersionsOutput) with field(s):
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::is_truncated): <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria. If your results were truncated, you can make a follow-up paginated request by using the <code>NextKeyMarker</code> and <code>NextVersionIdMarker</code> response parameters as a starting place in another request to return the rest of the results.</p>
    ///   - [`key_marker(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::key_marker): <p>Marks the last key returned in a truncated response.</p>
    ///   - [`version_id_marker(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::version_id_marker): <p>Marks the last version of the key returned in a truncated response.</p>
    ///   - [`next_key_marker(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::next_key_marker): <p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextKeyMarker</code> specifies the first key not returned that satisfies the search criteria. Use this value for the key-marker request parameter in a subsequent request.</p>
    ///   - [`next_version_id_marker(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::next_version_id_marker): <p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextVersionIdMarker</code> specifies the first object version not returned that satisfies the search criteria. Use this value for the <code>version-id-marker</code> request parameter in a subsequent request.</p>
    ///   - [`versions(Option<Vec::<ObjectVersion>>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::versions): <p>Container for version information.</p>
    ///   - [`delete_markers(Option<Vec::<DeleteMarkerEntry>>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::delete_markers): <p>Container for an object that is a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    ///   - [`name(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::name): <p>The bucket name.</p>
    ///   - [`prefix(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::prefix): <p>Selects objects that start with the value supplied by this parameter.</p>
    ///   - [`delimiter(Option<String>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::delimiter): <p>The delimiter grouping the included keys. A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in <code>CommonPrefixes</code>. These groups are counted as one result against the <code>max-keys</code> limitation. These keys are not returned elsewhere in the response.</p>
    ///   - [`max_keys(Option<i32>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::max_keys): <p>Specifies the maximum number of objects to return.</p>
    ///   - [`common_prefixes(Option<Vec::<CommonPrefix>>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::common_prefixes): <p>All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.</p>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::encoding_type): <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p> <p>If you specify the <code>encoding-type</code> request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p><code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::list_object_versions::ListObjectVersionsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html">Using Requester Pays buckets for storage transfers and usage</a> in the <i>Amazon Simple Storage Service user guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<ListObjectVersionsError>`](crate::operation::list_object_versions::ListObjectVersionsError)
    pub fn list_object_versions(&self) -> crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder {
        crate::operation::list_object_versions::builders::ListObjectVersionsFluentBuilder::new(self.handle.clone())
    }
}
