// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`HeadObject`](crate::operation::head_object::builders::HeadObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket that contains the object.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>amzn-s3-demo-bucket</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point for general purpose buckets, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When you use this action with an access point for directory buckets, you must provide the access point name in place of the bucket name. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`if_match(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::if_match) / [`set_if_match(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_if_match):<br>required: **false**<br><p>Return the object only if its entity tag (ETag) is the same as the one specified; otherwise, return a 412 (precondition failed) error.</p> <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows:</p> <ul>  <li>   <p><code>If-Match</code> condition evaluates to <code>true</code>, and;</p></li>  <li>   <p><code>If-Unmodified-Since</code> condition evaluates to <code>false</code>;</p></li> </ul> <p>Then Amazon S3 returns <code>200 OK</code> and the data requested.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_modified_since(DateTime)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::if_modified_since) / [`set_if_modified_since(Option<DateTime>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_if_modified_since):<br>required: **false**<br><p>Return the object only if it has been modified since the specified time; otherwise, return a 304 (not modified) error.</p> <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:</p> <ul>  <li>   <p><code>If-None-Match</code> condition evaluates to <code>false</code>, and;</p></li>  <li>   <p><code>If-Modified-Since</code> condition evaluates to <code>true</code>;</p></li> </ul> <p>Then Amazon S3 returns the <code>304 Not Modified</code> response code.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_none_match(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::if_none_match) / [`set_if_none_match(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_if_none_match):<br>required: **false**<br><p>Return the object only if its entity tag (ETag) is different from the one specified; otherwise, return a 304 (not modified) error.</p> <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:</p> <ul>  <li>   <p><code>If-None-Match</code> condition evaluates to <code>false</code>, and;</p></li>  <li>   <p><code>If-Modified-Since</code> condition evaluates to <code>true</code>;</p></li> </ul> <p>Then Amazon S3 returns the <code>304 Not Modified</code> response code.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`if_unmodified_since(DateTime)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::if_unmodified_since) / [`set_if_unmodified_since(Option<DateTime>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_if_unmodified_since):<br>required: **false**<br><p>Return the object only if it has not been modified since the specified time; otherwise, return a 412 (precondition failed) error.</p> <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows:</p> <ul>  <li>   <p><code>If-Match</code> condition evaluates to <code>true</code>, and;</p></li>  <li>   <p><code>If-Unmodified-Since</code> condition evaluates to <code>false</code>;</p></li> </ul> <p>Then Amazon S3 returns <code>200 OK</code> and the data requested.</p> <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_key):<br>required: **true**<br><p>The object key.</p><br>
    ///   - [`range(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::range) / [`set_range(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_range):<br>required: **false**<br><p>HeadObject returns only the metadata for an object. If the Range is satisfiable, only the <code>ContentLength</code> is affected in the response. If the Range is not satisfiable, S3 returns a <code>416 - Requested Range Not Satisfiable</code> error.</p><br>
    ///   - [`response_cache_control(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_cache_control) / [`set_response_cache_control(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_cache_control):<br>required: **false**<br><p>Sets the <code>Cache-Control</code> header of the response.</p><br>
    ///   - [`response_content_disposition(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_content_disposition) / [`set_response_content_disposition(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_content_disposition):<br>required: **false**<br><p>Sets the <code>Content-Disposition</code> header of the response.</p><br>
    ///   - [`response_content_encoding(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_content_encoding) / [`set_response_content_encoding(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_content_encoding):<br>required: **false**<br><p>Sets the <code>Content-Encoding</code> header of the response.</p><br>
    ///   - [`response_content_language(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_content_language) / [`set_response_content_language(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_content_language):<br>required: **false**<br><p>Sets the <code>Content-Language</code> header of the response.</p><br>
    ///   - [`response_content_type(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_content_type) / [`set_response_content_type(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_content_type):<br>required: **false**<br><p>Sets the <code>Content-Type</code> header of the response.</p><br>
    ///   - [`response_expires(DateTime)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::response_expires) / [`set_response_expires(Option<DateTime>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_response_expires):<br>required: **false**<br><p>Sets the <code>Expires</code> header of the response.</p><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_version_id):<br>required: **false**<br><p>Version ID used to reference a specific version of the object.</p><note>  <p>For directory buckets in this API operation, only the <code>null</code> value of the version ID is supported.</p> </note><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`part_number(i32)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::part_number) / [`set_part_number(Option<i32>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_part_number):<br>required: **false**<br><p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`checksum_mode(ChecksumMode)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::checksum_mode) / [`set_checksum_mode(Option<ChecksumMode>)`](crate::operation::head_object::builders::HeadObjectFluentBuilder::set_checksum_mode):<br>required: **false**<br><p>To retrieve the checksum, this parameter must be enabled.</p> <p><b>General purpose buckets</b> - If you enable checksum mode and the object is uploaded with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_Checksum.html">checksum</a> and encrypted with an Key Management Service (KMS) key, you must have permission to use the <code>kms:Decrypt</code> action to retrieve the checksum.</p> <p><b>Directory buckets</b> - If you enable <code>ChecksumMode</code> and the object is encrypted with Amazon Web Services Key Management Service (Amazon Web Services KMS), you must also have the <code>kms:GenerateDataKey</code> and <code>kms:Decrypt</code> permissions in IAM identity-based policies and KMS key policies for the KMS key to retrieve the checksum of the object.</p><br>
    /// - On success, responds with [`HeadObjectOutput`](crate::operation::head_object::HeadObjectOutput) with field(s):
    ///   - [`delete_marker(Option<bool>)`](crate::operation::head_object::HeadObjectOutput::delete_marker): <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`accept_ranges(Option<String>)`](crate::operation::head_object::HeadObjectOutput::accept_ranges): <p>Indicates that a range of bytes was specified.</p>
    ///   - [`expiration(Option<String>)`](crate::operation::head_object::HeadObjectOutput::expiration): <p>If the object expiration is configured (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html"> <code>PutBucketLifecycleConfiguration</code> </a>), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs providing object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p><note>  <p>Object expiration information is not returned in directory buckets and this header returns the value "<code>NotImplemented</code>" in all responses for directory buckets.</p> </note>
    ///   - [`restore(Option<String>)`](crate::operation::head_object::HeadObjectOutput::restore): <p>If the object is an archived object (an object whose storage class is GLACIER), the response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p> <p>If an archive copy is already restored, the header value indicates when Amazon S3 is scheduled to delete the object copy. For example:</p> <p><code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00 GMT"</code></p> <p>If the object restoration is in progress, the header returns the value <code>ongoing-request="true"</code>.</p> <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p><note>  <p>This functionality is not supported for directory buckets. Directory buckets only support <code>EXPRESS_ONEZONE</code> (the S3 Express One Zone storage class) in Availability Zones and <code>ONEZONE_IA</code> (the S3 One Zone-Infrequent Access storage class) in Dedicated Local Zones.</p> </note>
    ///   - [`archive_status(Option<ArchiveStatus>)`](crate::operation::head_object::HeadObjectOutput::archive_status): <p>The archive state of the head object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`last_modified(Option<DateTime>)`](crate::operation::head_object::HeadObjectOutput::last_modified): <p>Date and time when the object was last modified.</p>
    ///   - [`content_length(Option<i64>)`](crate::operation::head_object::HeadObjectOutput::content_length): <p>Size of the body in bytes.</p>
    ///   - [`checksum_crc32(Option<String>)`](crate::operation::head_object::HeadObjectOutput::checksum_crc32): <p>The Base64 encoded, 32-bit <code>CRC32 checksum</code> of the object. This checksum is only be present if the checksum was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc32_c(Option<String>)`](crate::operation::head_object::HeadObjectOutput::checksum_crc32_c): <p>The Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object. This checksum is only present if the checksum was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc64_nvme(Option<String>)`](crate::operation::head_object::HeadObjectOutput::checksum_crc64_nvme): <p>The Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity in the Amazon S3 User Guide</a>.</p>
    ///   - [`checksum_sha1(Option<String>)`](crate::operation::head_object::HeadObjectOutput::checksum_sha1): <p>The Base64 encoded, 160-bit <code>SHA1</code> digest of the object. This will only be present if the object was uploaded with the object. When you use the API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha256(Option<String>)`](crate::operation::head_object::HeadObjectOutput::checksum_sha256): <p>The Base64 encoded, 256-bit <code>SHA256</code> digest of the object. This will only be present if the object was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_type(Option<ChecksumType>)`](crate::operation::head_object::HeadObjectOutput::checksum_type): <p>The checksum type, which determines how part-level checksums are combined to create an object-level checksum for multipart objects. You can use this header response to verify that the checksum type that is received is the same checksum type that was specified in <code>CreateMultipartUpload</code> request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity in the Amazon S3 User Guide</a>.</p>
    ///   - [`e_tag(Option<String>)`](crate::operation::head_object::HeadObjectOutput::e_tag): <p>An entity tag (ETag) is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    ///   - [`missing_meta(Option<i32>)`](crate::operation::head_object::HeadObjectOutput::missing_meta): <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`version_id(Option<String>)`](crate::operation::head_object::HeadObjectOutput::version_id): <p>Version ID of the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`cache_control(Option<String>)`](crate::operation::head_object::HeadObjectOutput::cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(Option<String>)`](crate::operation::head_object::HeadObjectOutput::content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(Option<String>)`](crate::operation::head_object::HeadObjectOutput::content_encoding): <p>Indicates what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(Option<String>)`](crate::operation::head_object::HeadObjectOutput::content_language): <p>The language the content is in.</p>
    ///   - [`content_type(Option<String>)`](crate::operation::head_object::HeadObjectOutput::content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`content_range(Option<String>)`](crate::operation::head_object::HeadObjectOutput::content_range): <p>The portion of the object returned in the response for a <code>GET</code> request.</p>
    ///   - [`website_redirect_location(Option<String>)`](crate::operation::head_object::HeadObjectOutput::website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::head_object::HeadObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>, <code>aws:kms:dsse</code>).</p>
    ///   - [`metadata(Option<HashMap::<String, String>>)`](crate::operation::head_object::HeadObjectOutput::metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::head_object::HeadObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::head_object::HeadObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::head_object::HeadObjectOutput::ssekms_key_id): <p>If present, indicates the ID of the KMS key that was used for object encryption.</p>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::head_object::HeadObjectOutput::bucket_key_enabled): <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::operation::head_object::HeadObjectOutput::storage_class): <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p><note>  <p><b>Directory buckets </b> - Directory buckets only support <code>EXPRESS_ONEZONE</code> (the S3 Express One Zone storage class) in Availability Zones and <code>ONEZONE_IA</code> (the S3 One Zone-Infrequent Access storage class) in Dedicated Local Zones.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::head_object::HeadObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html">Using Requester Pays buckets for storage transfers and usage</a> in the <i>Amazon Simple Storage Service user guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`replication_status(Option<ReplicationStatus>)`](crate::operation::head_object::HeadObjectOutput::replication_status): <p>Amazon S3 can return this header if your request involves a bucket that is either a source or a destination in a replication rule.</p> <p>In replication, you have a source bucket on which you configure replication and destination bucket or buckets where Amazon S3 stores object replicas. When you request an object (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response as follows:</p> <ul>  <li>   <p><b>If requesting an object from the source bucket</b>, Amazon S3 will return the <code>x-amz-replication-status</code> header if the object in your request is eligible for replication.</p>   <p>For example, suppose that in your replication configuration, you specify object prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix <code>TaxDocs</code>. Any objects you upload with this key name prefix, for example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any object request with this key name prefix, Amazon S3 will return the <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or FAILED indicating object replication status.</p></li>  <li>   <p><b>If requesting an object from a destination bucket</b>, Amazon S3 will return the <code>x-amz-replication-status</code> header with value REPLICA if the object in your request is a replica that Amazon S3 created and there is no replica modification replication in progress.</p></li>  <li>   <p><b>When replicating objects to multiple destination buckets</b>, the <code>x-amz-replication-status</code> header acts differently. The header of the source object will only return a value of COMPLETED when replication is successful to all destinations. The header will remain at value PENDING until replication has completed for all destinations. If one or more destinations fails replication the header will return FAILED.</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`parts_count(Option<i32>)`](crate::operation::head_object::HeadObjectOutput::parts_count): <p>The count of parts this object has. This value is only returned if you specify <code>partNumber</code> in your request and the object was uploaded as a multipart upload.</p>
    ///   - [`object_lock_mode(Option<ObjectLockMode>)`](crate::operation::head_object::HeadObjectOutput::object_lock_mode): <p>The Object Lock mode, if any, that's in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`object_lock_retain_until_date(Option<DateTime>)`](crate::operation::head_object::HeadObjectOutput::object_lock_retain_until_date): <p>The date and time when the Object Lock retention period expires. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::operation::head_object::HeadObjectOutput::object_lock_legal_hold_status): <p>Specifies whether a legal hold is in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This header is not returned if the specified version of this object has never had a legal hold applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`expires(Option<DateTime>)`](crate::operation::head_object::HeadObjectOutput::expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`expires_string(Option<String>)`](crate::operation::head_object::HeadObjectOutput::expires_string): <p>The date and time at which the object is no longer cacheable.</p>
    /// - On failure, responds with [`SdkError<HeadObjectError>`](crate::operation::head_object::HeadObjectError)
    pub fn head_object(&self) -> crate::operation::head_object::builders::HeadObjectFluentBuilder {
        crate::operation::head_object::builders::HeadObjectFluentBuilder::new(self.handle.clone())
    }
}
