// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `VoiceId`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let voiceid = unimplemented!();
/// match voiceid {
///     VoiceId::Aditi => { /* ... */ },
///     VoiceId::Adriano => { /* ... */ },
///     VoiceId::Amy => { /* ... */ },
///     VoiceId::Andres => { /* ... */ },
///     VoiceId::Aria => { /* ... */ },
///     VoiceId::Arlet => { /* ... */ },
///     VoiceId::Arthur => { /* ... */ },
///     VoiceId::Astrid => { /* ... */ },
///     VoiceId::Ayanda => { /* ... */ },
///     VoiceId::Bianca => { /* ... */ },
///     VoiceId::Brian => { /* ... */ },
///     VoiceId::Burcu => { /* ... */ },
///     VoiceId::Camila => { /* ... */ },
///     VoiceId::Carla => { /* ... */ },
///     VoiceId::Carmen => { /* ... */ },
///     VoiceId::Celine => { /* ... */ },
///     VoiceId::Chantal => { /* ... */ },
///     VoiceId::Conchita => { /* ... */ },
///     VoiceId::Cristiano => { /* ... */ },
///     VoiceId::Daniel => { /* ... */ },
///     VoiceId::Danielle => { /* ... */ },
///     VoiceId::Dora => { /* ... */ },
///     VoiceId::Elin => { /* ... */ },
///     VoiceId::Emma => { /* ... */ },
///     VoiceId::Enrique => { /* ... */ },
///     VoiceId::Ewa => { /* ... */ },
///     VoiceId::Filiz => { /* ... */ },
///     VoiceId::Gabrielle => { /* ... */ },
///     VoiceId::Geraint => { /* ... */ },
///     VoiceId::Giorgio => { /* ... */ },
///     VoiceId::Gregory => { /* ... */ },
///     VoiceId::Gwyneth => { /* ... */ },
///     VoiceId::Hala => { /* ... */ },
///     VoiceId::Hannah => { /* ... */ },
///     VoiceId::Hans => { /* ... */ },
///     VoiceId::Hiujin => { /* ... */ },
///     VoiceId::Ida => { /* ... */ },
///     VoiceId::Ines => { /* ... */ },
///     VoiceId::Isabelle => { /* ... */ },
///     VoiceId::Ivy => { /* ... */ },
///     VoiceId::Jacek => { /* ... */ },
///     VoiceId::Jan => { /* ... */ },
///     VoiceId::Jasmine => { /* ... */ },
///     VoiceId::Jihye => { /* ... */ },
///     VoiceId::Jitka => { /* ... */ },
///     VoiceId::Joanna => { /* ... */ },
///     VoiceId::Joey => { /* ... */ },
///     VoiceId::Justin => { /* ... */ },
///     VoiceId::Kajal => { /* ... */ },
///     VoiceId::Karl => { /* ... */ },
///     VoiceId::Kazuha => { /* ... */ },
///     VoiceId::Kendra => { /* ... */ },
///     VoiceId::Kevin => { /* ... */ },
///     VoiceId::Kimberly => { /* ... */ },
///     VoiceId::Laura => { /* ... */ },
///     VoiceId::Lea => { /* ... */ },
///     VoiceId::Liam => { /* ... */ },
///     VoiceId::Lisa => { /* ... */ },
///     VoiceId::Liv => { /* ... */ },
///     VoiceId::Lotte => { /* ... */ },
///     VoiceId::Lucia => { /* ... */ },
///     VoiceId::Lupe => { /* ... */ },
///     VoiceId::Mads => { /* ... */ },
///     VoiceId::Maja => { /* ... */ },
///     VoiceId::Marlene => { /* ... */ },
///     VoiceId::Mathieu => { /* ... */ },
///     VoiceId::Matthew => { /* ... */ },
///     VoiceId::Maxim => { /* ... */ },
///     VoiceId::Mia => { /* ... */ },
///     VoiceId::Miguel => { /* ... */ },
///     VoiceId::Mizuki => { /* ... */ },
///     VoiceId::Naja => { /* ... */ },
///     VoiceId::Niamh => { /* ... */ },
///     VoiceId::Nicole => { /* ... */ },
///     VoiceId::Ola => { /* ... */ },
///     VoiceId::Olivia => { /* ... */ },
///     VoiceId::Pedro => { /* ... */ },
///     VoiceId::Penelope => { /* ... */ },
///     VoiceId::Raveena => { /* ... */ },
///     VoiceId::Remi => { /* ... */ },
///     VoiceId::Ricardo => { /* ... */ },
///     VoiceId::Ruben => { /* ... */ },
///     VoiceId::Russell => { /* ... */ },
///     VoiceId::Ruth => { /* ... */ },
///     VoiceId::Sabrina => { /* ... */ },
///     VoiceId::Salli => { /* ... */ },
///     VoiceId::Seoyeon => { /* ... */ },
///     VoiceId::Sergio => { /* ... */ },
///     VoiceId::Sofie => { /* ... */ },
///     VoiceId::Stephen => { /* ... */ },
///     VoiceId::Suvi => { /* ... */ },
///     VoiceId::Takumi => { /* ... */ },
///     VoiceId::Tatyana => { /* ... */ },
///     VoiceId::Thiago => { /* ... */ },
///     VoiceId::Tomoko => { /* ... */ },
///     VoiceId::Vicki => { /* ... */ },
///     VoiceId::Vitoria => { /* ... */ },
///     VoiceId::Zayd => { /* ... */ },
///     VoiceId::Zeina => { /* ... */ },
///     VoiceId::Zhiyu => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `voiceid` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `VoiceId::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `VoiceId::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `VoiceId::NewFeature` is defined.
/// Specifically, when `voiceid` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `VoiceId::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum VoiceId {
    #[allow(missing_docs)] // documentation missing in model
    Aditi,
    #[allow(missing_docs)] // documentation missing in model
    Adriano,
    #[allow(missing_docs)] // documentation missing in model
    Amy,
    #[allow(missing_docs)] // documentation missing in model
    Andres,
    #[allow(missing_docs)] // documentation missing in model
    Aria,
    #[allow(missing_docs)] // documentation missing in model
    Arlet,
    #[allow(missing_docs)] // documentation missing in model
    Arthur,
    #[allow(missing_docs)] // documentation missing in model
    Astrid,
    #[allow(missing_docs)] // documentation missing in model
    Ayanda,
    #[allow(missing_docs)] // documentation missing in model
    Bianca,
    #[allow(missing_docs)] // documentation missing in model
    Brian,
    #[allow(missing_docs)] // documentation missing in model
    Burcu,
    #[allow(missing_docs)] // documentation missing in model
    Camila,
    #[allow(missing_docs)] // documentation missing in model
    Carla,
    #[allow(missing_docs)] // documentation missing in model
    Carmen,
    #[allow(missing_docs)] // documentation missing in model
    Celine,
    #[allow(missing_docs)] // documentation missing in model
    Chantal,
    #[allow(missing_docs)] // documentation missing in model
    Conchita,
    #[allow(missing_docs)] // documentation missing in model
    Cristiano,
    #[allow(missing_docs)] // documentation missing in model
    Daniel,
    #[allow(missing_docs)] // documentation missing in model
    Danielle,
    #[allow(missing_docs)] // documentation missing in model
    Dora,
    #[allow(missing_docs)] // documentation missing in model
    Elin,
    #[allow(missing_docs)] // documentation missing in model
    Emma,
    #[allow(missing_docs)] // documentation missing in model
    Enrique,
    #[allow(missing_docs)] // documentation missing in model
    Ewa,
    #[allow(missing_docs)] // documentation missing in model
    Filiz,
    #[allow(missing_docs)] // documentation missing in model
    Gabrielle,
    #[allow(missing_docs)] // documentation missing in model
    Geraint,
    #[allow(missing_docs)] // documentation missing in model
    Giorgio,
    #[allow(missing_docs)] // documentation missing in model
    Gregory,
    #[allow(missing_docs)] // documentation missing in model
    Gwyneth,
    #[allow(missing_docs)] // documentation missing in model
    Hala,
    #[allow(missing_docs)] // documentation missing in model
    Hannah,
    #[allow(missing_docs)] // documentation missing in model
    Hans,
    #[allow(missing_docs)] // documentation missing in model
    Hiujin,
    #[allow(missing_docs)] // documentation missing in model
    Ida,
    #[allow(missing_docs)] // documentation missing in model
    Ines,
    #[allow(missing_docs)] // documentation missing in model
    Isabelle,
    #[allow(missing_docs)] // documentation missing in model
    Ivy,
    #[allow(missing_docs)] // documentation missing in model
    Jacek,
    #[allow(missing_docs)] // documentation missing in model
    Jan,
    #[allow(missing_docs)] // documentation missing in model
    Jasmine,
    #[allow(missing_docs)] // documentation missing in model
    Jihye,
    #[allow(missing_docs)] // documentation missing in model
    Jitka,
    #[allow(missing_docs)] // documentation missing in model
    Joanna,
    #[allow(missing_docs)] // documentation missing in model
    Joey,
    #[allow(missing_docs)] // documentation missing in model
    Justin,
    #[allow(missing_docs)] // documentation missing in model
    Kajal,
    #[allow(missing_docs)] // documentation missing in model
    Karl,
    #[allow(missing_docs)] // documentation missing in model
    Kazuha,
    #[allow(missing_docs)] // documentation missing in model
    Kendra,
    #[allow(missing_docs)] // documentation missing in model
    Kevin,
    #[allow(missing_docs)] // documentation missing in model
    Kimberly,
    #[allow(missing_docs)] // documentation missing in model
    Laura,
    #[allow(missing_docs)] // documentation missing in model
    Lea,
    #[allow(missing_docs)] // documentation missing in model
    Liam,
    #[allow(missing_docs)] // documentation missing in model
    Lisa,
    #[allow(missing_docs)] // documentation missing in model
    Liv,
    #[allow(missing_docs)] // documentation missing in model
    Lotte,
    #[allow(missing_docs)] // documentation missing in model
    Lucia,
    #[allow(missing_docs)] // documentation missing in model
    Lupe,
    #[allow(missing_docs)] // documentation missing in model
    Mads,
    #[allow(missing_docs)] // documentation missing in model
    Maja,
    #[allow(missing_docs)] // documentation missing in model
    Marlene,
    #[allow(missing_docs)] // documentation missing in model
    Mathieu,
    #[allow(missing_docs)] // documentation missing in model
    Matthew,
    #[allow(missing_docs)] // documentation missing in model
    Maxim,
    #[allow(missing_docs)] // documentation missing in model
    Mia,
    #[allow(missing_docs)] // documentation missing in model
    Miguel,
    #[allow(missing_docs)] // documentation missing in model
    Mizuki,
    #[allow(missing_docs)] // documentation missing in model
    Naja,
    #[allow(missing_docs)] // documentation missing in model
    Niamh,
    #[allow(missing_docs)] // documentation missing in model
    Nicole,
    #[allow(missing_docs)] // documentation missing in model
    Ola,
    #[allow(missing_docs)] // documentation missing in model
    Olivia,
    #[allow(missing_docs)] // documentation missing in model
    Pedro,
    #[allow(missing_docs)] // documentation missing in model
    Penelope,
    #[allow(missing_docs)] // documentation missing in model
    Raveena,
    #[allow(missing_docs)] // documentation missing in model
    Remi,
    #[allow(missing_docs)] // documentation missing in model
    Ricardo,
    #[allow(missing_docs)] // documentation missing in model
    Ruben,
    #[allow(missing_docs)] // documentation missing in model
    Russell,
    #[allow(missing_docs)] // documentation missing in model
    Ruth,
    #[allow(missing_docs)] // documentation missing in model
    Sabrina,
    #[allow(missing_docs)] // documentation missing in model
    Salli,
    #[allow(missing_docs)] // documentation missing in model
    Seoyeon,
    #[allow(missing_docs)] // documentation missing in model
    Sergio,
    #[allow(missing_docs)] // documentation missing in model
    Sofie,
    #[allow(missing_docs)] // documentation missing in model
    Stephen,
    #[allow(missing_docs)] // documentation missing in model
    Suvi,
    #[allow(missing_docs)] // documentation missing in model
    Takumi,
    #[allow(missing_docs)] // documentation missing in model
    Tatyana,
    #[allow(missing_docs)] // documentation missing in model
    Thiago,
    #[allow(missing_docs)] // documentation missing in model
    Tomoko,
    #[allow(missing_docs)] // documentation missing in model
    Vicki,
    #[allow(missing_docs)] // documentation missing in model
    Vitoria,
    #[allow(missing_docs)] // documentation missing in model
    Zayd,
    #[allow(missing_docs)] // documentation missing in model
    Zeina,
    #[allow(missing_docs)] // documentation missing in model
    Zhiyu,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for VoiceId {
    fn from(s: &str) -> Self {
        match s {
            "Aditi" => VoiceId::Aditi,
            "Adriano" => VoiceId::Adriano,
            "Amy" => VoiceId::Amy,
            "Andres" => VoiceId::Andres,
            "Aria" => VoiceId::Aria,
            "Arlet" => VoiceId::Arlet,
            "Arthur" => VoiceId::Arthur,
            "Astrid" => VoiceId::Astrid,
            "Ayanda" => VoiceId::Ayanda,
            "Bianca" => VoiceId::Bianca,
            "Brian" => VoiceId::Brian,
            "Burcu" => VoiceId::Burcu,
            "Camila" => VoiceId::Camila,
            "Carla" => VoiceId::Carla,
            "Carmen" => VoiceId::Carmen,
            "Celine" => VoiceId::Celine,
            "Chantal" => VoiceId::Chantal,
            "Conchita" => VoiceId::Conchita,
            "Cristiano" => VoiceId::Cristiano,
            "Daniel" => VoiceId::Daniel,
            "Danielle" => VoiceId::Danielle,
            "Dora" => VoiceId::Dora,
            "Elin" => VoiceId::Elin,
            "Emma" => VoiceId::Emma,
            "Enrique" => VoiceId::Enrique,
            "Ewa" => VoiceId::Ewa,
            "Filiz" => VoiceId::Filiz,
            "Gabrielle" => VoiceId::Gabrielle,
            "Geraint" => VoiceId::Geraint,
            "Giorgio" => VoiceId::Giorgio,
            "Gregory" => VoiceId::Gregory,
            "Gwyneth" => VoiceId::Gwyneth,
            "Hala" => VoiceId::Hala,
            "Hannah" => VoiceId::Hannah,
            "Hans" => VoiceId::Hans,
            "Hiujin" => VoiceId::Hiujin,
            "Ida" => VoiceId::Ida,
            "Ines" => VoiceId::Ines,
            "Isabelle" => VoiceId::Isabelle,
            "Ivy" => VoiceId::Ivy,
            "Jacek" => VoiceId::Jacek,
            "Jan" => VoiceId::Jan,
            "Jasmine" => VoiceId::Jasmine,
            "Jihye" => VoiceId::Jihye,
            "Jitka" => VoiceId::Jitka,
            "Joanna" => VoiceId::Joanna,
            "Joey" => VoiceId::Joey,
            "Justin" => VoiceId::Justin,
            "Kajal" => VoiceId::Kajal,
            "Karl" => VoiceId::Karl,
            "Kazuha" => VoiceId::Kazuha,
            "Kendra" => VoiceId::Kendra,
            "Kevin" => VoiceId::Kevin,
            "Kimberly" => VoiceId::Kimberly,
            "Laura" => VoiceId::Laura,
            "Lea" => VoiceId::Lea,
            "Liam" => VoiceId::Liam,
            "Lisa" => VoiceId::Lisa,
            "Liv" => VoiceId::Liv,
            "Lotte" => VoiceId::Lotte,
            "Lucia" => VoiceId::Lucia,
            "Lupe" => VoiceId::Lupe,
            "Mads" => VoiceId::Mads,
            "Maja" => VoiceId::Maja,
            "Marlene" => VoiceId::Marlene,
            "Mathieu" => VoiceId::Mathieu,
            "Matthew" => VoiceId::Matthew,
            "Maxim" => VoiceId::Maxim,
            "Mia" => VoiceId::Mia,
            "Miguel" => VoiceId::Miguel,
            "Mizuki" => VoiceId::Mizuki,
            "Naja" => VoiceId::Naja,
            "Niamh" => VoiceId::Niamh,
            "Nicole" => VoiceId::Nicole,
            "Ola" => VoiceId::Ola,
            "Olivia" => VoiceId::Olivia,
            "Pedro" => VoiceId::Pedro,
            "Penelope" => VoiceId::Penelope,
            "Raveena" => VoiceId::Raveena,
            "Remi" => VoiceId::Remi,
            "Ricardo" => VoiceId::Ricardo,
            "Ruben" => VoiceId::Ruben,
            "Russell" => VoiceId::Russell,
            "Ruth" => VoiceId::Ruth,
            "Sabrina" => VoiceId::Sabrina,
            "Salli" => VoiceId::Salli,
            "Seoyeon" => VoiceId::Seoyeon,
            "Sergio" => VoiceId::Sergio,
            "Sofie" => VoiceId::Sofie,
            "Stephen" => VoiceId::Stephen,
            "Suvi" => VoiceId::Suvi,
            "Takumi" => VoiceId::Takumi,
            "Tatyana" => VoiceId::Tatyana,
            "Thiago" => VoiceId::Thiago,
            "Tomoko" => VoiceId::Tomoko,
            "Vicki" => VoiceId::Vicki,
            "Vitoria" => VoiceId::Vitoria,
            "Zayd" => VoiceId::Zayd,
            "Zeina" => VoiceId::Zeina,
            "Zhiyu" => VoiceId::Zhiyu,
            other => VoiceId::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for VoiceId {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(VoiceId::from(s))
    }
}
impl VoiceId {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoiceId::Aditi => "Aditi",
            VoiceId::Adriano => "Adriano",
            VoiceId::Amy => "Amy",
            VoiceId::Andres => "Andres",
            VoiceId::Aria => "Aria",
            VoiceId::Arlet => "Arlet",
            VoiceId::Arthur => "Arthur",
            VoiceId::Astrid => "Astrid",
            VoiceId::Ayanda => "Ayanda",
            VoiceId::Bianca => "Bianca",
            VoiceId::Brian => "Brian",
            VoiceId::Burcu => "Burcu",
            VoiceId::Camila => "Camila",
            VoiceId::Carla => "Carla",
            VoiceId::Carmen => "Carmen",
            VoiceId::Celine => "Celine",
            VoiceId::Chantal => "Chantal",
            VoiceId::Conchita => "Conchita",
            VoiceId::Cristiano => "Cristiano",
            VoiceId::Daniel => "Daniel",
            VoiceId::Danielle => "Danielle",
            VoiceId::Dora => "Dora",
            VoiceId::Elin => "Elin",
            VoiceId::Emma => "Emma",
            VoiceId::Enrique => "Enrique",
            VoiceId::Ewa => "Ewa",
            VoiceId::Filiz => "Filiz",
            VoiceId::Gabrielle => "Gabrielle",
            VoiceId::Geraint => "Geraint",
            VoiceId::Giorgio => "Giorgio",
            VoiceId::Gregory => "Gregory",
            VoiceId::Gwyneth => "Gwyneth",
            VoiceId::Hala => "Hala",
            VoiceId::Hannah => "Hannah",
            VoiceId::Hans => "Hans",
            VoiceId::Hiujin => "Hiujin",
            VoiceId::Ida => "Ida",
            VoiceId::Ines => "Ines",
            VoiceId::Isabelle => "Isabelle",
            VoiceId::Ivy => "Ivy",
            VoiceId::Jacek => "Jacek",
            VoiceId::Jan => "Jan",
            VoiceId::Jasmine => "Jasmine",
            VoiceId::Jihye => "Jihye",
            VoiceId::Jitka => "Jitka",
            VoiceId::Joanna => "Joanna",
            VoiceId::Joey => "Joey",
            VoiceId::Justin => "Justin",
            VoiceId::Kajal => "Kajal",
            VoiceId::Karl => "Karl",
            VoiceId::Kazuha => "Kazuha",
            VoiceId::Kendra => "Kendra",
            VoiceId::Kevin => "Kevin",
            VoiceId::Kimberly => "Kimberly",
            VoiceId::Laura => "Laura",
            VoiceId::Lea => "Lea",
            VoiceId::Liam => "Liam",
            VoiceId::Lisa => "Lisa",
            VoiceId::Liv => "Liv",
            VoiceId::Lotte => "Lotte",
            VoiceId::Lucia => "Lucia",
            VoiceId::Lupe => "Lupe",
            VoiceId::Mads => "Mads",
            VoiceId::Maja => "Maja",
            VoiceId::Marlene => "Marlene",
            VoiceId::Mathieu => "Mathieu",
            VoiceId::Matthew => "Matthew",
            VoiceId::Maxim => "Maxim",
            VoiceId::Mia => "Mia",
            VoiceId::Miguel => "Miguel",
            VoiceId::Mizuki => "Mizuki",
            VoiceId::Naja => "Naja",
            VoiceId::Niamh => "Niamh",
            VoiceId::Nicole => "Nicole",
            VoiceId::Ola => "Ola",
            VoiceId::Olivia => "Olivia",
            VoiceId::Pedro => "Pedro",
            VoiceId::Penelope => "Penelope",
            VoiceId::Raveena => "Raveena",
            VoiceId::Remi => "Remi",
            VoiceId::Ricardo => "Ricardo",
            VoiceId::Ruben => "Ruben",
            VoiceId::Russell => "Russell",
            VoiceId::Ruth => "Ruth",
            VoiceId::Sabrina => "Sabrina",
            VoiceId::Salli => "Salli",
            VoiceId::Seoyeon => "Seoyeon",
            VoiceId::Sergio => "Sergio",
            VoiceId::Sofie => "Sofie",
            VoiceId::Stephen => "Stephen",
            VoiceId::Suvi => "Suvi",
            VoiceId::Takumi => "Takumi",
            VoiceId::Tatyana => "Tatyana",
            VoiceId::Thiago => "Thiago",
            VoiceId::Tomoko => "Tomoko",
            VoiceId::Vicki => "Vicki",
            VoiceId::Vitoria => "Vitoria",
            VoiceId::Zayd => "Zayd",
            VoiceId::Zeina => "Zeina",
            VoiceId::Zhiyu => "Zhiyu",
            VoiceId::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "Aditi",
            "Adriano",
            "Amy",
            "Andres",
            "Aria",
            "Arlet",
            "Arthur",
            "Astrid",
            "Ayanda",
            "Bianca",
            "Brian",
            "Burcu",
            "Camila",
            "Carla",
            "Carmen",
            "Celine",
            "Chantal",
            "Conchita",
            "Cristiano",
            "Daniel",
            "Danielle",
            "Dora",
            "Elin",
            "Emma",
            "Enrique",
            "Ewa",
            "Filiz",
            "Gabrielle",
            "Geraint",
            "Giorgio",
            "Gregory",
            "Gwyneth",
            "Hala",
            "Hannah",
            "Hans",
            "Hiujin",
            "Ida",
            "Ines",
            "Isabelle",
            "Ivy",
            "Jacek",
            "Jan",
            "Jasmine",
            "Jihye",
            "Jitka",
            "Joanna",
            "Joey",
            "Justin",
            "Kajal",
            "Karl",
            "Kazuha",
            "Kendra",
            "Kevin",
            "Kimberly",
            "Laura",
            "Lea",
            "Liam",
            "Lisa",
            "Liv",
            "Lotte",
            "Lucia",
            "Lupe",
            "Mads",
            "Maja",
            "Marlene",
            "Mathieu",
            "Matthew",
            "Maxim",
            "Mia",
            "Miguel",
            "Mizuki",
            "Naja",
            "Niamh",
            "Nicole",
            "Ola",
            "Olivia",
            "Pedro",
            "Penelope",
            "Raveena",
            "Remi",
            "Ricardo",
            "Ruben",
            "Russell",
            "Ruth",
            "Sabrina",
            "Salli",
            "Seoyeon",
            "Sergio",
            "Sofie",
            "Stephen",
            "Suvi",
            "Takumi",
            "Tatyana",
            "Thiago",
            "Tomoko",
            "Vicki",
            "Vitoria",
            "Zayd",
            "Zeina",
            "Zhiyu",
        ]
    }
}
impl ::std::convert::AsRef<str> for VoiceId {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl VoiceId {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for VoiceId {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            VoiceId::Aditi => write!(f, "Aditi"),
            VoiceId::Adriano => write!(f, "Adriano"),
            VoiceId::Amy => write!(f, "Amy"),
            VoiceId::Andres => write!(f, "Andres"),
            VoiceId::Aria => write!(f, "Aria"),
            VoiceId::Arlet => write!(f, "Arlet"),
            VoiceId::Arthur => write!(f, "Arthur"),
            VoiceId::Astrid => write!(f, "Astrid"),
            VoiceId::Ayanda => write!(f, "Ayanda"),
            VoiceId::Bianca => write!(f, "Bianca"),
            VoiceId::Brian => write!(f, "Brian"),
            VoiceId::Burcu => write!(f, "Burcu"),
            VoiceId::Camila => write!(f, "Camila"),
            VoiceId::Carla => write!(f, "Carla"),
            VoiceId::Carmen => write!(f, "Carmen"),
            VoiceId::Celine => write!(f, "Celine"),
            VoiceId::Chantal => write!(f, "Chantal"),
            VoiceId::Conchita => write!(f, "Conchita"),
            VoiceId::Cristiano => write!(f, "Cristiano"),
            VoiceId::Daniel => write!(f, "Daniel"),
            VoiceId::Danielle => write!(f, "Danielle"),
            VoiceId::Dora => write!(f, "Dora"),
            VoiceId::Elin => write!(f, "Elin"),
            VoiceId::Emma => write!(f, "Emma"),
            VoiceId::Enrique => write!(f, "Enrique"),
            VoiceId::Ewa => write!(f, "Ewa"),
            VoiceId::Filiz => write!(f, "Filiz"),
            VoiceId::Gabrielle => write!(f, "Gabrielle"),
            VoiceId::Geraint => write!(f, "Geraint"),
            VoiceId::Giorgio => write!(f, "Giorgio"),
            VoiceId::Gregory => write!(f, "Gregory"),
            VoiceId::Gwyneth => write!(f, "Gwyneth"),
            VoiceId::Hala => write!(f, "Hala"),
            VoiceId::Hannah => write!(f, "Hannah"),
            VoiceId::Hans => write!(f, "Hans"),
            VoiceId::Hiujin => write!(f, "Hiujin"),
            VoiceId::Ida => write!(f, "Ida"),
            VoiceId::Ines => write!(f, "Ines"),
            VoiceId::Isabelle => write!(f, "Isabelle"),
            VoiceId::Ivy => write!(f, "Ivy"),
            VoiceId::Jacek => write!(f, "Jacek"),
            VoiceId::Jan => write!(f, "Jan"),
            VoiceId::Jasmine => write!(f, "Jasmine"),
            VoiceId::Jihye => write!(f, "Jihye"),
            VoiceId::Jitka => write!(f, "Jitka"),
            VoiceId::Joanna => write!(f, "Joanna"),
            VoiceId::Joey => write!(f, "Joey"),
            VoiceId::Justin => write!(f, "Justin"),
            VoiceId::Kajal => write!(f, "Kajal"),
            VoiceId::Karl => write!(f, "Karl"),
            VoiceId::Kazuha => write!(f, "Kazuha"),
            VoiceId::Kendra => write!(f, "Kendra"),
            VoiceId::Kevin => write!(f, "Kevin"),
            VoiceId::Kimberly => write!(f, "Kimberly"),
            VoiceId::Laura => write!(f, "Laura"),
            VoiceId::Lea => write!(f, "Lea"),
            VoiceId::Liam => write!(f, "Liam"),
            VoiceId::Lisa => write!(f, "Lisa"),
            VoiceId::Liv => write!(f, "Liv"),
            VoiceId::Lotte => write!(f, "Lotte"),
            VoiceId::Lucia => write!(f, "Lucia"),
            VoiceId::Lupe => write!(f, "Lupe"),
            VoiceId::Mads => write!(f, "Mads"),
            VoiceId::Maja => write!(f, "Maja"),
            VoiceId::Marlene => write!(f, "Marlene"),
            VoiceId::Mathieu => write!(f, "Mathieu"),
            VoiceId::Matthew => write!(f, "Matthew"),
            VoiceId::Maxim => write!(f, "Maxim"),
            VoiceId::Mia => write!(f, "Mia"),
            VoiceId::Miguel => write!(f, "Miguel"),
            VoiceId::Mizuki => write!(f, "Mizuki"),
            VoiceId::Naja => write!(f, "Naja"),
            VoiceId::Niamh => write!(f, "Niamh"),
            VoiceId::Nicole => write!(f, "Nicole"),
            VoiceId::Ola => write!(f, "Ola"),
            VoiceId::Olivia => write!(f, "Olivia"),
            VoiceId::Pedro => write!(f, "Pedro"),
            VoiceId::Penelope => write!(f, "Penelope"),
            VoiceId::Raveena => write!(f, "Raveena"),
            VoiceId::Remi => write!(f, "Remi"),
            VoiceId::Ricardo => write!(f, "Ricardo"),
            VoiceId::Ruben => write!(f, "Ruben"),
            VoiceId::Russell => write!(f, "Russell"),
            VoiceId::Ruth => write!(f, "Ruth"),
            VoiceId::Sabrina => write!(f, "Sabrina"),
            VoiceId::Salli => write!(f, "Salli"),
            VoiceId::Seoyeon => write!(f, "Seoyeon"),
            VoiceId::Sergio => write!(f, "Sergio"),
            VoiceId::Sofie => write!(f, "Sofie"),
            VoiceId::Stephen => write!(f, "Stephen"),
            VoiceId::Suvi => write!(f, "Suvi"),
            VoiceId::Takumi => write!(f, "Takumi"),
            VoiceId::Tatyana => write!(f, "Tatyana"),
            VoiceId::Thiago => write!(f, "Thiago"),
            VoiceId::Tomoko => write!(f, "Tomoko"),
            VoiceId::Vicki => write!(f, "Vicki"),
            VoiceId::Vitoria => write!(f, "Vitoria"),
            VoiceId::Zayd => write!(f, "Zayd"),
            VoiceId::Zeina => write!(f, "Zeina"),
            VoiceId::Zhiyu => write!(f, "Zhiyu"),
            VoiceId::Unknown(value) => write!(f, "{}", value),
        }
    }
}
