// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DescribeVoicesInput {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.</p>
    pub engine: ::std::option::Option<crate::types::Engine>,
    /// <p>The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    pub include_additional_language_codes: ::std::option::Option<bool>,
    /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl DescribeVoicesInput {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.</p>
    pub fn engine(&self) -> ::std::option::Option<&crate::types::Engine> {
        self.engine.as_ref()
    }
    /// <p>The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    pub fn include_additional_language_codes(&self) -> ::std::option::Option<bool> {
        self.include_additional_language_codes
    }
    /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl DescribeVoicesInput {
    /// Creates a new builder-style object to manufacture [`DescribeVoicesInput`](crate::operation::describe_voices::DescribeVoicesInput).
    pub fn builder() -> crate::operation::describe_voices::builders::DescribeVoicesInputBuilder {
        crate::operation::describe_voices::builders::DescribeVoicesInputBuilder::default()
    }
}

/// A builder for [`DescribeVoicesInput`](crate::operation::describe_voices::DescribeVoicesInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DescribeVoicesInputBuilder {
    pub(crate) engine: ::std::option::Option<crate::types::Engine>,
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) include_additional_language_codes: ::std::option::Option<bool>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl DescribeVoicesInputBuilder {
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.</p>
    pub fn engine(mut self, input: crate::types::Engine) -> Self {
        self.engine = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.</p>
    pub fn set_engine(mut self, input: ::std::option::Option<crate::types::Engine>) -> Self {
        self.engine = input;
        self
    }
    /// <p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) used by Amazon Polly when processing input text for speech synthesis.</p>
    pub fn get_engine(&self) -> &::std::option::Option<crate::types::Engine> {
        &self.engine
    }
    /// <p>The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>The language identification tag (ISO 639 code for the language name-ISO 3166 country code) for filtering the list of voices returned. If you don't specify this optional parameter, all available voices are returned.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    pub fn include_additional_language_codes(mut self, input: bool) -> Self {
        self.include_additional_language_codes = ::std::option::Option::Some(input);
        self
    }
    /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    pub fn set_include_additional_language_codes(mut self, input: ::std::option::Option<bool>) -> Self {
        self.include_additional_language_codes = input;
        self
    }
    /// <p>Boolean value indicating whether to return any bilingual voices that use the specified language as an additional language. For instance, if you request all languages that use US English (es-US), and there is an Italian voice that speaks both Italian (it-IT) and US English, that voice will be included if you specify <code>yes</code> but not if you specify <code>no</code>.</p>
    pub fn get_include_additional_language_codes(&self) -> &::std::option::Option<bool> {
        &self.include_additional_language_codes
    }
    /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>An opaque pagination token returned from the previous <code>DescribeVoices</code> operation. If present, this indicates where to continue the listing.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`DescribeVoicesInput`](crate::operation::describe_voices::DescribeVoicesInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::describe_voices::DescribeVoicesInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::describe_voices::DescribeVoicesInput {
            engine: self.engine,
            language_code: self.language_code,
            include_additional_language_codes: self.include_additional_language_codes,
            next_token: self.next_token,
        })
    }
}
